package com.macrofocus.common.units

import com.macrofocus.common.math.RADIANS_TO_DEGREES

class PhaseAngle(name: String, symbol: String, ratio: Double) : Angle(name, symbol, ratio) {
    companion object Factory {
        val Degree = PhaseAngle("Degree", "°", 1.0)
        val Radian = PhaseAngle("Radian", "rad", RADIANS_TO_DEGREES)
    }
}