/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.collection

import java.util.concurrent.ConcurrentHashMap

class ConcurrentHashSet<K> : MutableSet<K?> {
    private val map: ConcurrentHashMap<K?, K?>? = ConcurrentHashMap<K?, K?>()

    override fun add(element: K?): Boolean {
        val contains = map!!.containsKey(element)
        map[element] = element
        return !contains
    }

    override fun addAll(elements: Collection<K?>): Boolean {
        var changed = false
        for (element in elements) {
            changed = add(element) || changed
        }
        return changed
    }

    override fun clear() {
        map!!.clear()
    }

    override fun contains(element: K?): Boolean {
        return map!!.containsKey(element)
    }

    override fun containsAll(elements: Collection<K?>): Boolean {
        for (o in elements) {
            if (!contains(o)) return false
        }
        return true
    }

    override fun isEmpty(): Boolean {
        return map!!.size == 0
    }

    override fun iterator(): MutableIterator<K?> {
        return map!!.values.iterator()
    }

    override fun remove(element: K?): Boolean {
        return map!!.remove(element) != null
    }

    override fun removeAll(elements: Collection<K?>): Boolean {
        var changed = false
        for (o in elements) {
            changed = remove(o) || changed
        }
        return changed
    }

    override fun retainAll(elements: Collection<K?>): Boolean {
        clear()
        for (element in elements) {
            add(element)
        }
        return true
    }

    override val size: Int
        get() = map!!.size

    fun toArray(): Array<Any?>? {
        return map!!.values.toTypedArray()
    }
}