package com.macrofocus.common.crossplatform

import com.macrofocus.common.concurrent.ExecutorService
import com.macrofocus.common.timer.CPTimer
import com.macrofocus.common.timer.CPTimerListener
import com.macrofocus.common.timer.SwingTimer
import kotlin.reflect.KClass

actual class CPHelper {
    actual companion object {
        actual val instance = CPHelper()
    }

    actual fun newFixedThreadPool(
        name: String,
        corePoolSize: Int,
        maximumPoolSize: Int
    ): ExecutorService? {
       return null
    }

    actual fun createTimer(
        name: String,
        delay: Int,
        postponing: Boolean
    ): CPTimer {
        return SwingTimer(name, delay, 10000, postponing)
    }

    actual fun createTimer(
        name: String,
        delay: Int,
        postponing: Boolean,
        timerListener: CPTimerListener
    ): CPTimer {
        val timer = createTimer(name, delay, postponing)
        timer.addTimerListener(timerListener)
        return timer
    }

    /**
     * Causes the currently executing thread to sleep (temporarily cease
     * execution) for the specified number of milliseconds, subject to
     * the precision and accuracy of system timers and schedulers. The thread
     * does not lose ownership of any monitors.
     *
     * @param  millis
     * the length of time to sleep in milliseconds
     *
     * @throws  IllegalArgumentException
     * if the value of `millis` is negative
     *
     * @throws  InterruptedException
     * if any thread has interrupted the current thread. The
     * *interrupted status* of the current thread is
     * cleared when this exception is thrown.
     */
    actual fun sleep(millis: Long) {
        try {
            Thread.sleep(millis)
        } catch (e: InterruptedException) {
            e.printStackTrace()
        }
    }

    actual fun isAssignableFrom(a: KClass<*>, b: KClass<*>): Boolean {
        return a.java.isAssignableFrom(b.java)
    }

    actual fun isNumericType(cl: KClass<*>): Boolean {
        return cl != null && (isAssignableFrom(Number::class, cl)
                || cl == Double::class.javaPrimitiveType || cl == Int::class.javaPrimitiveType || cl == Float::class.javaPrimitiveType || cl == Short::class.javaPrimitiveType || cl == Long::class.javaPrimitiveType)    }

    actual fun isTemporalType(cl: KClass<*>): Boolean {
//        return cl != null && (isAssignableFrom(Date::class.java, cl) || isAssignableFrom(Calendar::class.java, cl)
//                || cl == Double::class.javaPrimitiveType || cl == Long::class.javaPrimitiveType)
        TODO("Not yet implemented")
    }

    actual fun isVisualType(cl: KClass<*>): Boolean {
//        return cl != null && (isAssignableFrom(CPColor::class.java, cl) || isAssignableFrom(
//            CPIcon::class.java,
//            cl
//        ) || isAssignableFrom(
//            Image::class.java, cl
//        ))
        return false
//        TODO("Not yet implemented")
    }

    actual fun isArray(cl: KClass<*>): Boolean {
        return cl.java.isArray
    }

    actual val isMac: Boolean by lazy {
        val os = System.getProperty("os.name").toLowerCase()
        os != null && "mac os x" == os
    }

    /** Current UNIX time in millis */
    actual val currentTimeMillis: Long
        get() = System.currentTimeMillis()
}