/*
 * Copyright 2011 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.macrofocus.common.json

import java.io.IOException
import java.io.ObjectInputStream

/**
 * JRE (non-Client) implementation of JreJsonValue.
 */
abstract class JavaJsonValue : JsonValue {
    abstract val `object`: Any
    abstract fun traverse(visitor: JsonVisitor, ctx: JsonContext)
    override fun toNative(): Any {
        return this
    }

    @Throws(ClassNotFoundException::class, IOException::class)
    protected fun <T : JsonValue?> parseJson(stream: ObjectInputStream): T {
        val jsonString = stream.readObject() as String
        return Json.instance().parse(jsonString)
    }
}