/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.macrofocus.common.json

/**
 * Represents the current location where a value is stored, and allows
 * the value's replacement or deletion.
 */
abstract class JsonContext(value: JsonValue) {
    private var value: JsonValue

    /**
     * Whether or not the current context location within the value is the first
     * key or array index.
     */
    var isFirst = true

    /**
     * Return the underlying JsonValue (Array or Object) that backs the
     * context.
     */
    fun getValue(): JsonValue {
        return value
    }

    /**
     * Remove the current array index or key from the underlying json.
     */
    abstract fun removeMe()

    /**
     * Replace the current location's value with a double.
     */
    abstract fun replaceMe(d: Double)

    /**
     * Replace the current location's value with a String.
     */
    abstract fun replaceMe(d: String)

    /**
     * Replace the current location's value with a boolean.
     */
    abstract fun replaceMe(d: Boolean)

    /**
     * Replace the current location's value with a JsonValue.
     */
    abstract fun replaceMe(value: JsonValue?)
    fun setValue(value: JsonValue) {
        this.value = value
    }

    init {
        this.value = value
    }
}