package com.macrofocus.common.timer

import com.macrofocus.common.timer.Timer.TimerListener

class CoalescingTimer @JvmOverloads constructor(private val delay: Int, private val postponing: Boolean = true) :
    AbstractTimer(),Runnable {
    private var isLocked = true
    private var isAborted = false
    override var isScheduled = false
        private set
    private var isMutexed = false
    private val mutex: Object
    private val lockMutex: Object
    private val timerMutex: Object
    private var stopped = true

    constructor(delay: Int, listener: TimerListener?) : this(delay, true) {
        addActionListener(listener!!)
    }

    override fun run() {
        stopped = false
        while (!stopped) {
            lock()
            queue()
            try {
                synchronized(mutex) {
                    while (isMutexed) {
                        mutex.wait()
                    }
                }
                if (!stopped) {
                    trigger()
                }
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
    }

    override fun restart() {
        if (postponing) {
            if (isScheduled) {
                postpone()
            } else {
                unLock()
            }
        } else {
            if (!isScheduled) {
                unLock()
            }
        }
    }

    private fun queue() {
        try {
            synchronized(timerMutex) {
                isScheduled = true
                while (isScheduled) {
                    timerMutex.wait(delay.toLong())
                    if (!isAborted) {
                        synchronized(mutex) {
                            isMutexed = false
                            mutex.notifyAll()
                            isScheduled = false
                        }
                    } else {
                        isAborted = false
                    }
                }
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    private fun postpone() {
        synchronized(timerMutex) {
            isAborted = true
            timerMutex.notify()
        }
    }

    private fun lock() {
        synchronized(lockMutex) {
            while (isLocked) {
                try {
                    lockMutex.wait()
                } catch (e: Exception) {
                }
            }
            isLocked = true
        }
    }

    private fun unLock() {
        synchronized(lockMutex) {
            isLocked = false
            lockMutex.notifyAll()
        }
    }

    private fun trigger() {
        fireTimerTriggered()
    }

    override fun stop() {
        stopped = true
        if (isScheduled) {
            postpone()
        } else {
            unLock()
        }
    }

    override fun toString(): String {
        return "CoalescingTimer{" +
                "postponing=" + postponing +
                ", delay=" + delay +
                ", isLocked=" + isLocked +
                ", isAborted=" + isAborted +
                ", isScheduled=" + isScheduled +
                ", isMutexed=" + isMutexed +
                ", stopped=" + stopped +
                '}'
    }

    init {
        mutex = Object()
        lockMutex = Object()
        timerMutex = Object()
    }
}