/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010)\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0017\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000b2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00018\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0014\u001a\u00020\u000b2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0010H\u0016J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\u0011\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0017H\u0096\u0002J\u0017\u0010\u0018\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0019\u001a\u00020\u000b2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0010H\u0016J\u0018\u0010\u001a\u001a\u00020\u000b2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0010H\u0016J\u0015\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0018\u00010\u001c\u00a2\u0006\u0002\u0010\u001eR \u0010\u0004\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001f"}, d2={"Lcom/macrofocus/common/collection/ConcurrentHashSet;", "K", "", "()V", "map", "Ljava/util/concurrent/ConcurrentHashMap;", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "clear", "", "contains", "containsAll", "isEmpty", "iterator", "", "remove", "removeAll", "retainAll", "toArray", "", "", "()[Ljava/lang/Object;", "macrofocus-common"})
public final class ConcurrentHashSet<K>
implements Set<K>,
KMutableSet {
    private final ConcurrentHashMap<K, K> map = new ConcurrentHashMap();

    @Override
    public boolean add(@Nullable K element) {
        ConcurrentHashMap<K, K> concurrentHashMap = this.map;
        Intrinsics.checkNotNull(concurrentHashMap);
        boolean contains = concurrentHashMap.containsKey(element);
        ((Map)this.map).put(element, element);
        return !contains;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends K> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean changed = false;
        for (K element : elements) {
            changed = this.add(element) || changed;
        }
        return changed;
    }

    @Override
    public void clear() {
        ConcurrentHashMap<K, K> concurrentHashMap = this.map;
        Intrinsics.checkNotNull(concurrentHashMap);
        concurrentHashMap.clear();
    }

    @Override
    public boolean contains(@Nullable Object element) {
        ConcurrentHashMap<K, K> concurrentHashMap = this.map;
        Intrinsics.checkNotNull(concurrentHashMap);
        return concurrentHashMap.containsKey(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        for (Object object : elements) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        ConcurrentHashMap<K, K> concurrentHashMap = this.map;
        Intrinsics.checkNotNull(concurrentHashMap);
        return concurrentHashMap.size() == 0;
    }

    @Override
    @NotNull
    public Iterator<K> iterator() {
        ConcurrentHashMap<K, K> concurrentHashMap = this.map;
        Intrinsics.checkNotNull(concurrentHashMap);
        return concurrentHashMap.values().iterator();
    }

    @Override
    public boolean remove(@Nullable Object element) {
        ConcurrentHashMap<K, K> concurrentHashMap = this.map;
        Intrinsics.checkNotNull(concurrentHashMap);
        return concurrentHashMap.remove(element) != null;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean changed = false;
        for (Object object : elements) {
            changed = this.remove(object) || changed;
        }
        return changed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.clear();
        for (Object object : elements) {
            this.add((K)object);
        }
        return true;
    }

    public int getSize() {
        ConcurrentHashMap<K, K> concurrentHashMap = this.map;
        Intrinsics.checkNotNull(concurrentHashMap);
        return concurrentHashMap.size();
    }

    @Override
    @Nullable
    public final Object[] toArray() {
        ConcurrentHashMap<K, K> concurrentHashMap = this.map;
        Intrinsics.checkNotNull(concurrentHashMap);
        Collection<K> collection = concurrentHashMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"map!!.values");
        Collection<K> $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection<K> thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return CollectionToArray.toArray((Collection)this, (Object[])TArray);
    }
}

