/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.collection;

import com.macrofocus.common.collection.ConcurrentHashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableSet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010)\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0016\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0016J\b\u0010\u0017\u001a\u00020\rH\u0016J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0096\u0002J\u0015\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u001b\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0016J\u0016\u0010\u001c\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0016J\u0013\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001e\u00a2\u0006\u0002\u0010 J%\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H!0\u001e\"\u0004\b\u0001\u0010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0\u001e\u00a2\u0006\u0002\u0010#R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006$"}, d2={"Lcom/macrofocus/common/collection/ConcurrentLinkedHashSet;", "K", "", "()V", "holder", "Ljava/util/concurrent/CopyOnWriteArrayList;", "set", "Lcom/macrofocus/common/collection/ConcurrentHashSet;", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "clear", "", "contains", "containsAll", "isEmpty", "iterator", "", "remove", "removeAll", "retainAll", "toArray", "", "", "()[Ljava/lang/Object;", "T", "a", "([Ljava/lang/Object;)[Ljava/lang/Object;", "macrofocus-common"})
public final class ConcurrentLinkedHashSet<K>
implements Set<K>,
KMutableSet {
    private final ConcurrentHashSet<K> set = new ConcurrentHashSet();
    private final CopyOnWriteArrayList<K> holder = new CopyOnWriteArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(K element) {
        if (this.set.contains(element)) {
            return false;
        }
        ConcurrentHashSet<K> concurrentHashSet = this.set;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (concurrentHashSet) {
            boolean bl3 = false;
            this.set.add(element);
            bl2 = this.holder.add(element);
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends K> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean changed = false;
        for (K element : elements) {
            changed = this.add(element) || changed;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ConcurrentHashSet<K> concurrentHashSet = this.set;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (concurrentHashSet) {
            boolean bl3 = false;
            this.set.clear();
            this.holder.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public boolean contains(Object element) {
        return this.set.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        for (Object object : elements) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        CopyOnWriteArrayList<K> copyOnWriteArrayList = this.holder;
        Intrinsics.checkNotNull(copyOnWriteArrayList);
        return copyOnWriteArrayList.size() == 0;
    }

    @Override
    @NotNull
    public Iterator<K> iterator() {
        CopyOnWriteArrayList<K> copyOnWriteArrayList = this.holder;
        Intrinsics.checkNotNull(copyOnWriteArrayList);
        Iterator<K> iterator2 = copyOnWriteArrayList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"holder!!.iterator()");
        return iterator2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object element) {
        ConcurrentHashSet<K> concurrentHashSet = this.set;
        Intrinsics.checkNotNull(concurrentHashSet);
        if (!concurrentHashSet.contains(element)) {
            return false;
        }
        ConcurrentHashSet<K> concurrentHashSet2 = this.set;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (concurrentHashSet2) {
            boolean bl3 = false;
            this.set.remove(element);
            CopyOnWriteArrayList<K> copyOnWriteArrayList = this.holder;
            Intrinsics.checkNotNull(copyOnWriteArrayList);
            bl2 = copyOnWriteArrayList.remove(element);
        }
        return true;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean changed = false;
        for (Object object : elements) {
            changed = this.remove(object) || changed;
        }
        return changed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.clear();
        for (Object object : elements) {
            this.add((K)object);
        }
        return true;
    }

    public int getSize() {
        return this.holder.size();
    }

    @Override
    @NotNull
    public final Object[] toArray() {
        Collection $this$toTypedArray$iv = this.holder;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return objectArray;
    }

    @Override
    @NotNull
    public final <T> T[] toArray(@NotNull T[] a) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        T[] TArray = this.holder.toArray(a);
        Intrinsics.checkNotNullExpressionValue(TArray, (String)"holder.toArray(a)");
        return TArray;
    }
}

