/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.json;

import com.macrofocus.common.json.JavaJsonValue;
import com.macrofocus.common.json.Json;
import com.macrofocus.common.json.JsonArray;
import com.macrofocus.common.json.JsonArrayContext;
import com.macrofocus.common.json.JsonBoolean;
import com.macrofocus.common.json.JsonContext;
import com.macrofocus.common.json.JsonFactory;
import com.macrofocus.common.json.JsonNumber;
import com.macrofocus.common.json.JsonObject;
import com.macrofocus.common.json.JsonString;
import com.macrofocus.common.json.JsonType;
import com.macrofocus.common.json.JsonUtil;
import com.macrofocus.common.json.JsonValue;
import com.macrofocus.common.json.JsonVisitor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 62\u00020\u00012\u00020\u0002:\u00016B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\"\u0010\u0018\u001a\u0002H\u0019\"\n\b\u0000\u0010\u0019*\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0096\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\"\u001a\u00020\u00132\b\u0010#\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010$\u001a\u00020\u001bH\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020&2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001b\u0010*\u001a\u00020&2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010#\u001a\u0004\u0018\u00010\bH\u0096\u0002J\u0019\u0010*\u001a\u00020&2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u0013H\u0096\u0002J\u0019\u0010*\u001a\u00020&2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u0015H\u0096\u0002J\u0019\u0010*\u001a\u00020&2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u0017H\u0096\u0002J\b\u0010.\u001a\u00020\u0017H\u0016J\u0018\u0010/\u001a\u00020&2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020&2\u0006\u0010'\u001a\u000205H\u0002R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00067"}, d2={"Lcom/macrofocus/common/json/JavaJsonArray;", "Lcom/macrofocus/common/json/JavaJsonValue;", "Lcom/macrofocus/common/json/JsonArray;", "factory", "Lcom/macrofocus/common/json/JsonFactory;", "(Lcom/macrofocus/common/json/JsonFactory;)V", "arrayValues", "Ljava/util/ArrayList;", "Lcom/macrofocus/common/json/JsonValue;", "Lkotlin/collections/ArrayList;", "object", "", "getObject", "()Ljava/lang/Object;", "type", "Lcom/macrofocus/common/json/JsonType;", "getType", "()Lcom/macrofocus/common/json/JsonType;", "asBoolean", "", "asNumber", "", "asString", "", "get", "T", "index", "", "(I)Lcom/macrofocus/common/json/JsonValue;", "getArray", "getBoolean", "getNumber", "Lcom/macrofocus/common/json/JsonObject;", "getString", "jsEquals", "value", "length", "readObject", "", "stream", "Ljava/io/ObjectInputStream;", "remove", "set", "bool", "number", "string", "toJson", "traverse", "visitor", "Lcom/macrofocus/common/json/JsonVisitor;", "ctx", "Lcom/macrofocus/common/json/JsonContext;", "writeObject", "Ljava/io/ObjectOutputStream;", "Companion", "macrofocus-common"})
public final class JavaJsonArray
extends JavaJsonValue
implements JsonArray {
    private ArrayList<JsonValue> arrayValues;
    private JsonFactory factory;
    private static final long serialVersionUID = 1L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean asBoolean() {
        return true;
    }

    @Override
    public double asNumber() {
        double d;
        switch (this.length()) {
            case 0: {
                d = 0.0;
                break;
            }
            case 1: {
                Object t = this.get(0);
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.macrofocus.common.json.JsonValue");
                }
                d = t.asNumber();
                break;
            }
            default: {
                d = Double.NaN;
            }
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String asString() {
        StringBuilder toReturn = new StringBuilder();
        int n = 0;
        int n2 = this.length();
        while (n < n2) {
            void i;
            if (i > 0) {
                toReturn.append(", ");
            }
            Object t = this.get((int)i);
            if (t == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.macrofocus.common.json.JsonValue");
            }
            toReturn.append(t.asString());
            ++i;
        }
        String string = toReturn.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toReturn.toString()");
        return string;
    }

    @Override
    public <T extends JsonValue> T get(int index) {
        return (T)this.arrayValues.get(index);
    }

    @Override
    @NotNull
    public JsonArray getArray(int index) {
        Object t = this.get(index);
        if (t == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.macrofocus.common.json.JsonArray");
        }
        return (JsonArray)t;
    }

    @Override
    public boolean getBoolean(int index) {
        Object t = this.get(index);
        if (t == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.macrofocus.common.json.JsonBoolean");
        }
        return ((JsonBoolean)t).getBoolean();
    }

    @Override
    public double getNumber(int index) {
        Object t = this.get(index);
        if (t == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.macrofocus.common.json.JsonNumber");
        }
        return ((JsonNumber)t).getNumber();
    }

    @Override
    @NotNull
    public JsonObject getObject(int index) {
        Object t = this.get(index);
        if (t == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.macrofocus.common.json.JsonObject");
        }
        return (JsonObject)t;
    }

    @Override
    @NotNull
    public Object getObject() {
        List objs = new ArrayList();
        Iterator<JsonValue> iterator2 = this.arrayValues.iterator();
        while (iterator2.hasNext()) {
            JsonValue val;
            JsonValue jsonValue = val = iterator2.next();
            if (jsonValue == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.macrofocus.common.json.JavaJsonValue");
            }
            objs.add(((JavaJsonValue)jsonValue).getObject());
        }
        return objs;
    }

    @Override
    @NotNull
    public String getString(int index) {
        Object t = this.get(index);
        if (t == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.macrofocus.common.json.JsonString");
        }
        return ((JsonString)t).getString();
    }

    @Override
    @NotNull
    public JsonType getType() {
        return JsonType.ARRAY;
    }

    @Override
    public boolean jsEquals(@Nullable JsonValue value) {
        JsonValue jsonValue = value;
        if (jsonValue == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.macrofocus.common.json.JavaJsonValue");
        }
        return Intrinsics.areEqual((Object)this.getObject(), (Object)((JavaJsonValue)jsonValue).getObject());
    }

    @Override
    public int length() {
        return this.arrayValues.size();
    }

    @Override
    public void remove(int index) {
        this.arrayValues.remove(index);
    }

    @Override
    public void set(int index, @Nullable JsonValue value) {
        JsonValue value2 = value;
        if (value2 == null) {
            value2 = this.factory.createNull();
        }
        if (index == this.arrayValues.size()) {
            this.arrayValues.add(index, value2);
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)this.arrayValues.set(index, value2), (String)"arrayValues.set(index, value)");
        }
    }

    @Override
    public void set(int index, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this.set(index, this.factory.create(string));
    }

    @Override
    public void set(int index, double number) {
        this.set(index, this.factory.create(number));
    }

    @Override
    public void set(int index, boolean bool) {
        this.set(index, this.factory.create(bool));
    }

    @Override
    @NotNull
    public String toJson() {
        return JsonUtil.INSTANCE.stringify(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void traverse(@NotNull JsonVisitor visitor, @NotNull JsonContext ctx) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (visitor.visit(this, ctx)) {
            JsonArrayContext arrayCtx = new JsonArrayContext(this);
            int n = 0;
            int n2 = this.length();
            while (n < n2) {
                void i;
                arrayCtx.setCurrentIndex((int)i);
                if (visitor.visitIndex(arrayCtx.getCurrentIndex(), arrayCtx)) {
                    visitor.accept((JsonValue)this.get((int)i), arrayCtx);
                    arrayCtx.setFirst(false);
                }
                ++i;
            }
        }
        visitor.endVisit(this, ctx);
    }

    private final void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        JavaJsonArray instance = (JavaJsonArray)this.parseJson(stream);
        this.factory = Json.INSTANCE.instance();
        this.arrayValues = instance.arrayValues;
    }

    private final void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.toJson());
    }

    public JavaJsonArray(@NotNull JsonFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this.arrayValues = new ArrayList();
        this.factory = factory;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/macrofocus/common/json/JavaJsonArray$Companion;", "", "()V", "serialVersionUID", "", "macrofocus-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

