/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.json;

import com.macrofocus.common.json.Json;
import com.macrofocus.common.json.JsonArray;
import com.macrofocus.common.json.JsonContext;
import com.macrofocus.common.json.JsonException;
import com.macrofocus.common.json.JsonObject;
import com.macrofocus.common.json.JsonValue;
import com.macrofocus.common.json.JsonVisitor;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u001f\u0010\f\u001a\u0002H\r\"\n\b\u0000\u0010\r*\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000eJ\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0019"}, d2={"Lcom/macrofocus/common/json/JsonUtil;", "", "()V", "escapeCharAsUnicode", "", "toEscape", "", "escapeControlChars", "text", "isControlChar", "", "c", "parse", "T", "Lcom/macrofocus/common/json/JsonValue;", "json", "(Ljava/lang/String;)Lcom/macrofocus/common/json/JsonValue;", "quote", "value", "stringify", "jsonValue", "spaces", "", "indent", "StringifyJsonVisitor", "macrofocus-common"})
public final class JsonUtil {
    @NotNull
    public static final JsonUtil INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String escapeControlChars(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        StringBuilder toReturn = new StringBuilder();
        int n = 0;
        int n2 = text.length();
        while (n < n2) {
            void i;
            char c = text.charAt((int)i);
            if (this.isControlChar(c)) {
                toReturn.append(this.escapeCharAsUnicode(c));
            } else {
                toReturn.append(c);
            }
            ++i;
        }
        String string = toReturn.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toReturn.toString()");
        return string;
    }

    public final <T extends JsonValue> T parse(@NotNull String json) throws JsonException {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return Json.INSTANCE.instance().parse(json);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String quote(@Nullable String value) {
        StringBuilder toReturn = new StringBuilder("\"");
        int n = 0;
        String string = value;
        Intrinsics.checkNotNull((Object)string);
        int n2 = string.length();
        while (n < n2) {
            void i;
            char c = value.charAt((int)i);
            String toAppend = String.valueOf(c);
            switch (c) {
                case '\b': {
                    toAppend = "\\b";
                    break;
                }
                case '\t': {
                    toAppend = "\\t";
                    break;
                }
                case '\n': {
                    toAppend = "\\n";
                    break;
                }
                case '\r': {
                    toAppend = "\\r";
                    break;
                }
                case '\"': {
                    toAppend = "\\\"";
                    break;
                }
                case '\\': {
                    toAppend = "\\\\";
                    break;
                }
                default: {
                    if (!this.isControlChar(c)) break;
                    toAppend = this.escapeCharAsUnicode(c);
                }
            }
            toReturn.append(toAppend);
            ++i;
        }
        toReturn.append("\"");
        String string2 = toReturn.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toReturn.toString()");
        return string2;
    }

    @NotNull
    public final String stringify(@NotNull JsonValue jsonValue) {
        Intrinsics.checkNotNullParameter((Object)jsonValue, (String)"jsonValue");
        return this.stringify(jsonValue, 0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String stringify(@NotNull JsonValue jsonValue, int spaces) {
        Intrinsics.checkNotNullParameter((Object)jsonValue, (String)"jsonValue");
        StringBuilder sb = new StringBuilder();
        int n = 0;
        int n2 = spaces;
        while (n < n2) {
            void i;
            sb.append(' ');
            ++i;
        }
        return this.stringify(jsonValue, sb.toString());
    }

    @NotNull
    public final String stringify(@NotNull JsonValue jsonValue, @Nullable String indent) {
        Intrinsics.checkNotNullParameter((Object)jsonValue, (String)"jsonValue");
        StringBuilder sb = new StringBuilder();
        boolean isPretty = indent != null && Intrinsics.areEqual((Object)"", (Object)indent) ^ true;
        new StringifyJsonVisitor(indent, sb, isPretty).accept(jsonValue);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String escapeCharAsUnicode(char toEscape) {
        String string = Integer.toString(toEscape, 16);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.Integer.toString(toEscape.toInt(), 16)");
        String hexValue = string;
        int padding = 4 - hexValue.length();
        StringBuilder stringBuilder = new StringBuilder().append("\\u");
        String string2 = "0000";
        int n = 0;
        boolean bl = false;
        String string3 = string2.substring(n, padding);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return stringBuilder.append(string3).append(hexValue).toString();
    }

    private final boolean isControlChar(char c) {
        return c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c == '\u00ad' || c == '\u070f' || c == '\u17b4' || c == '\u17b5' || c == '\ufeff' || Intrinsics.compare((int)c, (int)1536) >= 0 && Intrinsics.compare((int)c, (int)1540) <= 0 || Intrinsics.compare((int)c, (int)8204) >= 0 && Intrinsics.compare((int)c, (int)8207) <= 0 || Intrinsics.compare((int)c, (int)8232) >= 0 && Intrinsics.compare((int)c, (int)8239) <= 0 || Intrinsics.compare((int)c, (int)8288) >= 0 && Intrinsics.compare((int)c, (int)8303) <= 0 || Intrinsics.compare((int)c, (int)65520) >= 0 && Intrinsics.compare((int)c, (int)65535) <= 0;
    }

    private JsonUtil() {
    }

    static {
        JsonUtil jsonUtil;
        INSTANCE = jsonUtil = new JsonUtil();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u001c\u001a\u00020\u000f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\"\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/macrofocus/common/json/JsonUtil$StringifyJsonVisitor;", "Lcom/macrofocus/common/json/JsonVisitor;", "indent", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "pretty", "", "(Ljava/lang/String;Ljava/lang/StringBuilder;Z)V", "indentLevel", "visited", "", "Lcom/macrofocus/common/json/JsonValue;", "checkCycle", "", "value", "commaIfNotFirst", "ctx", "Lcom/macrofocus/common/json/JsonContext;", "endVisit", "array", "Lcom/macrofocus/common/json/JsonArray;", "object", "Lcom/macrofocus/common/json/JsonObject;", "format", "number", "", "visit", "bool", "string", "visitIndex", "index", "", "visitKey", "key", "visitNull", "Companion", "macrofocus-common"})
    private static final class StringifyJsonVisitor
    extends JsonVisitor {
        private String indentLevel;
        private final Set<JsonValue> visited;
        private final String indent;
        private final StringBuilder sb;
        private final boolean pretty;
        private static Set<String> skipKeys;
        @NotNull
        public static final Companion Companion;

        @Override
        public void endVisit(@NotNull JsonArray array, @NotNull JsonContext ctx) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            if (this.pretty) {
                String string = this.indentLevel;
                int n = 0;
                int n2 = this.indentLevel.length();
                String string2 = this.indent;
                Intrinsics.checkNotNull((Object)string2);
                int n3 = n2 - string2.length();
                boolean bl = false;
                String string3 = string;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n, n3);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                this.indentLevel = string4;
                this.sb.append('\n');
                this.sb.append(this.indentLevel);
            }
            this.sb.append("]");
            this.visited.remove(array);
        }

        @Override
        public void endVisit(@NotNull JsonObject object, @NotNull JsonContext ctx) {
            boolean bl;
            int n;
            int n2;
            Intrinsics.checkNotNullParameter((Object)object, (String)"object");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            if (this.pretty) {
                String string = this.indentLevel;
                n2 = 0;
                int n3 = this.indentLevel.length();
                String string2 = this.indent;
                Intrinsics.checkNotNull((Object)string2);
                n = n3 - string2.length();
                bl = false;
                String string3 = string;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n2, n);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                this.indentLevel = string4;
                this.sb.append('\n');
                this.sb.append(this.indentLevel);
            }
            this.sb.append("}");
            this.visited.remove(object);
            boolean bl2 = !this.visited.contains(object);
            n2 = 0;
            n = 0;
            if (_Assertions.ENABLED && !bl2) {
                bl = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }

        @Override
        public void visit(double number, @NotNull JsonContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.sb.append(Double.isInfinite(number) || Double.isNaN(number) ? "null" : this.format(number));
        }

        @Override
        public void visit(@Nullable String string, @NotNull JsonContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.sb.append(INSTANCE.quote(string));
        }

        @Override
        public void visit(boolean bool, @NotNull JsonContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.sb.append(bool);
        }

        @Override
        public boolean visit(@NotNull JsonArray array, @NotNull JsonContext ctx) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.checkCycle(array);
            this.sb.append("[");
            if (this.pretty) {
                this.sb.append('\n');
                this.indentLevel = this.indentLevel + this.indent;
                this.sb.append(this.indentLevel);
            }
            return true;
        }

        @Override
        public boolean visit(@NotNull JsonObject object, @NotNull JsonContext ctx) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"object");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.checkCycle(object);
            this.sb.append("{");
            if (this.pretty) {
                this.sb.append('\n');
                this.indentLevel = this.indentLevel + this.indent;
                this.sb.append(this.indentLevel);
            }
            return true;
        }

        @Override
        public boolean visitIndex(int index, @NotNull JsonContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.commaIfNotFirst(ctx);
            return true;
        }

        @Override
        public boolean visitKey(@Nullable String key, @NotNull JsonContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            if (Intrinsics.areEqual((Object)"", (Object)key)) {
                return true;
            }
            Set<String> set = skipKeys;
            Intrinsics.checkNotNull(set);
            if (CollectionsKt.contains((Iterable)set, (Object)key)) {
                return false;
            }
            this.commaIfNotFirst(ctx);
            this.sb.append(INSTANCE.quote(key) + ":");
            if (this.pretty) {
                this.sb.append(' ');
            }
            return true;
        }

        @Override
        public void visitNull(@NotNull JsonContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.sb.append("null");
        }

        private final void checkCycle(JsonValue value) {
            if (this.visited.contains(value)) {
                throw (Throwable)new JsonException("Cycled detected during stringify");
            }
            this.visited.add(value);
        }

        private final void commaIfNotFirst(JsonContext ctx) {
            if (!ctx.isFirst()) {
                this.sb.append(",");
                if (this.pretty) {
                    this.sb.append('\n');
                    this.sb.append(this.indentLevel);
                }
            }
        }

        private final String format(double number) {
            String n = String.valueOf(number);
            if (StringsKt.endsWith$default((String)n, (String)".0", (boolean)false, (int)2, null)) {
                String string = n;
                int n2 = 0;
                int n3 = n.length() - 2;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n2, n3);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                n = string3;
            }
            return n;
        }

        public StringifyJsonVisitor(@Nullable String indent, @NotNull StringBuilder sb, boolean pretty) {
            Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
            this.indent = indent;
            this.sb = sb;
            this.pretty = pretty;
            this.indentLevel = "";
            this.visited = new HashSet();
        }

        static {
            Companion = new Companion(null);
            Set toSkip = new HashSet();
            toSkip.add("$H");
            toSkip.add("__gwt_ObjectId");
            skipKeys = toSkip;
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/macrofocus/common/json/JsonUtil$StringifyJsonVisitor$Companion;", "", "()V", "skipKeys", "", "", "macrofocus-common"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

