/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.properties;

import com.macrofocus.common.properties.AbstractMutableProperty;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.properties.SimpleProperty;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0004J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0014J\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004J\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0004J\u0006\u0010\u001b\u001a\u00020\u001aR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00018\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u00008V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0011\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcom/macrofocus/common/properties/OverrideProperty;", "T", "Lcom/macrofocus/common/properties/AbstractMutableProperty;", "overrideDefaults", "Lcom/macrofocus/common/properties/MutableProperty;", "", "defaultProperty", "(Lcom/macrofocus/common/properties/MutableProperty;Lcom/macrofocus/common/properties/MutableProperty;)V", "getDefaultProperty", "()Lcom/macrofocus/common/properties/MutableProperty;", "overrideProperty", "overridePropertyListener", "Lcom/macrofocus/common/properties/PropertyListener;", "getOverridePropertyListener", "()Lcom/macrofocus/common/properties/PropertyListener;", "overrideValue", "getOverrideValue", "()Ljava/lang/Object;", "value", "getValue", "setValue", "(Ljava/lang/Object;)V", "addProperty", "createOverrideProperty", "getOverrideProperty", "removeProperty", "", "reset", "macrofocus-common"})
public class OverrideProperty<T>
extends AbstractMutableProperty<T> {
    private final MutableProperty<Boolean> overrideDefaults;
    @NotNull
    private final MutableProperty<T> defaultProperty;
    private MutableProperty<T> overrideProperty;
    @NotNull
    private final PropertyListener<T> overridePropertyListener;

    @NotNull
    protected MutableProperty<T> getDefaultProperty() {
        return this.defaultProperty;
    }

    @NotNull
    public final PropertyListener<T> getOverridePropertyListener() {
        return this.overridePropertyListener;
    }

    @Nullable
    public final MutableProperty<T> getOverrideProperty() {
        if (this.overrideProperty == null) {
            this.overrideProperty = this.createOverrideProperty();
        }
        return this.overrideProperty;
    }

    @NotNull
    protected MutableProperty<T> createOverrideProperty() {
        MutableProperty overrideProperty = SimpleProperty.Companion.newInstance(this.getDefaultProperty().getValue());
        return this.addProperty(overrideProperty);
    }

    @NotNull
    protected final MutableProperty<T> addProperty(@NotNull MutableProperty<T> overrideProperty) {
        Intrinsics.checkNotNullParameter(overrideProperty, (String)"overrideProperty");
        overrideProperty.addPropertyListener(this.overridePropertyListener);
        return overrideProperty;
    }

    protected final void removeProperty(@NotNull MutableProperty<T> overrideProperty) {
        Intrinsics.checkNotNullParameter(overrideProperty, (String)"overrideProperty");
        overrideProperty.removePropertyListener(this.overridePropertyListener);
    }

    @Override
    public T getValue() {
        T t;
        if (this.overrideDefaults.getValue().booleanValue() && this.overrideProperty != null) {
            MutableProperty<T> mutableProperty = this.overrideProperty;
            Intrinsics.checkNotNull(mutableProperty);
            t = mutableProperty.getValue();
        } else {
            t = this.getDefaultProperty().getValue();
        }
        return t;
    }

    @Override
    public void setValue(T value) {
        if (this.overrideDefaults.getValue().booleanValue()) {
            MutableProperty<T> mutableProperty = this.getOverrideProperty();
            Intrinsics.checkNotNull(mutableProperty);
            mutableProperty.setValue(value);
        } else {
            MutableProperty<T> mutableProperty = this.getDefaultProperty();
            Intrinsics.checkNotNull(mutableProperty);
            mutableProperty.setValue(value);
        }
    }

    @Nullable
    public final T getOverrideValue() {
        T t;
        if (this.overrideDefaults.getValue().booleanValue() && this.overrideProperty != null) {
            MutableProperty<T> mutableProperty = this.overrideProperty;
            Intrinsics.checkNotNull(mutableProperty);
            t = mutableProperty.getValue();
        } else {
            t = null;
        }
        return t;
    }

    public final void reset() {
        if (this.overrideDefaults.getValue().booleanValue() && this.overrideProperty != null) {
            MutableProperty<T> mutableProperty = this.overrideProperty;
            Intrinsics.checkNotNull(mutableProperty);
            T oldValue = mutableProperty.getValue();
            T newValue = this.getDefaultProperty().getValue();
            MutableProperty<T> mutableProperty2 = this.overrideProperty;
            Intrinsics.checkNotNull(mutableProperty2);
            this.removeProperty(mutableProperty2);
            this.overrideProperty = null;
            if (oldValue != newValue) {
                this.notifyPropertyChanged(new PropertyEvent<T>(oldValue, newValue));
            }
        }
        this.overrideProperty = null;
    }

    public OverrideProperty(final @NotNull MutableProperty<Boolean> overrideDefaults, final @NotNull MutableProperty<T> defaultProperty) {
        Intrinsics.checkNotNullParameter(overrideDefaults, (String)"overrideDefaults");
        Intrinsics.checkNotNullParameter(defaultProperty, (String)"defaultProperty");
        this.overridePropertyListener = new PropertyListener<T>(this, overrideDefaults){
            final /* synthetic */ OverrideProperty this$0;
            final /* synthetic */ MutableProperty $overrideDefaults;

            public void propertyChanged(@NotNull PropertyEvent<T> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                if (((Boolean)this.$overrideDefaults.getValue()).booleanValue()) {
                    this.this$0.notifyPropertyChanged(new PropertyEvent<T>(event.getOldValue(), event.getNewValue()));
                }
            }
            {
                this.this$0 = this$0;
                this.$overrideDefaults = $captured_local_variable$1;
            }
        };
        this.overrideDefaults = overrideDefaults;
        this.defaultProperty = defaultProperty;
        overrideDefaults.addPropertyListener(new PropertyListener<Boolean>(){

            @Override
            public void propertyChanged(@NotNull PropertyEvent<Boolean> event) {
                Object overrideValue;
                Object t;
                Intrinsics.checkNotNullParameter(event, (String)"event");
                Object defaultValue = defaultProperty.getValue();
                if (overrideProperty != null) {
                    MutableProperty mutableProperty = overrideProperty;
                    Intrinsics.checkNotNull((Object)mutableProperty);
                    t = mutableProperty.getValue();
                } else {
                    t = overrideValue = defaultValue;
                }
                if (defaultValue != overrideValue) {
                    if (event.getNewValue().booleanValue()) {
                        this.notifyPropertyChanged(new PropertyEvent(defaultValue, overrideValue));
                    } else {
                        this.notifyPropertyChanged(new PropertyEvent(overrideValue, defaultValue));
                    }
                }
            }
        });
        defaultProperty.addPropertyListener(new PropertyListener<T>(){

            @Override
            public void propertyChanged(@NotNull PropertyEvent<T> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                if (!((Boolean)overrideDefaults.getValue()).booleanValue()) {
                    this.notifyPropertyChanged(new PropertyEvent(event.getOldValue(), event.getNewValue()));
                }
            }
        });
    }

    public static final /* synthetic */ void access$setOverrideProperty$p(OverrideProperty $this, MutableProperty mutableProperty) {
        $this.overrideProperty = mutableProperty;
    }
}

