/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.properties;

import com.macrofocus.common.properties.AbstractMutableProperty;
import com.macrofocus.common.properties.AbstractProperties;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.properties.SimpleProperty;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0003:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0004J,\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\u0004\b\u0000\u0010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00022\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\fH\u0016J+\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\u0004\b\u0000\u0010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0012J\u001a\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016J\u0011\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0016H\u0096\u0002J,\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\u0004\b\u0000\u0010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00022\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\fH\u0016J\u001c\u0010\u0018\u001a\u00020\u00192\b\u0010\u000e\u001a\u0004\u0018\u00010\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0016R$\u0010\u0005\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0010\u0012\u000e\u0012\u0006\u0012\u0004\u0018\u00010\b0\nR\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/macrofocus/common/properties/SimpleProperties;", "Lcom/macrofocus/common/properties/AbstractProperties;", "", "Lcom/macrofocus/common/properties/MutableProperties;", "()V", "listenerMap", "", "Lcom/macrofocus/common/properties/PropertyListener;", "", "propertyMap", "Lcom/macrofocus/common/properties/SimpleProperties$ExposedProperty;", "addProperty", "Lcom/macrofocus/common/properties/MutableProperty;", "T", "name", "property", "createProperty", "value", "(Ljava/lang/String;Ljava/lang/Object;)Lcom/macrofocus/common/properties/MutableProperty;", "getProperty", "getValue", "iterator", "", "replaceProperty", "setValue", "", "ExposedProperty", "NamedPropertyListener", "macrofocus-common"})
public class SimpleProperties
extends AbstractProperties<String>
implements MutableProperties<String> {
    private final Map<String, ExposedProperty<Object>> propertyMap = new HashMap();
    private final Map<String, PropertyListener<Object>> listenerMap = new HashMap();

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return this.propertyMap.keySet().iterator();
    }

    @Override
    @NotNull
    public <T> MutableProperty<T> createProperty(@Nullable String name, T value) {
        MutableProperty property = SimpleProperty.Companion.newInstance(value);
        return this.addProperty(name, property);
    }

    @Override
    @NotNull
    public <T> MutableProperty<T> addProperty(@Nullable String name, @NotNull MutableProperty<T> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        ExposedProperty<T> exposedProperty = new ExposedProperty<T>(property);
        this.propertyMap.put(name, exposedProperty);
        NamedPropertyListener listener2 = new NamedPropertyListener(name);
        exposedProperty.addPropertyListener(listener2);
        this.listenerMap.put(name, listener2);
        return exposedProperty;
    }

    @Override
    @NotNull
    public <T> MutableProperty<T> replaceProperty(@Nullable String name, @NotNull MutableProperty<T> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        ExposedProperty<Object> exposedProperty = this.propertyMap.get(name);
        Intrinsics.checkNotNull(exposedProperty);
        exposedProperty.setSecretProperty(property);
        return property;
    }

    @Override
    @Nullable
    public Object getValue(@Nullable String name) {
        ExposedProperty<Object> exposedProperty = this.propertyMap.get(name);
        Intrinsics.checkNotNull(exposedProperty);
        return exposedProperty.getValue();
    }

    @Override
    public void setValue(@Nullable String name, @Nullable Object value) {
        ExposedProperty<Object> exposedProperty = this.propertyMap.get(name);
        Intrinsics.checkNotNull(exposedProperty);
        exposedProperty.setValue(value);
    }

    @Override
    @NotNull
    public MutableProperty<Object> getProperty(@Nullable String name) {
        ExposedProperty<Object> exposedProperty = this.propertyMap.get(name);
        Intrinsics.checkNotNull(exposedProperty);
        return exposedProperty;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\tH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/macrofocus/common/properties/SimpleProperties$NamedPropertyListener;", "Lcom/macrofocus/common/properties/PropertyListener;", "", "name", "", "(Lcom/macrofocus/common/properties/SimpleProperties;Ljava/lang/String;)V", "propertyChanged", "", "event", "Lcom/macrofocus/common/properties/PropertyEvent;", "macrofocus-common"})
    private final class NamedPropertyListener
    implements PropertyListener<Object> {
        private final String name;

        @Override
        public void propertyChanged(@NotNull PropertyEvent<Object> event) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            SimpleProperties.this.notifyPropertyChanged(this.name, event);
        }

        public NamedPropertyListener(String name) {
            this.name = name;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u00008V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/macrofocus/common/properties/SimpleProperties$ExposedProperty;", "T", "Lcom/macrofocus/common/properties/AbstractMutableProperty;", "Lcom/macrofocus/common/properties/MutableProperty;", "secret", "(Lcom/macrofocus/common/properties/SimpleProperties;Lcom/macrofocus/common/properties/MutableProperty;)V", "listener", "Lcom/macrofocus/common/properties/PropertyListener;", "getListener", "()Lcom/macrofocus/common/properties/PropertyListener;", "setListener", "(Lcom/macrofocus/common/properties/PropertyListener;)V", "value", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "setSecretProperty", "", "macrofocus-common"})
    private final class ExposedProperty<T>
    extends AbstractMutableProperty<T>
    implements MutableProperty<T> {
        private MutableProperty<T> secret;
        @NotNull
        private PropertyListener<T> listener;

        @NotNull
        public final PropertyListener<T> getListener() {
            return this.listener;
        }

        public final void setListener(@NotNull PropertyListener<T> propertyListener) {
            Intrinsics.checkNotNullParameter(propertyListener, (String)"<set-?>");
            this.listener = propertyListener;
        }

        public final void setSecretProperty(@NotNull MutableProperty<T> secret) {
            Intrinsics.checkNotNullParameter(secret, (String)"secret");
            if (this.secret != secret) {
                this.secret.removePropertyListener(this.listener);
                T oldValue = this.secret.getValue();
                T newValue = secret.getValue();
                this.secret = secret;
                this.secret.addPropertyListener(this.listener);
                if (oldValue != newValue) {
                    this.notifyPropertyChanged(new PropertyEvent<T>(oldValue, newValue));
                }
            }
        }

        @Override
        public T getValue() {
            return this.secret.getValue();
        }

        @Override
        public void setValue(T value) {
            this.secret.setValue(value);
        }

        public ExposedProperty(MutableProperty<T> secret) {
            Intrinsics.checkNotNullParameter(secret, (String)"secret");
            this.listener = new PropertyListener<T>(this){
                final /* synthetic */ ExposedProperty this$0;

                public void propertyChanged(@NotNull PropertyEvent<T> event) {
                    Intrinsics.checkNotNullParameter(event, (String)"event");
                    this.this$0.notifyPropertyChanged(event);
                }
                {
                    this.this$0 = this$0;
                }
            };
            this.secret = secret;
            this.secret.addPropertyListener(this.listener);
        }
    }
}

