/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.selection;

import com.macrofocus.common.collection.CollectionFactory;
import com.macrofocus.common.collection.WeakReference;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SimpleSelectionEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016J\u0016\u0010\u0010\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016J\u0016\u0010\u0011\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0004J\u0016\u0010\u0014\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0016R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/macrofocus/common/selection/AbstractSelection;", "E", "Lcom/macrofocus/common/selection/Selection;", "()V", "enabled", "", "isEnabled", "()Z", "setEnabled", "(Z)V", "listeners", "", "Lcom/macrofocus/common/selection/SelectionListener;", "addSelectionListener", "", "listener", "addWeakSelectionListener", "notifySelectedChanged", "event", "Lcom/macrofocus/common/selection/SelectionEvent;", "removeSelectionListener", "removeSelectionListeners", "WeakSelectionListener", "macrofocus-common"})
public abstract class AbstractSelection<E>
implements Selection<E> {
    private boolean isEnabled = true;
    private final List<SelectionListener<E>> listeners = CollectionFactory.INSTANCE.copyOnWriteArrayList();

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    protected void setEnabled(boolean enabled) {
        if (this.isEnabled() != enabled) {
            this.isEnabled = enabled;
            Set changes = SetsKt.emptySet();
            this.notifySelectedChanged(new SimpleSelectionEvent(this, changes));
        }
    }

    @Override
    public void addSelectionListener(@NotNull SelectionListener<E> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void addWeakSelectionListener(@NotNull SelectionListener<E> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        WeakSelectionListener weakListener = new WeakSelectionListener(listener2);
        this.listeners.add(weakListener);
    }

    @Override
    public void removeSelectionListener(@NotNull SelectionListener<E> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        if (listener2 instanceof WeakSelectionListener) {
            boolean bl = this.listeners.remove(listener2);
        } else {
            SelectionListener<E> toRemove = null;
            for (SelectionListener<E> selectionListener : this.listeners) {
                SelectionListener<E> comparable = null;
                comparable = selectionListener instanceof WeakSelectionListener ? ((WeakSelectionListener)selectionListener).getReference() : selectionListener;
                if (!listener2.equals(comparable)) continue;
                toRemove = selectionListener;
            }
            if (toRemove != null) {
                boolean bl = this.listeners.remove(toRemove);
            }
        }
    }

    @Override
    public void removeSelectionListeners() {
        this.listeners.clear();
    }

    protected final void notifySelectedChanged(@NotNull SelectionEvent<E> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        for (SelectionListener<E> listener2 : this.listeners) {
            listener2.selectionChanged(event);
        }
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/macrofocus/common/selection/AbstractSelection$WeakSelectionListener;", "Lcom/macrofocus/common/selection/SelectionListener;", "listener", "(Lcom/macrofocus/common/selection/AbstractSelection;Lcom/macrofocus/common/selection/SelectionListener;)V", "l_ref", "Lcom/macrofocus/common/collection/WeakReference;", "reference", "getReference", "()Lcom/macrofocus/common/selection/SelectionListener;", "selectionChanged", "", "event", "Lcom/macrofocus/common/selection/SelectionEvent;", "toString", "", "macrofocus-common"})
    private final class WeakSelectionListener
    implements SelectionListener<E> {
        private final WeakReference<SelectionListener<E>> l_ref;

        @Override
        public void selectionChanged(@NotNull SelectionEvent<E> event) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            SelectionListener l = this.getReference();
            if (l != null) {
                l.selectionChanged(event);
            } else {
                WeakSelectionListener weakSelectionListener = this;
                if (weakSelectionListener == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.macrofocus.common.selection.SelectionListener<E>");
                }
                AbstractSelection.this.removeSelectionListener(weakSelectionListener);
            }
        }

        @Nullable
        public final SelectionListener<E> getReference() {
            return this.l_ref.get();
        }

        @NotNull
        public String toString() {
            SelectionListener l = this.getReference();
            return l != null ? "Weak[" + l + ']' : String.valueOf(this.getReference());
        }

        public WeakSelectionListener(SelectionListener<E> listener2) {
            Intrinsics.checkNotNullParameter(listener2, (String)"listener");
            this.l_ref = new WeakReference(listener2);
        }
    }
}

