/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.selection;

import com.macrofocus.common.selection.AbstractSelectionEvent;
import com.macrofocus.common.selection.SingleSelection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\n\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B7\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00018\u0000\u0012\b\u0010\t\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\t\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\b\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0016\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lcom/macrofocus/common/selection/SingleSelectionEvent;", "E", "Lcom/macrofocus/common/selection/AbstractSelectionEvent;", "model", "Lcom/macrofocus/common/selection/SingleSelection;", "previousActive", "", "currentActive", "previousSelection", "currentSelection", "(Lcom/macrofocus/common/selection/SingleSelection;ZZLjava/lang/Object;Ljava/lang/Object;)V", "affected", "", "getAffected", "()Ljava/lang/Iterable;", "changes", "", "getCurrentSelection", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getModel", "()Lcom/macrofocus/common/selection/SingleSelection;", "getPreviousSelection", "isAffected", "element", "(Ljava/lang/Object;)Z", "macrofocus-common"})
public final class SingleSelectionEvent<E>
extends AbstractSelectionEvent<E> {
    @NotNull
    private final SingleSelection<E> model;
    private final boolean previousActive;
    private final boolean currentActive;
    @Nullable
    private final E previousSelection;
    @Nullable
    private final E currentSelection;
    private Set<E> changes;

    @Override
    @NotNull
    public SingleSelection<E> getModel() {
        return this.model;
    }

    @Nullable
    public final E getPreviousSelection() {
        return this.previousSelection;
    }

    @Nullable
    public final E getCurrentSelection() {
        return this.currentSelection;
    }

    @Override
    public boolean isAffected(E element) {
        return Intrinsics.areEqual(element, this.previousSelection) || Intrinsics.areEqual(element, this.currentSelection);
    }

    @Override
    @NotNull
    public Iterable<E> getAffected() {
        if (this.changes == null) {
            this.changes = new HashSet();
            if (this.previousActive) {
                Set<E> set = this.changes;
                Intrinsics.checkNotNull(set);
                E e = this.previousSelection;
                Intrinsics.checkNotNull(e);
                set.add(e);
            }
            if (this.currentActive) {
                Set<E> set = this.changes;
                Intrinsics.checkNotNull(set);
                E e = this.currentSelection;
                Intrinsics.checkNotNull(e);
                set.add(e);
            }
        }
        Set<E> set = this.changes;
        Intrinsics.checkNotNull(set);
        return set;
    }

    public SingleSelectionEvent(@NotNull SingleSelection<E> model, boolean previousActive, boolean currentActive, @Nullable E previousSelection, @Nullable E currentSelection) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        this.model = model;
        this.previousActive = previousActive;
        this.currentActive = currentActive;
        this.previousSelection = previousSelection;
        this.currentSelection = currentSelection;
    }
}

