/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.timer;

import com.macrofocus.common.timer.AbstractCPTimer;
import com.macrofocus.common.timer.CPTimerListener;
import com.macrofocus.common.timer.CoalescingTimer;
import com.macrofocus.common.timer.Timer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB)\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0006\u0010\u0013\u001a\u00020\u0012J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/macrofocus/common/timer/SwingTimer;", "Lcom/macrofocus/common/timer/AbstractCPTimer;", "name", "", "delay", "", "postponing", "", "(Ljava/lang/String;IZ)V", "keepAlive", "(Ljava/lang/String;IIZ)V", "keepAliveThread", "Ljava/lang/Thread;", "keepAliveTimer", "Lcom/macrofocus/common/timer/CoalescingTimer;", "timer", "timerThread", "restart", "", "stop", "toString", "macrofocus-common"})
public final class SwingTimer
extends AbstractCPTimer {
    private final String name;
    private CoalescingTimer timer;
    private CoalescingTimer keepAliveTimer;
    private Thread timerThread;
    private Thread keepAliveThread;

    @Override
    public void restart() {
        block10: {
            block9: {
                block8: {
                    block7: {
                        if (this.timerThread == null) break block7;
                        Thread thread = this.timerThread;
                        Intrinsics.checkNotNull((Object)thread);
                        if (thread.isAlive()) break block8;
                    }
                    Thread thread = this.timerThread = new Thread(this.timer);
                    Intrinsics.checkNotNull((Object)thread);
                    thread.setName(this.name != null ? this.name + "$Timer" : "Coalescing$Timer");
                    Thread thread2 = this.timerThread;
                    Intrinsics.checkNotNull((Object)thread2);
                    thread2.setDaemon(true);
                    Thread thread3 = this.timerThread;
                    Intrinsics.checkNotNull((Object)thread3);
                    thread3.start();
                }
                if (this.keepAliveTimer != null && this.keepAliveThread == null) break block9;
                Thread thread = this.keepAliveThread;
                Intrinsics.checkNotNull((Object)thread);
                if (thread.isAlive()) break block10;
            }
            Thread thread = this.keepAliveThread = new Thread(this.keepAliveTimer);
            Intrinsics.checkNotNull((Object)thread);
            thread.setName(this.name != null ? this.name + "$KeepAlive" : "Coalescing$KeepAlive");
            Thread thread4 = this.keepAliveThread;
            Intrinsics.checkNotNull((Object)thread4);
            thread4.setDaemon(true);
            Thread thread5 = this.keepAliveThread;
            Intrinsics.checkNotNull((Object)thread5);
            thread5.start();
        }
        this.timer.restart();
        if (this.keepAliveTimer != null) {
            CoalescingTimer coalescingTimer = this.keepAliveTimer;
            Intrinsics.checkNotNull((Object)coalescingTimer);
            coalescingTimer.restart();
        }
    }

    public final void stop() {
        this.timer.stop();
        if (this.keepAliveTimer != null) {
            CoalescingTimer coalescingTimer = this.keepAliveTimer;
            Intrinsics.checkNotNull((Object)coalescingTimer);
            coalescingTimer.stop();
        }
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public String toString() {
        v0 = new StringBuilder().append("SwingTimer{timer=").append(this.timer).append("timerThread=");
        if (this.timerThread == null) ** GOTO lbl-1000
        v1 = this.timerThread;
        Intrinsics.checkNotNull((Object)v1);
        if (v1.isAlive()) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        v3 = v0.append(v2).append("keepAliveThread=");
        if (this.keepAliveThread == null) ** GOTO lbl-1000
        v4 = this.keepAliveThread;
        Intrinsics.checkNotNull((Object)v4);
        if (v4.isAlive()) {
            v5 = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = false;
        }
        return v3.append(v5).append('}').toString();
    }

    public SwingTimer(@Nullable String name, int delay, boolean postponing) {
        this.name = name;
        this.timer = new CoalescingTimer(delay, postponing);
        this.keepAliveTimer = null;
        this.timer.addActionListener(new Timer.TimerListener(){

            @Override
            public void timerTriggered() {
                for (CPTimerListener listener2 : this.getListeners()) {
                    listener2.timerTriggered();
                }
            }
        });
    }

    public SwingTimer(@Nullable String name, int delay, int keepAlive, boolean postponing) {
        this.name = name;
        boolean bl = keepAlive > delay;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.timer = new CoalescingTimer(delay, postponing);
        this.keepAliveTimer = new CoalescingTimer(keepAlive, false, 2, null);
        this.timer.addActionListener(new Timer.TimerListener(){

            @Override
            public void timerTriggered() {
                for (CPTimerListener listener2 : this.getListeners()) {
                    listener2.timerTriggered();
                }
            }
        });
        CoalescingTimer coalescingTimer = this.keepAliveTimer;
        Intrinsics.checkNotNull((Object)coalescingTimer);
        coalescingTimer.addActionListener(new Timer.TimerListener(){

            @Override
            public void timerTriggered() {
                timer.stop();
                CoalescingTimer coalescingTimer = keepAliveTimer;
                Intrinsics.checkNotNull((Object)coalescingTimer);
                coalescingTimer.stop();
                keepAliveThread = null;
                timerThread = null;
            }
        });
    }

    public static final /* synthetic */ void access$setTimer$p(SwingTimer $this, CoalescingTimer coalescingTimer) {
        $this.timer = coalescingTimer;
    }

    public static final /* synthetic */ void access$setKeepAliveTimer$p(SwingTimer $this, CoalescingTimer coalescingTimer) {
        $this.keepAliveTimer = coalescingTimer;
    }

    public static final /* synthetic */ Thread access$getKeepAliveThread$p(SwingTimer $this) {
        return $this.keepAliveThread;
    }

    public static final /* synthetic */ Thread access$getTimerThread$p(SwingTimer $this) {
        return $this.timerThread;
    }
}

