/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.transform;

import com.macrofocus.common.collection.CollectionFactory;
import com.macrofocus.common.collection.WeakReference;
import com.macrofocus.common.transform.MutableOneDScreenTransform;
import com.macrofocus.common.transform.ScreenTransformEvent;
import com.macrofocus.common.transform.ScreenTransformListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0004J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/macrofocus/common/transform/AbstractMutableOneDScreenTransform;", "Lcom/macrofocus/common/transform/MutableOneDScreenTransform;", "()V", "listeners", "", "Lcom/macrofocus/common/transform/ScreenTransformListener;", "addScreenTransformListener", "", "listener", "addWeakScreenTransformListener", "notifyTransformChanged", "event", "Lcom/macrofocus/common/transform/ScreenTransformEvent;", "removeScreenTransformListener", "removeScreenTransformListeners", "WeakScreenTransformListener", "macrofocus-common"})
public abstract class AbstractMutableOneDScreenTransform
implements MutableOneDScreenTransform {
    private final List<ScreenTransformListener> listeners = CollectionFactory.INSTANCE.copyOnWriteArrayList();

    @Override
    public void addScreenTransformListener(@NotNull ScreenTransformListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void addWeakScreenTransformListener(@NotNull ScreenTransformListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        WeakScreenTransformListener weakListener = new WeakScreenTransformListener(listener2);
        this.listeners.add(weakListener);
    }

    @Override
    public void removeScreenTransformListener(@NotNull ScreenTransformListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        if (listener2 instanceof WeakScreenTransformListener) {
            boolean bl = this.listeners.remove(listener2);
        } else {
            ScreenTransformListener toRemove = null;
            for (ScreenTransformListener screenTransformListener : this.listeners) {
                ScreenTransformListener comparable = null;
                comparable = screenTransformListener instanceof WeakScreenTransformListener ? ((WeakScreenTransformListener)screenTransformListener).getReference() : screenTransformListener;
                if (!listener2.equals(comparable)) continue;
                toRemove = screenTransformListener;
            }
            if (toRemove != null) {
                boolean bl = this.listeners.remove(toRemove);
            }
        }
    }

    @Override
    public void removeScreenTransformListeners() {
        this.listeners.clear();
    }

    protected final void notifyTransformChanged(@NotNull ScreenTransformEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (ScreenTransformListener listener2 : this.listeners) {
            listener2.transformChanged(event);
        }
    }

    protected AbstractMutableOneDScreenTransform() {
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/macrofocus/common/transform/AbstractMutableOneDScreenTransform$WeakScreenTransformListener;", "Lcom/macrofocus/common/transform/ScreenTransformListener;", "listener", "(Lcom/macrofocus/common/transform/AbstractMutableOneDScreenTransform;Lcom/macrofocus/common/transform/ScreenTransformListener;)V", "l_ref", "Lcom/macrofocus/common/collection/WeakReference;", "reference", "getReference", "()Lcom/macrofocus/common/transform/ScreenTransformListener;", "toString", "", "transformChanged", "", "event", "Lcom/macrofocus/common/transform/ScreenTransformEvent;", "macrofocus-common"})
    private final class WeakScreenTransformListener
    implements ScreenTransformListener {
        private final WeakReference<ScreenTransformListener> l_ref;

        @Override
        public void transformChanged(@NotNull ScreenTransformEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ScreenTransformListener l = this.getReference();
            if (l != null) {
                l.transformChanged(event);
            } else {
                AbstractMutableOneDScreenTransform.this.removeScreenTransformListener(this);
            }
        }

        @NotNull
        public final ScreenTransformListener getReference() {
            return this.l_ref.get();
        }

        @NotNull
        public String toString() {
            ScreenTransformListener l = this.getReference();
            return l != null ? "Weak[" + l + ']' : super.toString();
        }

        public WeakScreenTransformListener(ScreenTransformListener listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            this.l_ref = new WeakReference<ScreenTransformListener>(listener2);
        }
    }
}

