/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.transform;

import com.macrofocus.common.interval.BoundedInterval;
import com.macrofocus.common.interval.Interval;
import com.macrofocus.common.interval.IntervalEvent;
import com.macrofocus.common.interval.IntervalListener;
import com.macrofocus.common.transform.AbstractMutableOneDScreenTransform;
import com.macrofocus.common.transform.ScreenTransformEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u0005H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0010\u0010&\u001a\u00020%2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u001bH\u0016J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u001bH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0014\u0010 \u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001d\u00a8\u0006+"}, d2={"Lcom/macrofocus/common/transform/SimpleOneDScreenTransform;", "Lcom/macrofocus/common/transform/AbstractMutableOneDScreenTransform;", "world", "Lcom/macrofocus/common/interval/BoundedInterval;", "screenSize", "", "invertDeviceCoordinates", "", "invertWorldCoordinates", "(Lcom/macrofocus/common/interval/BoundedInterval;IZZ)V", "(Lcom/macrofocus/common/interval/BoundedInterval;I)V", "intervalListener", "Lcom/macrofocus/common/interval/IntervalListener;", "isAffine", "()Z", "<set-?>", "isWorldCoordinatesInverted", "screenMargins", "getScreenSize", "()I", "setScreenSize", "(I)V", "worldInterval", "Lcom/macrofocus/common/interval/Interval;", "getWorldInterval", "()Lcom/macrofocus/common/interval/Interval;", "worldMax", "", "getWorldMax", "()D", "worldMin", "getWorldMin", "worldRange", "getWorldRange", "screenToWorld", "screen", "setScreenMargins", "", "setWorldInterval", "toString", "", "worldToScreen", "worldToScreenPrecise", "macrofocus-common"})
public final class SimpleOneDScreenTransform
extends AbstractMutableOneDScreenTransform {
    private int screenMargins;
    private int screenSize;
    private boolean invertDeviceCoordinates;
    private boolean isWorldCoordinatesInverted;
    private final IntervalListener intervalListener;
    private BoundedInterval world;

    @Override
    public int getScreenSize() {
        return this.screenSize;
    }

    @Override
    public void setScreenSize(int screenSize) {
        if (this.screenSize != screenSize) {
            this.screenSize = screenSize;
            this.notifyTransformChanged(new ScreenTransformEvent());
        }
    }

    @Override
    public boolean isWorldCoordinatesInverted() {
        return this.isWorldCoordinatesInverted;
    }

    @Override
    public double screenToWorld(int screen) {
        double normalized = 0.0;
        normalized = (double)(screen - this.screenMargins / 2) / (double)(this.getScreenSize() - this.screenMargins);
        if (this.invertDeviceCoordinates) {
            normalized = 1.0 - normalized;
        }
        if (this.isWorldCoordinatesInverted()) {
            normalized = 1.0 - normalized;
        }
        normalized = normalized * this.getWorldRange() + this.getWorldMin();
        return normalized;
    }

    @Override
    public int worldToScreen(double world) {
        return (int)this.worldToScreenPrecise(world);
    }

    @Override
    public double worldToScreenPrecise(double world) {
        return this.isWorldCoordinatesInverted() ^ this.invertDeviceCoordinates ? (this.getWorldMax() - world) * (double)(this.getScreenSize() - this.screenMargins) / this.getWorldRange() + (double)this.screenMargins / 2.0 : (world - this.getWorldMin()) * (double)(this.getScreenSize() - this.screenMargins) / this.getWorldRange() + (double)this.screenMargins / 2.0;
    }

    @Override
    @NotNull
    public Interval getWorldInterval() {
        return this.world;
    }

    @Override
    public void setWorldInterval(@NotNull BoundedInterval world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.world.removeIntervalListener(this.intervalListener);
        this.world = world;
        this.world.addIntervalListener(this.intervalListener);
        this.notifyTransformChanged(new ScreenTransformEvent());
    }

    @Override
    public boolean isAffine() {
        return true;
    }

    @Override
    public double getWorldMin() {
        return this.isWorldCoordinatesInverted() ? this.world.getMinimum() + (this.world.getMaximum() - (this.world.getStart() + this.world.getExtent())) : this.world.getStart();
    }

    @Override
    public double getWorldMax() {
        return this.isWorldCoordinatesInverted() ? this.world.getMinimum() + (this.world.getMaximum() - this.world.getStart()) : this.world.getStart() + this.world.getExtent();
    }

    @Override
    public double getWorldRange() {
        return this.world.getExtent();
    }

    @Override
    public void setScreenMargins(int screenMargins) {
        if (this.screenMargins != screenMargins) {
            this.screenMargins = screenMargins;
            this.notifyTransformChanged(new ScreenTransformEvent());
        }
    }

    @NotNull
    public String toString() {
        return "SimpleOneDScreenTransform{world=" + this.world + ", screenMargins=" + this.screenMargins + ", screenSize=" + this.getScreenSize() + ", invertDeviceCoordinates=" + this.invertDeviceCoordinates + ", invertWorldCoordinates=" + this.isWorldCoordinatesInverted() + '}';
    }

    public SimpleOneDScreenTransform(@NotNull BoundedInterval world, int screenSize) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.world = world;
        this.intervalListener = new IntervalListener(this){
            final /* synthetic */ SimpleOneDScreenTransform this$0;

            public void intervalChanged(@Nullable IntervalEvent event) {
                this.this$0.notifyTransformChanged(new ScreenTransformEvent());
            }
            {
                this.this$0 = this$0;
            }
        };
        this.world.addWeakIntervalListener(this.intervalListener);
        this.setScreenSize(screenSize);
    }

    public SimpleOneDScreenTransform(@NotNull BoundedInterval world, int screenSize, boolean invertDeviceCoordinates, boolean invertWorldCoordinates) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this(world, screenSize);
        this.invertDeviceCoordinates = invertDeviceCoordinates;
        this.isWorldCoordinatesInverted = invertWorldCoordinates;
    }
}

