/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.units;

import com.macrofocus.common.units.Unit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0016\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/macrofocus/common/units/Power;", "Lcom/macrofocus/common/units/Unit;", "name", "", "symbol", "ratio", "", "(Ljava/lang/String;Ljava/lang/String;D)V", "Factory", "macrofocus-common"})
public class Power
extends Unit {
    @NotNull
    private static final Power Picowatt;
    @NotNull
    private static final Power Nanowatt;
    @NotNull
    private static final Power Microwatt;
    @NotNull
    private static final Power Milliwatt;
    @NotNull
    private static final Power Watt;
    @NotNull
    private static final Power Kilowatt;
    @NotNull
    private static final Power Megawatt;
    @NotNull
    private static final Power Gigawatt;
    @NotNull
    private static final Power Terawatt;
    @NotNull
    private static final Power Petawatt;
    @NotNull
    private static final Power Horsepower;
    @NotNull
    public static final Factory Factory;

    public Power(@NotNull String name, @NotNull String symbol, double ratio) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        super(name, symbol, ratio);
    }

    static {
        Factory = new Factory(null);
        Picowatt = new Power("Picowatt", "pW", 1.0E-7);
        Nanowatt = new Power("Nanowatt", "nW", 1.0E-10);
        Microwatt = new Power("Microwatt", "\u00b5W", 1.0E-7);
        Milliwatt = new Power("Kilowatt", "mW", 1.0E-4);
        Watt = new Power("Kilowatt", "W", 1.0);
        Kilowatt = new Power("Kilowatt", "KW", 1000.0);
        Megawatt = new Power("Megawatt", "MW", 1000000.0);
        Gigawatt = new Power("Gigawatt", "GW", 1.0E9);
        Terawatt = new Power("Terawatt", "TW", 1.0E12);
        Petawatt = new Power("Terawatt", "PW", 1.0E15);
        Horsepower = new Power("Metric horsepower", "hp(M)", 735.49875);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/macrofocus/common/units/Power$Factory;", "", "()V", "Gigawatt", "Lcom/macrofocus/common/units/Power;", "getGigawatt", "()Lcom/macrofocus/common/units/Power;", "Horsepower", "getHorsepower", "Kilowatt", "getKilowatt", "Megawatt", "getMegawatt", "Microwatt", "getMicrowatt", "Milliwatt", "getMilliwatt", "Nanowatt", "getNanowatt", "Petawatt", "getPetawatt", "Picowatt", "getPicowatt", "Terawatt", "getTerawatt", "Watt", "getWatt", "macrofocus-common"})
    public static final class Factory {
        @NotNull
        public final Power getPicowatt() {
            return Picowatt;
        }

        @NotNull
        public final Power getNanowatt() {
            return Nanowatt;
        }

        @NotNull
        public final Power getMicrowatt() {
            return Microwatt;
        }

        @NotNull
        public final Power getMilliwatt() {
            return Milliwatt;
        }

        @NotNull
        public final Power getWatt() {
            return Watt;
        }

        @NotNull
        public final Power getKilowatt() {
            return Kilowatt;
        }

        @NotNull
        public final Power getMegawatt() {
            return Megawatt;
        }

        @NotNull
        public final Power getGigawatt() {
            return Gigawatt;
        }

        @NotNull
        public final Power getTerawatt() {
            return Terawatt;
        }

        @NotNull
        public final Power getPetawatt() {
            return Petawatt;
        }

        @NotNull
        public final Power getHorsepower() {
            return Horsepower;
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

