/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.units;

import com.macrofocus.common.units.ProductUnit;
import com.macrofocus.common.units.QuotientUnit;
import com.macrofocus.common.units.Unit;
import com.macrofocus.common.units.UnitKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007J\u0017\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0096\u0002J3\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00140\u00130\u0000\"\b\b\u0001\u0010\u0014*\u00020\u00022\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0000H\u0086\u0002J\u0017\u0010\u0012\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0086\u0002J\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0011\u001a\u00020\u0016H\u0086\u0002J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u0010H\u0016J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u0000\"\b\b\u0001\u0010\u001c*\u00028\u00002\u0006\u0010\u0006\u001a\u0002H\u001cH\u0086\u0004\u00a2\u0006\u0002\u0010\u001dJ\u001d\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0086\u0002J\u001d\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0086\u0002J3\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00140!0\u0000\"\b\b\u0001\u0010\u0014*\u00020\u00022\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0000H\u0086\u0002J\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0011\u001a\u00020\u0016H\u0086\u0002J\b\u0010\"\u001a\u00020#H\u0016R\u0014\u0010\b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006$"}, d2={"Lcom/macrofocus/common/units/Quantity;", "T", "Lcom/macrofocus/common/units/Unit;", "", "amount", "", "unit", "(DLcom/macrofocus/common/units/Unit;)V", "EPSILON", "getEPSILON", "()D", "getAmount", "getUnit", "()Lcom/macrofocus/common/units/Unit;", "Lcom/macrofocus/common/units/Unit;", "compareTo", "", "other", "div", "Lcom/macrofocus/common/units/QuotientUnit;", "R", "quantity", "", "equals", "", "", "hashCode", "into", "A", "(Lcom/macrofocus/common/units/Unit;)Lcom/macrofocus/common/units/Quantity;", "minus", "plus", "times", "Lcom/macrofocus/common/units/ProductUnit;", "toString", "", "macrofocus-common"})
public final class Quantity<T extends Unit>
implements Comparable<Quantity<T>> {
    private final double EPSILON;
    private final double amount;
    @NotNull
    private final T unit;

    @NotNull
    public final <A extends T> Quantity<A> into(@NotNull A unit) {
        Intrinsics.checkNotNullParameter(unit, (String)"unit");
        double baseUnit = ((Unit)this.unit).convertToBaseUnit(this.amount);
        return new Quantity<A>(((Unit)unit).convertFromBaseUnit(baseUnit), unit);
    }

    @NotNull
    public final Quantity<T> plus(@NotNull Quantity<T> quantity) {
        Intrinsics.checkNotNullParameter(quantity, (String)"quantity");
        double converted = quantity.into(this.unit).amount;
        return new Quantity<T>(this.amount + converted, this.unit);
    }

    @NotNull
    public final Quantity<T> minus(@NotNull Quantity<T> quantity) {
        Intrinsics.checkNotNullParameter(quantity, (String)"quantity");
        double converted = quantity.into(this.unit).amount;
        return new Quantity<T>(this.amount - converted, this.unit);
    }

    public final double div(@NotNull Quantity<T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return ((Unit)this.unit).convertToBaseUnit(this.amount) / ((Unit)other.unit).convertToBaseUnit(other.amount);
    }

    @NotNull
    public final <R extends Unit> Quantity<QuotientUnit<T, R>> div(@NotNull Quantity<R> quantity) {
        Intrinsics.checkNotNullParameter(quantity, (String)"quantity");
        return new Quantity<Unit>(this.amount / quantity.amount, UnitKt.div(this.unit, quantity.unit));
    }

    @NotNull
    public final <R extends Unit> Quantity<ProductUnit<T, R>> times(@NotNull Quantity<R> quantity) {
        Intrinsics.checkNotNullParameter(quantity, (String)"quantity");
        return new Quantity<Unit>(this.amount * quantity.amount, UnitKt.times(this.unit, quantity.unit));
    }

    @NotNull
    public final Quantity<T> times(@NotNull Number other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Quantity<T>(this.amount * other.doubleValue(), this.unit);
    }

    @NotNull
    public final Quantity<T> div(@NotNull Number other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Quantity<T>(this.amount / other.doubleValue(), this.unit);
    }

    @Override
    public int compareTo(@NotNull Quantity<T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Double.compare(this.into(other.unit).amount, other.amount);
    }

    public final double getEPSILON() {
        return this.EPSILON;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof Quantity)) return false;
        if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(((Quantity)other).unit.getClass()), (Object)Reflection.getOrCreateKotlinClass(this.unit.getClass()))) return false;
        double d = ((Unit)this.unit).convertToBaseUnit(this.amount) - ((Unit)((Quantity)other).unit).convertToBaseUnit(((Quantity)other).amount);
        boolean bl = false;
        if (!(Math.abs(d) < this.EPSILON)) return false;
        return true;
    }

    public int hashCode() {
        return Double.hashCode(((Unit)this.unit).convertFromBaseUnit(this.amount) / (double)MathKt.roundToLong((double)this.EPSILON));
    }

    @NotNull
    public String toString() {
        return "" + this.amount + ' ' + ((Unit)this.unit).getSymbol();
    }

    public final double getAmount() {
        return this.amount;
    }

    @NotNull
    public final T getUnit() {
        return this.unit;
    }

    public Quantity(double amount, @NotNull T unit) {
        Intrinsics.checkNotNullParameter(unit, (String)"unit");
        this.amount = amount;
        this.unit = unit;
        this.EPSILON = 1.0E-10;
    }
}

