/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.format;

import com.macrofocus.common.date.CPTimeZone;
import com.macrofocus.common.format.AbstractFormat;
import com.macrofocus.common.format.CPFormat;
import com.macrofocus.common.format.FormatFactoryCommon;
import com.macrofocus.common.locale.CPLocale;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000  2\u00020\u0001:\u0004 !\"#B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004J\u001e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000fJ&\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004J\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004J\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004J<\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\u0016\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u001b\u001a\u00020\u001cJ,\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ \u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006$"}, d2={"Lcom/macrofocus/common/format/FormatFactory;", "Lcom/macrofocus/common/format/FormatFactoryCommon;", "()V", "createCurrencyFormat", "Lcom/macrofocus/common/format/CPFormat;", "", "fractionDigits", "", "currency", "Ljava/util/Currency;", "locale", "Ljava/util/Locale;", "createDateFormat", "pattern", "", "Lcom/macrofocus/common/locale/CPLocale;", "zone", "Lcom/macrofocus/common/date/CPTimeZone;", "createDateOrDateTimeFormat", "createDateTimeFormat", "createDecimalFormat", "pre", "post", "rounding", "", "factor", "createFormat", "format", "Ljava/text/Format;", "createIntegerFormat", "createNumberFormat", "createPercentDecimalFormat", "Companion", "SwingDateFormat", "SwingFormat", "SwingNumberFormat", "macrofocus-common"})
public class FormatFactory
implements FormatFactoryCommon {
    @NotNull
    private static final FormatFactory instance;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final CPFormat<Object> createCurrencyFormat(int fractionDigits, @Nullable Currency currency, @Nullable Locale locale) {
        NumberFormat numberFormat;
        NumberFormat instance = null;
        if (currency != null) {
            NumberFormat numberFormat2 = DecimalFormat.getCurrencyInstance(locale);
            numberFormat = numberFormat2;
            Intrinsics.checkNotNullExpressionValue((Object)numberFormat2, (String)"DecimalFormat.getCurrencyInstance(locale)");
        } else {
            NumberFormat numberFormat3 = DecimalFormat.getNumberInstance(locale);
            numberFormat = numberFormat3;
            Intrinsics.checkNotNullExpressionValue((Object)numberFormat3, (String)"DecimalFormat.getNumberInstance(locale)");
        }
        instance = numberFormat;
        instance.setMaximumFractionDigits(fractionDigits);
        if (currency != null) {
            instance.setCurrency(currency);
        }
        return new SwingFormat(instance, null, null, 1.0, 1.0);
    }

    @NotNull
    public final CPFormat<Object> createDecimalFormat() {
        NumberFormat numberFormat = DecimalFormat.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)numberFormat, (String)"DecimalFormat.getInstance()");
        return new SwingFormat(numberFormat, null, null, 1.0, 1.0);
    }

    @Override
    @NotNull
    public CPFormat<Object> createDecimalFormat(int fractionDigits, @Nullable String pre, @Nullable String post, double rounding, double factor) {
        NumberFormat instance;
        NumberFormat numberFormat = instance = DecimalFormat.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)numberFormat, (String)"instance");
        numberFormat.setMaximumFractionDigits(fractionDigits);
        return new SwingFormat(instance, pre, post, rounding, factor);
    }

    @Override
    @NotNull
    public CPFormat<Object> createIntegerFormat(@Nullable String pre, @Nullable String post, double rounding) {
        NumberFormat numberFormat = DecimalFormat.getIntegerInstance();
        Intrinsics.checkNotNullExpressionValue((Object)numberFormat, (String)"DecimalFormat.getIntegerInstance()");
        return new SwingFormat(numberFormat, pre, post, rounding, 1.0);
    }

    @Override
    @NotNull
    public CPFormat<Object> createPercentDecimalFormat(int fractionDigits, double rounding) {
        NumberFormat instance;
        NumberFormat numberFormat = instance = DecimalFormat.getPercentInstance();
        Intrinsics.checkNotNullExpressionValue((Object)numberFormat, (String)"instance");
        numberFormat.setMaximumFractionDigits(fractionDigits);
        return new SwingFormat(instance, null, null, rounding, 1.0);
    }

    @NotNull
    public final CPFormat<Object> createDateFormat() {
        return new SwingDateFormat("dd.MM.yyyy");
    }

    @NotNull
    public final CPFormat<Object> createDateTimeFormat() {
        return new SwingDateFormat("dd.MM.yyyy HH:mm:ss");
    }

    @NotNull
    public final CPFormat<Object> createDateOrDateTimeFormat() {
        return new CPFormat<Object>(){
            @NotNull
            private DateFormat dateFormat;
            @NotNull
            private DateFormat fullDateFormat;

            @NotNull
            public final DateFormat getDateFormat() {
                return this.dateFormat;
            }

            public final void setDateFormat(@NotNull DateFormat dateFormat) {
                Intrinsics.checkNotNullParameter((Object)dateFormat, (String)"<set-?>");
                this.dateFormat = dateFormat;
            }

            @NotNull
            public final DateFormat getFullDateFormat() {
                return this.fullDateFormat;
            }

            public final void setFullDateFormat(@NotNull DateFormat dateFormat) {
                Intrinsics.checkNotNullParameter((Object)dateFormat, (String)"<set-?>");
                this.fullDateFormat = dateFormat;
            }

            @Nullable
            public String format(@Nullable Object value) {
                return this.formatHtml(value, false);
            }

            @Nullable
            public String formatHtml(@Nullable Object value, boolean htmlSupported) {
                String string;
                if (value != null) {
                    Date date;
                    Date date2 = null;
                    if (value instanceof Number) {
                        date = new Date(((Number)value).longValue());
                    } else if (value instanceof Date) {
                        date = (Date)value;
                    } else {
                        return value.toString();
                    }
                    date2 = date;
                    string = date2.getHours() != 0 || date2.getMinutes() != 0 || date2.getSeconds() != 0 ? this.fullDateFormat.format(date2) : this.dateFormat.format(date2);
                } else {
                    string = "";
                }
                return string;
            }

            @Nullable
            public Object parse(@Nullable String text) throws CPFormat.ParsingException {
                Date date;
                try {
                    date = this.fullDateFormat.parse(text);
                }
                catch (ParseException e) {
                    Date date2;
                    try {
                        date2 = this.dateFormat.parse(text);
                    }
                    catch (ParseException e1) {
                        throw (Throwable)new CPFormat.ParsingException(e.getMessage(), e.getErrorOffset());
                    }
                    date = date2;
                }
                return date;
            }

            @Nullable
            public String getPattern() {
                return null;
            }

            @Nullable
            public Object getNativeFormat() {
                return null;
            }

            @Nullable
            public CPFormat.HorizontalAlignment getHorizontalAlignment() {
                return null;
            }

            @Nullable
            public String getClassName(@Nullable Object value) {
                return null;
            }
            {
                this.dateFormat = new SimpleDateFormat("dd.MM.yyyy");
                this.fullDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            }
        };
    }

    @NotNull
    public final CPFormat<Object> createFormat(@NotNull Format format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return new SwingFormat(format, null, null, 1.0, 1.0);
    }

    @NotNull
    public final CPFormat<Object> createNumberFormat(@Nullable String pattern) {
        return new SwingNumberFormat(pattern);
    }

    @NotNull
    public final CPFormat<Object> createDateFormat(@Nullable String pattern) {
        return new SwingDateFormat(pattern);
    }

    @NotNull
    public final CPFormat<Object> createDateFormat(@NotNull String pattern, @NotNull CPLocale locale) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return new SwingDateFormat(pattern, locale);
    }

    @NotNull
    public final CPFormat<Object> createDateFormat(@NotNull String pattern, @NotNull CPLocale locale, @NotNull CPTimeZone zone) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        return new SwingDateFormat(pattern, locale, zone);
    }

    static {
        Companion = new Companion(null);
        instance = new FormatFactory();
    }

    @Override
    @Nullable
    public CPFormat<Object> createDecimalFormat(int fractionDigits) {
        return FormatFactoryCommon.DefaultImpls.createDecimalFormat(this, fractionDigits);
    }

    @Override
    @NotNull
    public CPFormat<Object> createIntegerFormat() {
        return FormatFactoryCommon.DefaultImpls.createIntegerFormat(this);
    }

    @Override
    @NotNull
    public CPFormat<Object> createPercentDecimalFormat(int fractionDigits) {
        return FormatFactoryCommon.DefaultImpls.createPercentDecimalFormat(this, fractionDigits);
    }

    @Override
    @Nullable
    public CPFormat<Object> createFormat(@Nullable String pre, @Nullable String post) {
        return FormatFactoryCommon.DefaultImpls.createFormat(this, pre, post);
    }

    @Override
    @NotNull
    public CPFormat<Object> createOrdinalFormat() {
        return FormatFactoryCommon.DefaultImpls.createOrdinalFormat(this);
    }

    @Override
    @NotNull
    public CPFormat<Object> createMilionFormat(@NotNull CPFormat<Object> decimalFormat) {
        Intrinsics.checkNotNullParameter(decimalFormat, (String)"decimalFormat");
        return FormatFactoryCommon.DefaultImpls.createMilionFormat(this, decimalFormat);
    }

    @Override
    @NotNull
    public CPFormat<Object> createStarFormat() {
        return FormatFactoryCommon.DefaultImpls.createStarFormat(this);
    }

    @Override
    @NotNull
    public CPFormat<Object> createStarFormat(@Nullable String na) {
        return FormatFactoryCommon.DefaultImpls.createStarFormat(this, na);
    }

    @Override
    @Nullable
    public CPFormat<Object> createBooleanFormat() {
        return FormatFactoryCommon.DefaultImpls.createBooleanFormat(this);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00022\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0016R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/macrofocus/common/format/FormatFactory$SwingFormat;", "Lcom/macrofocus/common/format/AbstractFormat;", "", "nativeFormat", "Ljava/text/Format;", "pre", "", "post", "rounding", "", "factor", "(Ljava/text/Format;Ljava/lang/String;Ljava/lang/String;DD)V", "getNativeFormat", "()Ljava/text/Format;", "formatHtml", "value", "htmlSupported", "", "parse", "text", "macrofocus-common"})
    private static final class SwingFormat
    extends AbstractFormat<Object> {
        @NotNull
        private final Format nativeFormat;
        private final String pre;
        private final String post;
        private final double rounding;
        private final double factor;

        @Override
        @Nullable
        public String formatHtml(@Nullable Object value, boolean htmlSupported) {
            String s = null;
            if (value instanceof Number) {
                Number n = (Number)value;
                if (this.rounding != 1.0) {
                    n = (double)Math.round(n.doubleValue() / this.rounding) * this.rounding;
                }
                if (this.factor != 1.0) {
                    n = n.doubleValue() * this.factor;
                }
                s = this.getNativeFormat().format(n);
                if (this.pre != null) {
                    s = this.pre + s;
                }
                if (this.post != null) {
                    s = Intrinsics.stringPlus((String)s, (Object)this.post);
                }
            } else {
                s = null;
            }
            return s;
        }

        @Override
        @Nullable
        public Object parse(@Nullable String text) throws CPFormat.ParsingException {
            Object object;
            String text2 = text;
            if (text2 != null) {
                Object object2;
                if (this.pre != null && !StringsKt.startsWith$default((String)text2, (String)this.pre, (boolean)false, (int)2, null)) {
                    text2 = this.pre + text2;
                }
                if (this.post != null && !StringsKt.endsWith$default((String)text2, (String)this.post, (boolean)false, (int)2, null)) {
                    text2 = text2 + this.post;
                }
                try {
                    object2 = this.getNativeFormat().parseObject(text2);
                }
                catch (ParseException e) {
                    throw (Throwable)new CPFormat.ParsingException(e.getMessage(), e.getErrorOffset());
                }
                object = object2;
            } else {
                object = null;
            }
            return object;
        }

        @Override
        @NotNull
        public Format getNativeFormat() {
            return this.nativeFormat;
        }

        public SwingFormat(@NotNull Format nativeFormat, @Nullable String pre, @Nullable String post, double rounding, double factor) {
            Intrinsics.checkNotNullParameter((Object)nativeFormat, (String)"nativeFormat");
            this.nativeFormat = nativeFormat;
            this.pre = pre;
            this.post = post;
            this.rounding = rounding;
            this.factor = factor;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0015\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u0019\u001a\u00020\u00022\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004H\u0016R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/macrofocus/common/format/FormatFactory$SwingNumberFormat;", "Lcom/macrofocus/common/format/CPFormat;", "", "pattern", "", "(Ljava/lang/String;)V", "horizontalAlignment", "Lcom/macrofocus/common/format/CPFormat$HorizontalAlignment;", "getHorizontalAlignment", "()Lcom/macrofocus/common/format/CPFormat$HorizontalAlignment;", "nativeFormat", "getNativeFormat", "()Ljava/lang/Object;", "numberFormat", "Ljava/text/DecimalFormat;", "getNumberFormat", "()Ljava/text/DecimalFormat;", "getPattern", "()Ljava/lang/String;", "format", "value", "formatHtml", "htmlSupported", "", "getClassName", "parse", "text", "macrofocus-common"})
    private static final class SwingNumberFormat
    implements CPFormat<Object> {
        @NotNull
        private final DecimalFormat numberFormat;
        @Nullable
        private final String pattern;

        @NotNull
        public final DecimalFormat getNumberFormat() {
            return this.numberFormat;
        }

        @Override
        @Nullable
        public String getPattern() {
            return this.pattern;
        }

        @Override
        @NotNull
        public String format(@Nullable Object value) {
            return this.formatHtml(value, false);
        }

        @Override
        @NotNull
        public String formatHtml(@Nullable Object value, boolean htmlSupported) {
            String string;
            if (value != null) {
                Number number = null;
                if (!(value instanceof Number)) {
                    return value.toString();
                }
                number = (Number)value;
                String string2 = this.numberFormat.format(number);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"numberFormat.format(number)");
            } else {
                string = "";
            }
            return string;
        }

        @Override
        @NotNull
        public Object parse(@Nullable String text) throws CPFormat.ParsingException {
            Number number;
            try {
                number = this.numberFormat.parse(text);
            }
            catch (ParseException e) {
                throw (Throwable)new CPFormat.ParsingException(e.getMessage(), e.getErrorOffset());
            }
            return number;
        }

        @Override
        @NotNull
        public Object getNativeFormat() {
            return this.numberFormat;
        }

        @Override
        @Nullable
        public CPFormat.HorizontalAlignment getHorizontalAlignment() {
            return null;
        }

        @Override
        @Nullable
        public String getClassName(@Nullable Object value) {
            return null;
        }

        public SwingNumberFormat(@Nullable String pattern) {
            this.numberFormat = new DecimalFormat(pattern);
            this.pattern = pattern;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0011\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB!\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u0019\u001a\u00020\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u001b\u001a\u00020\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u001f\u001a\u00020\u00022\b\u0010 \u001a\u0004\u0018\u00010\u0004H\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006!"}, d2={"Lcom/macrofocus/common/format/FormatFactory$SwingDateFormat;", "Lcom/macrofocus/common/format/CPFormat;", "", "pattern", "", "(Ljava/lang/String;)V", "locale", "Lcom/macrofocus/common/locale/CPLocale;", "(Ljava/lang/String;Lcom/macrofocus/common/locale/CPLocale;)V", "timeZone", "Lcom/macrofocus/common/date/CPTimeZone;", "(Ljava/lang/String;Lcom/macrofocus/common/locale/CPLocale;Lcom/macrofocus/common/date/CPTimeZone;)V", "dateFormat", "Ljava/text/DateFormat;", "getDateFormat", "()Ljava/text/DateFormat;", "horizontalAlignment", "Lcom/macrofocus/common/format/CPFormat$HorizontalAlignment;", "getHorizontalAlignment", "()Lcom/macrofocus/common/format/CPFormat$HorizontalAlignment;", "nativeFormat", "getNativeFormat", "()Ljava/lang/Object;", "getPattern", "()Ljava/lang/String;", "format", "value", "formatHtml", "htmlSupported", "", "getClassName", "parse", "text", "macrofocus-common"})
    private static final class SwingDateFormat
    implements CPFormat<Object> {
        @NotNull
        private final DateFormat dateFormat;
        @Nullable
        private final String pattern;

        @NotNull
        public final DateFormat getDateFormat() {
            return this.dateFormat;
        }

        @Override
        @Nullable
        public String getPattern() {
            return this.pattern;
        }

        @Override
        @NotNull
        public String format(@Nullable Object value) {
            return this.formatHtml(value, false);
        }

        @Override
        @NotNull
        public String formatHtml(@Nullable Object value, boolean htmlSupported) {
            String string;
            if (value != null) {
                Date date;
                Date date2 = null;
                if (value instanceof Number) {
                    date = new Date(((Number)value).longValue());
                } else if (value instanceof Date) {
                    date = (Date)value;
                } else {
                    return value.toString();
                }
                date2 = date;
                String string2 = this.dateFormat.format(date2);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dateFormat.format(date)");
            } else {
                string = "";
            }
            return string;
        }

        @Override
        @NotNull
        public Object parse(@Nullable String text) throws CPFormat.ParsingException {
            Date date;
            try {
                date = this.dateFormat.parse(text);
            }
            catch (ParseException e) {
                throw (Throwable)new CPFormat.ParsingException(e.getMessage(), e.getErrorOffset());
            }
            return date;
        }

        @Override
        @NotNull
        public Object getNativeFormat() {
            return this.dateFormat;
        }

        @Override
        @Nullable
        public CPFormat.HorizontalAlignment getHorizontalAlignment() {
            return null;
        }

        @Override
        @Nullable
        public String getClassName(@Nullable Object value) {
            return null;
        }

        public SwingDateFormat(@Nullable String pattern) {
            this.dateFormat = new SimpleDateFormat(pattern);
            this.pattern = pattern;
        }

        public SwingDateFormat(@NotNull String pattern, @NotNull CPLocale locale) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            this.dateFormat = new SimpleDateFormat(pattern, locale.getLocale());
            this.pattern = pattern;
        }

        public SwingDateFormat(@Nullable String pattern, @NotNull CPLocale locale, @NotNull CPTimeZone timeZone) {
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
            this.dateFormat = new SimpleDateFormat(pattern, locale.getLocale());
            ((SimpleDateFormat)this.dateFormat).setTimeZone(timeZone.getTimeZone());
            this.pattern = pattern;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/macrofocus/common/format/FormatFactory$Companion;", "", "()V", "instance", "Lcom/macrofocus/common/format/FormatFactory;", "getInstance", "()Lcom/macrofocus/common/format/FormatFactory;", "macrofocus-common"})
    public static final class Companion {
        @NotNull
        public final FormatFactory getInstance() {
            return instance;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

