/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.interval;

import com.macrofocus.common.collection.CollectionFactory;
import com.macrofocus.common.collection.WeakReference;
import com.macrofocus.common.interval.IntervalEvent;
import com.macrofocus.common.interval.IntervalListener;
import com.macrofocus.common.interval.MutableInterval;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0012\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0004J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/macrofocus/common/interval/AbstractMutableInterval;", "Lcom/macrofocus/common/interval/MutableInterval;", "()V", "listeners", "", "Lcom/macrofocus/common/interval/IntervalListener;", "addIntervalListener", "", "listener", "addWeakIntervalListener", "notifyIntervalChanged", "event", "Lcom/macrofocus/common/interval/IntervalEvent;", "removeIntervalListener", "removeIntervalListeners", "WeakIntervalListener", "macrofocus-common"})
public abstract class AbstractMutableInterval
implements MutableInterval {
    private final List<IntervalListener> listeners = CollectionFactory.INSTANCE.copyOnWriteArrayList();

    @Override
    public void addIntervalListener(@NotNull IntervalListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void addWeakIntervalListener(@NotNull IntervalListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        WeakIntervalListener weakListener = new WeakIntervalListener(listener2);
        this.listeners.add(weakListener);
    }

    @Override
    public void removeIntervalListener(@NotNull IntervalListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        if (listener2 instanceof WeakIntervalListener) {
            boolean bl = this.listeners.remove(listener2);
        } else {
            IntervalListener toRemove = null;
            for (IntervalListener intervalListener2 : this.listeners) {
                IntervalListener comparable = null;
                comparable = intervalListener2 instanceof WeakIntervalListener ? ((WeakIntervalListener)intervalListener2).getReference() : intervalListener2;
                if (!Intrinsics.areEqual((Object)listener2, (Object)comparable)) continue;
                toRemove = intervalListener2;
            }
            if (toRemove != null) {
                boolean bl = this.listeners.remove(toRemove);
            }
        }
    }

    @Override
    public void removeIntervalListeners() {
        this.listeners.clear();
    }

    protected final void notifyIntervalChanged(@Nullable IntervalEvent event) {
        for (IntervalListener listener2 : this.listeners) {
            listener2.intervalChanged(event);
        }
    }

    protected AbstractMutableInterval() {
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/macrofocus/common/interval/AbstractMutableInterval$WeakIntervalListener;", "Lcom/macrofocus/common/interval/IntervalListener;", "listener", "(Lcom/macrofocus/common/interval/AbstractMutableInterval;Lcom/macrofocus/common/interval/IntervalListener;)V", "l_ref", "Lcom/macrofocus/common/collection/WeakReference;", "reference", "getReference", "()Lcom/macrofocus/common/interval/IntervalListener;", "intervalChanged", "", "event", "Lcom/macrofocus/common/interval/IntervalEvent;", "toString", "", "macrofocus-common"})
    private final class WeakIntervalListener
    implements IntervalListener {
        private final WeakReference<IntervalListener> l_ref;

        @Override
        public void intervalChanged(@Nullable IntervalEvent event) {
            IntervalListener l = this.getReference();
            if (l != null) {
                l.intervalChanged(event);
            } else {
                AbstractMutableInterval.this.removeIntervalListener(this);
            }
        }

        @NotNull
        public final IntervalListener getReference() {
            return this.l_ref.get();
        }

        @NotNull
        public String toString() {
            IntervalListener l = this.getReference();
            return l != null ? "Weak[" + l + ']' : Reflection.getOrCreateKotlinClass(this.getClass()).toString() + "@" + this.hashCode();
        }

        public WeakIntervalListener(IntervalListener listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            this.l_ref = new WeakReference<IntervalListener>(listener2);
        }
    }
}

