/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.json;

import com.macrofocus.common.json.JavaJsonValue;
import com.macrofocus.common.json.JsonContext;
import com.macrofocus.common.json.JsonString;
import com.macrofocus.common.json.JsonType;
import com.macrofocus.common.json.JsonUtil;
import com.macrofocus.common.json.JsonValue;
import com.macrofocus.common.json.JsonVisitor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0001%B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0016J\u0012\u0010\u0016\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0004H\u0016J\u0018\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020$H\u0002R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0005R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006&"}, d2={"Lcom/macrofocus/common/json/JavaJsonString;", "Lcom/macrofocus/common/json/JavaJsonValue;", "Lcom/macrofocus/common/json/JsonString;", "string", "", "(Ljava/lang/String;)V", "object", "", "getObject", "()Ljava/lang/Object;", "getString", "()Ljava/lang/String;", "setString", "type", "Lcom/macrofocus/common/json/JsonType;", "getType", "()Lcom/macrofocus/common/json/JsonType;", "asBoolean", "", "asNumber", "", "asString", "jsEquals", "value", "Lcom/macrofocus/common/json/JsonValue;", "readObject", "", "stream", "Ljava/io/ObjectInputStream;", "toJson", "traverse", "visitor", "Lcom/macrofocus/common/json/JsonVisitor;", "ctx", "Lcom/macrofocus/common/json/JsonContext;", "writeObject", "Ljava/io/ObjectOutputStream;", "Companion", "macrofocus-common"})
public final class JavaJsonString
extends JavaJsonValue
implements JsonString {
    @NotNull
    private String string;
    private static final long serialVersionUID = 1L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean asBoolean() {
        CharSequence charSequence = this.getString();
        boolean bl = false;
        return !(charSequence.length() == 0);
    }

    @Override
    public double asNumber() {
        double d;
        try {
            double d2;
            String string = this.asString();
            Intrinsics.checkNotNull((Object)string);
            CharSequence charSequence = string;
            boolean bl = false;
            if (charSequence.length() == 0) {
                d2 = 0.0;
            } else {
                String string2 = this.asString();
                Intrinsics.checkNotNull((Object)string2);
                charSequence = string2;
                bl = false;
                d2 = Double.parseDouble((String)charSequence);
            }
            d = d2;
        }
        catch (NumberFormatException nfe) {
            d = Double.NaN;
        }
        return d;
    }

    @Override
    @Nullable
    public String asString() {
        return this.getString();
    }

    @Override
    @NotNull
    public Object getObject() {
        return this.getString();
    }

    @Override
    @NotNull
    public JsonType getType() {
        return JsonType.STRING;
    }

    @Override
    public boolean jsEquals(@Nullable JsonValue value) {
        JsonValue jsonValue = value;
        if (jsonValue == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.macrofocus.common.json.JavaJsonValue");
        }
        return Intrinsics.areEqual((Object)this.getObject(), (Object)((JavaJsonValue)jsonValue).getObject());
    }

    @Override
    public void traverse(@NotNull JsonVisitor visitor, @NotNull JsonContext ctx) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        visitor.visit(this.getString(), ctx);
    }

    @Override
    @NotNull
    public String toJson() throws IllegalStateException {
        return JsonUtil.INSTANCE.quote(this.getString());
    }

    private final void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        JavaJsonString instance = (JavaJsonString)this.parseJson(stream);
        this.setString(instance.getString());
    }

    private final void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.toJson());
    }

    @Override
    @NotNull
    public String getString() {
        return this.string;
    }

    public void setString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.string = string;
    }

    public JavaJsonString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this.string = string;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/macrofocus/common/json/JavaJsonString$Companion;", "", "()V", "serialVersionUID", "", "macrofocus-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

