/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.json;

import com.macrofocus.common.json.JsonArray;
import com.macrofocus.common.json.JsonException;
import com.macrofocus.common.json.JsonFactory;
import com.macrofocus.common.json.JsonNumber;
import com.macrofocus.common.json.JsonObject;
import com.macrofocus.common.json.JsonValue;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0004\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\t\u0010\u0016\u001a\u00020\u000bH\u0086\u0002J\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u000bJ\u0006\u0010\u0018\u001a\u00020\u000bJ\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u000bJ\u000e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005J\u0017\u0010\u001d\u001a\u0002H\u001e\"\n\b\u0000\u0010\u001e*\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u001fJ\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020#J \u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/macrofocus/common/json/JsonTokenizer;", "", "serverJsonFactory", "Lcom/macrofocus/common/json/JsonFactory;", "json", "", "(Lcom/macrofocus/common/json/JsonFactory;Ljava/lang/String;)V", "jsonFactory", "lenient", "", "position", "", "pushBackBuffer", "back", "", "c", "", "getNumberForLiteral", "Lcom/macrofocus/common/json/JsonNumber;", "literal", "getValueForLiteral", "Lcom/macrofocus/common/json/JsonValue;", "next", "n", "nextNonWhitespace", "nextString", "startChar", "nextUntilOneOf", "chars", "nextValue", "T", "()Lcom/macrofocus/common/json/JsonValue;", "parseArray", "Lcom/macrofocus/common/json/JsonArray;", "parseObject", "Lcom/macrofocus/common/json/JsonObject;", "read", "buffer", "", "pos", "len", "Companion", "macrofocus-common"})
public final class JsonTokenizer {
    private final JsonFactory jsonFactory;
    private final boolean lenient;
    private int pushBackBuffer;
    private final String json;
    private int position;
    private static final int INVALID_CHAR = -1;
    private static final String STOPCHARS = ",:]}/\\\"[{;=#";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void back(char c) {
        this.pushBackBuffer = c;
    }

    public final void back(int c) {
        this.back((char)c);
    }

    public final int next() {
        int n;
        if (this.pushBackBuffer != -1) {
            int c = this.pushBackBuffer;
            this.pushBackBuffer = -1;
            return c;
        }
        if (this.position < this.json.length()) {
            int n2 = this.position;
            this.position = n2 + 1;
            n = this.json.charAt(n2);
        } else {
            n = -1;
        }
        return n;
    }

    @NotNull
    public final String next(int n) throws JsonException {
        int n2;
        if (n == 0) {
            return "";
        }
        char[] buffer = new char[n];
        int pos = 0;
        if (this.pushBackBuffer != -1) {
            buffer[0] = (char)this.pushBackBuffer;
            pos = 1;
            this.pushBackBuffer = -1;
        }
        int len = 0;
        while (pos < n) {
            n2 = this.read(buffer, pos, n - pos);
            boolean bl = false;
            boolean bl2 = false;
            int it = n2;
            boolean bl3 = false;
            len = it;
            if (n2 == -1) break;
            pos += len;
        }
        if (pos < n) {
            throw (Throwable)new JsonException("TODO");
        }
        n2 = 0;
        return new String(buffer);
    }

    public final int nextNonWhitespace() {
        int c;
        while (Character.isSpace((char)(c = this.next()))) {
        }
        return c;
    }

    @NotNull
    public final String nextString(int startChar) throws JsonException {
        StringBuilder buffer = new StringBuilder();
        int c = this.next();
        boolean bl = c == 34 || this.lenient && c == 39;
        int n = 0;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        block12: while (true) {
            c = this.next();
            switch (c) {
                case 10: 
                case 13: {
                    throw (Throwable)new JsonException("");
                }
                case -1: {
                    throw (Throwable)new JsonException("Invalid string: closing " + startChar + " is not found");
                }
                case 92: {
                    c = this.next();
                    switch (c) {
                        case 98: {
                            buffer.append('\b');
                            continue block12;
                        }
                        case 116: {
                            buffer.append('\t');
                            continue block12;
                        }
                        case 110: {
                            buffer.append('\n');
                            continue block12;
                        }
                        case 114: {
                            buffer.append('\r');
                            continue block12;
                        }
                        case 117: {
                            String string = this.next(4);
                            n = 16;
                            bl2 = false;
                            buffer.append((char)Integer.parseInt(string, CharsKt.checkRadix((int)n)));
                            continue block12;
                        }
                    }
                    buffer.append((char)c);
                    continue block12;
                }
            }
            if (c == startChar) {
                String string = buffer.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
                return string;
            }
            buffer.append((char)c);
        }
    }

    @NotNull
    public final String nextUntilOneOf(@NotNull String chars) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        StringBuilder buffer = new StringBuilder();
        int c = this.next();
        while (c != -1) {
            if (Character.isSpace((char)c) || StringsKt.indexOf$default((CharSequence)chars, (char)((char)c), (int)0, (boolean)false, (int)6, null) >= 0) {
                this.back(c);
                break;
            }
            buffer.append((char)c);
            c = this.next();
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return string;
    }

    public final <T extends JsonValue> T nextValue() throws JsonException {
        JsonValue jsonValue;
        int c = this.nextNonWhitespace();
        this.back(c);
        switch (c) {
            case 34: 
            case 39: {
                jsonValue = this.jsonFactory.create(this.nextString(c));
                break;
            }
            case 123: {
                jsonValue = this.parseObject();
                break;
            }
            case 91: {
                jsonValue = this.parseArray();
                break;
            }
            default: {
                jsonValue = this.getValueForLiteral(this.nextUntilOneOf(STOPCHARS));
            }
        }
        return (T)jsonValue;
    }

    @NotNull
    public final JsonArray parseArray() throws JsonException {
        JsonArray array = this.jsonFactory.createArray();
        int c = this.nextNonWhitespace();
        boolean bl = c == 91;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        block7: while (true) {
            c = this.nextNonWhitespace();
            switch (c) {
                case 93: {
                    return array;
                }
            }
            this.back(c);
            array.set(array.length(), (JsonValue)this.nextValue());
            int d = this.nextNonWhitespace();
            switch (d) {
                case 93: {
                    return array;
                }
                case 44: {
                    continue block7;
                }
            }
            break;
        }
        throw (Throwable)new JsonException("Invalid array: expected , or ]");
    }

    @NotNull
    public final JsonObject parseObject() throws JsonException {
        block18: {
            JsonObject object = this.jsonFactory.createObject();
            int c = this.nextNonWhitespace();
            if (c != 123) {
                throw (Throwable)new JsonException("Payload does not begin with '{'.  Got " + c + "(" + Character.valueOf((char)c) + ")");
            }
            block13: while (true) {
                c = this.nextNonWhitespace();
                switch (c) {
                    case 125: {
                        return object;
                    }
                    case 34: 
                    case 39: {
                        this.back(c);
                        String key = this.nextString(c);
                        if (this.nextNonWhitespace() != 58) {
                            throw (Throwable)new JsonException("Invalid object: expecting \":\"");
                        }
                        object.put(key, (JsonValue)this.nextValue());
                        switch (this.nextNonWhitespace()) {
                            case 44: {
                                continue block13;
                            }
                            case 125: {
                                return object;
                            }
                        }
                        throw (Throwable)new JsonException("Invalid object: expecting } or ,");
                    }
                    case 44: {
                        continue block13;
                    }
                }
                if (!this.lenient || !Character.isDigit((char)c) && !Character.isLetterOrDigit((char)c)) break block18;
                StringBuilder keyBuffer = new StringBuilder();
                keyBuffer.append(c);
                while (Character.isDigit((char)(c = this.next())) || Character.isLetterOrDigit((char)c)) {
                    keyBuffer.append(c);
                }
                this.back(c);
                if (this.nextNonWhitespace() != 58) {
                    throw (Throwable)new JsonException("Invalid object: expecting \":\"");
                }
                String string = keyBuffer.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"keyBuffer.toString()");
                object.put(string, (JsonValue)this.nextValue());
                switch (this.nextNonWhitespace()) {
                    case 44: {
                        continue block13;
                    }
                    case 125: {
                        return object;
                    }
                }
                break;
            }
            throw (Throwable)new JsonException("Invalid object: expecting } or ,");
        }
        throw (Throwable)new JsonException("Invalid object: ");
    }

    private final JsonNumber getNumberForLiteral(String literal) throws JsonException {
        Object object;
        try {
            object = literal;
            boolean bl = false;
            object = this.jsonFactory.create(Double.parseDouble((String)object));
        }
        catch (NumberFormatException e) {
            throw (Throwable)new JsonException("Invalid number literal: " + literal);
        }
        return object;
    }

    private final JsonValue getValueForLiteral(String literal) throws JsonException {
        if (Intrinsics.areEqual((Object)"", (Object)literal)) {
            throw (Throwable)new JsonException("Missing value");
        }
        if (Intrinsics.areEqual((Object)"null", (Object)literal) || Intrinsics.areEqual((Object)"undefined", (Object)literal)) {
            return this.jsonFactory.createNull();
        }
        if (Intrinsics.areEqual((Object)"true", (Object)literal)) {
            return this.jsonFactory.create(true);
        }
        if (Intrinsics.areEqual((Object)"false", (Object)literal)) {
            return this.jsonFactory.create(false);
        }
        char c = literal.charAt(0);
        if (c == '-' || Character.isDigit(c)) {
            return this.getNumberForLiteral(literal);
        }
        throw (Throwable)new JsonException("Invalid literal: \"" + literal + '\"');
    }

    private final int read(char[] buffer, int pos, int len) {
        String src;
        int maxLen = Math.min(this.json.length() - this.position, len);
        String string = this.json;
        int n = this.position;
        int n2 = this.position + maxLen;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string4 = src = string3;
        n2 = 0;
        String string5 = string4;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string5.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] result = cArray;
        System.arraycopy(result, 0, buffer, pos, maxLen);
        this.position += maxLen;
        return maxLen;
    }

    public JsonTokenizer(@NotNull JsonFactory serverJsonFactory, @NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)serverJsonFactory, (String)"serverJsonFactory");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.lenient = true;
        this.pushBackBuffer = -1;
        this.jsonFactory = serverJsonFactory;
        this.json = json;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/macrofocus/common/json/JsonTokenizer$Companion;", "", "()V", "INVALID_CHAR", "", "STOPCHARS", "", "macrofocus-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

