/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.properties;

import com.macrofocus.common.collection.CollectionFactory;
import com.macrofocus.common.collection.WeakReference;
import com.macrofocus.common.properties.Properties;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J\u0016\u0010\n\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J%\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00028\u00002\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eH\u0004\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/macrofocus/common/properties/AbstractProperties;", "K", "Lcom/macrofocus/common/properties/Properties;", "()V", "listeners", "", "Lcom/macrofocus/common/properties/PropertiesListener;", "addPropertiesListener", "", "listener", "addWeakPropertiesListener", "notifyPropertyChanged", "name", "event", "Lcom/macrofocus/common/properties/PropertyEvent;", "", "(Ljava/lang/Object;Lcom/macrofocus/common/properties/PropertyEvent;)V", "removePropertiesListener", "WeakPropertiesListener", "macrofocus-common"})
public abstract class AbstractProperties<K>
implements Properties<K> {
    private final List<PropertiesListener<K>> listeners = CollectionFactory.INSTANCE.copyOnWriteArrayList();

    @Override
    public void addPropertiesListener(@NotNull PropertiesListener<K> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void addWeakPropertiesListener(@NotNull PropertiesListener<K> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        WeakPropertiesListener weakListener = new WeakPropertiesListener(listener2);
        this.listeners.add(weakListener);
    }

    @Override
    public void removePropertiesListener(@NotNull PropertiesListener<K> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        if (listener2 instanceof WeakPropertiesListener) {
            boolean bl = this.listeners.remove(listener2);
        } else {
            PropertiesListener<K> toRemove = null;
            for (PropertiesListener<K> propertiesListener : this.listeners) {
                PropertiesListener<K> comparable = null;
                comparable = propertiesListener instanceof WeakPropertiesListener ? ((WeakPropertiesListener)propertiesListener).getReference() : propertiesListener;
                if (!listener2.equals(comparable)) continue;
                toRemove = propertiesListener;
            }
            if (toRemove != null) {
                boolean bl = this.listeners.remove(toRemove);
            }
        }
        this.listeners.remove(listener2);
    }

    protected final void notifyPropertyChanged(K name, @NotNull PropertyEvent<Object> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        for (PropertiesListener<K> listener2 : this.listeners) {
            listener2.propertyChanged(name, event);
        }
    }

    @Override
    public Iterator<K> iterator() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001\u00a2\u0006\u0002\u0010\u0003J%\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u00002\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/macrofocus/common/properties/AbstractProperties$WeakPropertiesListener;", "Lcom/macrofocus/common/properties/PropertiesListener;", "listener", "(Lcom/macrofocus/common/properties/AbstractProperties;Lcom/macrofocus/common/properties/PropertiesListener;)V", "l_ref", "Lcom/macrofocus/common/collection/WeakReference;", "reference", "getReference", "()Lcom/macrofocus/common/properties/PropertiesListener;", "propertyChanged", "", "name", "event", "Lcom/macrofocus/common/properties/PropertyEvent;", "", "(Ljava/lang/Object;Lcom/macrofocus/common/properties/PropertyEvent;)V", "toString", "", "macrofocus-common"})
    private final class WeakPropertiesListener
    implements PropertiesListener<K> {
        private final WeakReference<PropertiesListener<K>> l_ref;

        @Override
        public void propertyChanged(K name, @NotNull PropertyEvent<Object> event) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            PropertiesListener l = this.getReference();
            if (l != null) {
                l.propertyChanged(name, event);
            } else {
                AbstractProperties.this.removePropertiesListener(this);
            }
        }

        @Nullable
        public final PropertiesListener<K> getReference() {
            return this.l_ref.get();
        }

        @NotNull
        public String toString() {
            PropertiesListener l = this.getReference();
            return l != null ? "Weak[" + l + ']' : String.valueOf(l);
        }

        public WeakPropertiesListener(PropertiesListener<K> listener2) {
            Intrinsics.checkNotNullParameter(listener2, (String)"listener");
            this.l_ref = new WeakReference(listener2);
        }
    }
}

