/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.selection;

import com.macrofocus.common.collection.CollectionFactory;
import com.macrofocus.common.collection.WeakReference;
import com.macrofocus.common.selection.AbstractMutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0016J\u0016\u0010\u000b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0016J\u0016\u0010\f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0004J\u0016\u0010\u000f\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/macrofocus/common/selection/AbstractMutableSingleSelection;", "E", "Lcom/macrofocus/common/selection/AbstractMutableSelection;", "Lcom/macrofocus/common/selection/MutableSingleSelection;", "()V", "listeners", "", "Lcom/macrofocus/common/selection/SingleSelectionListener;", "addSingleSelectionListener", "", "listener", "addWeakSingleSelectionListener", "notifySingleSelectedChanged", "event", "Lcom/macrofocus/common/selection/SingleSelectionEvent;", "removeSingleSelectionListener", "WeakSingleSelectionListener", "macrofocus-common"})
public abstract class AbstractMutableSingleSelection<E>
extends AbstractMutableSelection<E>
implements MutableSingleSelection<E> {
    private final List<SingleSelectionListener<E>> listeners = CollectionFactory.INSTANCE.copyOnWriteArrayList();

    @Override
    public void addSingleSelectionListener(@NotNull SingleSelectionListener<E> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void addWeakSingleSelectionListener(@NotNull SingleSelectionListener<E> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        WeakSingleSelectionListener weakListener = new WeakSingleSelectionListener(listener2);
        this.listeners.add(weakListener);
    }

    @Override
    public void removeSingleSelectionListener(@NotNull SingleSelectionListener<E> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        if (listener2 instanceof WeakSingleSelectionListener) {
            boolean bl = this.listeners.remove(listener2);
        } else {
            SingleSelectionListener<E> toRemove = null;
            for (SingleSelectionListener<E> selectionListener : this.listeners) {
                SingleSelectionListener<E> comparable = null;
                comparable = selectionListener instanceof WeakSingleSelectionListener ? ((WeakSingleSelectionListener)selectionListener).getReference() : selectionListener;
                if (!listener2.equals(comparable)) continue;
                toRemove = selectionListener;
            }
            if (toRemove != null) {
                boolean bl = this.listeners.remove(toRemove);
            }
        }
    }

    protected final void notifySingleSelectedChanged(@NotNull SingleSelectionEvent<E> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        for (SingleSelectionListener<E> listener2 : this.listeners) {
            listener2.selectionChanged(event);
        }
        super.notifySelectedChanged(event);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001\u00a2\u0006\u0002\u0010\u0003J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/macrofocus/common/selection/AbstractMutableSingleSelection$WeakSingleSelectionListener;", "Lcom/macrofocus/common/selection/SingleSelectionListener;", "listener", "(Lcom/macrofocus/common/selection/AbstractMutableSingleSelection;Lcom/macrofocus/common/selection/SingleSelectionListener;)V", "l_ref", "Lcom/macrofocus/common/collection/WeakReference;", "getReference", "selectionChanged", "", "event", "Lcom/macrofocus/common/selection/SingleSelectionEvent;", "toString", "", "macrofocus-common"})
    private final class WeakSingleSelectionListener
    implements SingleSelectionListener<E> {
        private final WeakReference<SingleSelectionListener<E>> l_ref;

        @Override
        public void selectionChanged(@NotNull SingleSelectionEvent<E> event) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            SingleSelectionListener l = this.getReference();
            if (l != null) {
                l.selectionChanged(event);
            } else {
                AbstractMutableSingleSelection.this.removeSingleSelectionListener(this);
            }
        }

        @NotNull
        public final SingleSelectionListener<E> getReference() {
            return this.l_ref.get();
        }

        @NotNull
        public String toString() {
            SingleSelectionListener l = this.getReference();
            return l != null ? "Weak[" + l + ']' : Reflection.getOrCreateKotlinClass(this.getClass()).toString() + "@" + this.hashCode();
        }

        public WeakSingleSelectionListener(SingleSelectionListener<E> listener2) {
            Intrinsics.checkNotNullParameter(listener2, (String)"listener");
            this.l_ref = new WeakReference(listener2);
        }
    }
}

