/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.units;

import com.macrofocus.common.units.Angle;
import com.macrofocus.common.units.ApparentPower;
import com.macrofocus.common.units.Current;
import com.macrofocus.common.units.Power;
import com.macrofocus.common.units.Quantity;
import com.macrofocus.common.units.QuantityKt;
import com.macrofocus.common.units.ReactivePower;
import com.macrofocus.common.units.Unit;
import com.macrofocus.common.units.Voltage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\u001a2\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00012\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u001a2\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u001a2\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u001a2\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00012\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u001a\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001\u001a2\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00012\f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00012\b\b\u0002\u0010\u0007\u001a\u00020\u000b\u00a8\u0006\u0013"}, d2={"activePower", "Lcom/macrofocus/common/units/Quantity;", "Lcom/macrofocus/common/units/Power;", "apparentPower", "Lcom/macrofocus/common/units/ApparentPower;", "phaseAngle", "Lcom/macrofocus/common/units/Angle;", "unit", "apparentPower1", "apparentPower2", "reactivePower", "Lcom/macrofocus/common/units/ReactivePower;", "power", "voltage", "Lcom/macrofocus/common/units/Voltage;", "current", "Lcom/macrofocus/common/units/Current;", "powerFactor", "", "macrofocus-common"})
public final class ElectricityKt {
    @NotNull
    public static final Quantity<Power> power(@NotNull Quantity<Voltage> voltage, @NotNull Quantity<Current> current, @NotNull Power unit) {
        Intrinsics.checkNotNullParameter(voltage, (String)"voltage");
        Intrinsics.checkNotNullParameter(current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return QuantityKt.into(voltage.into((Unit)Voltage.Factory.getVolt()).getAmount() * current.into((Unit)Current.Factory.getAmpere()).getAmount(), (Unit)unit);
    }

    public static /* synthetic */ Quantity power$default(Quantity quantity, Quantity quantity2, Power power, int n, Object object) {
        if ((n & 4) != 0) {
            power = Power.Factory.getWatt();
        }
        return ElectricityKt.power(quantity, quantity2, power);
    }

    @NotNull
    public static final Quantity<ApparentPower> apparentPower1(@NotNull Quantity<Power> activePower, @NotNull Quantity<Angle> phaseAngle, @NotNull ApparentPower unit) {
        Intrinsics.checkNotNullParameter(activePower, (String)"activePower");
        Intrinsics.checkNotNullParameter(phaseAngle, (String)"phaseAngle");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        double d = phaseAngle.into((Unit)Angle.Factory.getRadian()).getAmount();
        boolean bl = false;
        return QuantityKt.into(activePower.getAmount() / Math.cos(d), (Unit)unit);
    }

    public static /* synthetic */ Quantity apparentPower1$default(Quantity quantity, Quantity quantity2, ApparentPower apparentPower, int n, Object object) {
        if ((n & 4) != 0) {
            apparentPower = ApparentPower.Factory.getVoltAmpere();
        }
        return ElectricityKt.apparentPower1(quantity, quantity2, apparentPower);
    }

    @NotNull
    public static final Quantity<ApparentPower> apparentPower2(@NotNull Quantity<Power> activePower, @NotNull Quantity<ReactivePower> reactivePower, @NotNull ApparentPower unit) {
        Intrinsics.checkNotNullParameter(activePower, (String)"activePower");
        Intrinsics.checkNotNullParameter(reactivePower, (String)"reactivePower");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        double d = activePower.getAmount();
        int n = 2;
        boolean bl = false;
        double d2 = Math.pow(d, n);
        d = reactivePower.getAmount();
        n = 2;
        bl = false;
        d = d2 + Math.pow(d, n);
        n = 0;
        return QuantityKt.into(Math.sqrt(d), (Unit)unit);
    }

    public static /* synthetic */ Quantity apparentPower2$default(Quantity quantity, Quantity quantity2, ApparentPower apparentPower, int n, Object object) {
        if ((n & 4) != 0) {
            apparentPower = ApparentPower.Factory.getVoltAmpere();
        }
        return ElectricityKt.apparentPower2(quantity, quantity2, apparentPower);
    }

    @NotNull
    public static final Quantity<Power> activePower(@NotNull Quantity<ApparentPower> apparentPower, @NotNull Quantity<Angle> phaseAngle, @NotNull Power unit) {
        Intrinsics.checkNotNullParameter(apparentPower, (String)"apparentPower");
        Intrinsics.checkNotNullParameter(phaseAngle, (String)"phaseAngle");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        double d = phaseAngle.into((Unit)Angle.Factory.getRadian()).getAmount();
        boolean bl = false;
        return QuantityKt.into(apparentPower.getAmount() * Math.cos(d), (Unit)unit);
    }

    public static /* synthetic */ Quantity activePower$default(Quantity quantity, Quantity quantity2, Power power, int n, Object object) {
        if ((n & 4) != 0) {
            power = Power.Factory.getWatt();
        }
        return ElectricityKt.activePower(quantity, quantity2, power);
    }

    @NotNull
    public static final Quantity<ReactivePower> reactivePower(@NotNull Quantity<ApparentPower> activePower, @NotNull Quantity<Angle> phaseAngle, @NotNull ReactivePower unit) {
        Intrinsics.checkNotNullParameter(activePower, (String)"activePower");
        Intrinsics.checkNotNullParameter(phaseAngle, (String)"phaseAngle");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        double d = phaseAngle.into((Unit)Angle.Factory.getRadian()).getAmount();
        boolean bl = false;
        return QuantityKt.into(activePower.getAmount() * Math.sin(d), (Unit)unit);
    }

    public static /* synthetic */ Quantity reactivePower$default(Quantity quantity, Quantity quantity2, ReactivePower reactivePower, int n, Object object) {
        if ((n & 4) != 0) {
            reactivePower = ReactivePower.Factory.getVoltAmpereReactive();
        }
        return ElectricityKt.reactivePower(quantity, quantity2, reactivePower);
    }

    public static final double powerFactor(@NotNull Quantity<Angle> phaseAngle) {
        Intrinsics.checkNotNullParameter(phaseAngle, (String)"phaseAngle");
        double d = phaseAngle.into((Unit)Angle.Factory.getRadian()).getAmount();
        boolean bl = false;
        return Math.cos(d);
    }
}

