/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.units;

import com.macrofocus.common.units.Unit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0016\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/macrofocus/common/units/Voltage;", "Lcom/macrofocus/common/units/Unit;", "name", "", "symbol", "ratio", "", "(Ljava/lang/String;Ljava/lang/String;D)V", "Factory", "macrofocus-common"})
public class Voltage
extends Unit {
    @NotNull
    private static final Voltage Picovolt;
    @NotNull
    private static final Voltage Nanovolt;
    @NotNull
    private static final Voltage Microvolt;
    @NotNull
    private static final Voltage Millivolt;
    @NotNull
    private static final Voltage Volt;
    @NotNull
    private static final Voltage Kilovolt;
    @NotNull
    private static final Voltage Megavolt;
    @NotNull
    private static final Voltage Gigavolt;
    @NotNull
    private static final Voltage Teravolt;
    @NotNull
    private static final Voltage Petavolt;
    @NotNull
    public static final Factory Factory;

    public Voltage(@NotNull String name, @NotNull String symbol, double ratio) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        super(name, symbol, ratio);
    }

    static {
        Factory = new Factory(null);
        Picovolt = new Voltage("Picovolt", "pV", 1.0E-7);
        Nanovolt = new Voltage("Nanovolt", "nV", 1.0E-10);
        Microvolt = new Voltage("Microvolt", "\u00b5V", 1.0E-7);
        Millivolt = new Voltage("Millivolt", "mV", 1.0E-4);
        Volt = new Voltage("Volt", "V", 1.0);
        Kilovolt = new Voltage("Kilovolt", "kV", 1000.0);
        Megavolt = new Voltage("Megavolt", "MV", 1000000.0);
        Gigavolt = new Voltage("Gigavolt", "GV", 1.0E9);
        Teravolt = new Voltage("Teravolt", "TV", 1.0E12);
        Petavolt = new Voltage("Petavolt", "PV", 1.0E15);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lcom/macrofocus/common/units/Voltage$Factory;", "", "()V", "Gigavolt", "Lcom/macrofocus/common/units/Voltage;", "getGigavolt", "()Lcom/macrofocus/common/units/Voltage;", "Kilovolt", "getKilovolt", "Megavolt", "getMegavolt", "Microvolt", "getMicrovolt", "Millivolt", "getMillivolt", "Nanovolt", "getNanovolt", "Petavolt", "getPetavolt", "Picovolt", "getPicovolt", "Teravolt", "getTeravolt", "Volt", "getVolt", "macrofocus-common"})
    public static final class Factory {
        @NotNull
        public final Voltage getPicovolt() {
            return Picovolt;
        }

        @NotNull
        public final Voltage getNanovolt() {
            return Nanovolt;
        }

        @NotNull
        public final Voltage getMicrovolt() {
            return Microvolt;
        }

        @NotNull
        public final Voltage getMillivolt() {
            return Millivolt;
        }

        @NotNull
        public final Voltage getVolt() {
            return Volt;
        }

        @NotNull
        public final Voltage getKilovolt() {
            return Kilovolt;
        }

        @NotNull
        public final Voltage getMegavolt() {
            return Megavolt;
        }

        @NotNull
        public final Voltage getGigavolt() {
            return Gigavolt;
        }

        @NotNull
        public final Voltage getTeravolt() {
            return Teravolt;
        }

        @NotNull
        public final Voltage getPetavolt() {
            return Petavolt;
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

