package com.macrofocus.common.properties.adapter

import com.macrofocus.common.interval.IntervalEvent
import com.macrofocus.common.interval.IntervalListener
import com.macrofocus.common.interval.MutableInterval
import com.macrofocus.common.properties.AbstractMutableProperty
import com.macrofocus.common.properties.PropertyEvent

class IntervalProperty(private val interval: MutableInterval, private var side: Value) : AbstractMutableProperty<Double>() {
    enum class Value {
        Start, End
    }

    init {
        interval.addIntervalListener(object : IntervalListener {
            override fun intervalChanged(event: IntervalEvent) {
                when (side) {
                    Value.Start -> notifyPropertyChanged(PropertyEvent<Double>(event.oldStart, event.newStart))
                    Value.End -> notifyPropertyChanged(PropertyEvent<Double>(event.oldEnd, event.newEnd))
                }
            }
        })
    }

    override var value: Double
        get() {
            return when (side) {
                Value.Start -> interval.start
                Value.End -> interval.end
            }
        }
        set(value) {
            when (this.side) {
                Value.Start -> interval.start = value
                Value.End -> interval.end = value
            }
        }
}
