package com.macrofocus.common.concurrent

import com.macrofocus.common.command.Future

actual class FutureTask<V> actual constructor(callable: Callable<V>) : Future<V>, Runnable {
    val wrapped = java.util.concurrent.FutureTask<V>(object : java.util.concurrent.Callable<V> {
        override fun call(): V {
            return callable.call()
        }
    })

    override val isDone: Boolean
        get() = wrapped.isDone
    override val isCancelled: Boolean
        get() = wrapped.isCancelled

    override fun get(): V? {
        return wrapped.get()
    }

    override fun cancel(mayInterruptIfRunning: Boolean): Boolean {
        return wrapped.cancel(mayInterruptIfRunning)
    }

    override fun run() {
        wrapped.run()
    }
}