package com.macrofocus.common.helper

import java.awt.event.ActionListener

class WeakActionListeners {
    private var strong: MutableList<ActionListener>? = null

    fun create(actionListener: ActionListener, src: Any): ActionListener {
        if (ENABLED) {
            if (strong == null) {
                strong = ArrayList()
            }
            strong!!.add(actionListener)
            return WeakActionListener(actionListener, src)
        } else {
            return actionListener
        }
    }

    fun remove(actionListener: ActionListener): ActionListener {
        if (ENABLED) {
            strong!!.remove(actionListener)
            return actionListener
        } else {
            return actionListener
        }
    }

    companion object {
        private const val ENABLED = false
    }
}
