package com.macrofocus.common.collection

interface RandomAccessIterable<T> : Iterable<T> {
    fun size(): Int
    operator fun get(index: Int): T
}

fun <T> List<T>.asRandomAccessIterable(): RandomAccessIterable<T> {
    return object : RandomAccessIterable<T> {
        override fun size(): Int {
            return this@asRandomAccessIterable.size
        }

        override fun get(index: Int): T {
            return this@asRandomAccessIterable[index]
        }

        override fun iterator(): Iterator<T> {
            return this@asRandomAccessIterable.iterator()
        }
    }
}

fun <T> RandomAccessIterable<T>.toArrayList(): List<T> {
    val list: ArrayList<T> = ArrayList(this.size())
    for (t in this.iterator()) {
        list.add(t)
    }
    return list
}
