package com.macrofocus.common.math

import kotlin.math.ln
import kotlin.math.max
import kotlin.math.min

/**
 * Created by IntelliJ IDEA.
 * User: luc
 * Date: Feb 22, 2007
 * Time: 6:37:40 AM
 */
class Range {
    override fun toString(): String {
        return "[" + min + ", " + max + "]"
    }

    val range: Double
        get() {
            if (isInfinite(max - min)) return (0.0f / 0.0f).toDouble()
            else return max - min
        }

    constructor(min: Double, max: Double) {
        this.min = (0.0f / 0.0f).toDouble()
        this.max = (0.0f / 0.0f).toDouble()
        if (min <= max) {
            this.min = min
            this.max = max
        }
    }

    constructor(roleModel: Range) {
        min = (0.0f / 0.0f).toDouble()
        max = (0.0f / 0.0f).toDouble()
        min = roleModel.min
        max = roleModel.max
    }

    constructor(ranges: kotlin.Array<Range?>) {
        min = (0.0f / 0.0f).toDouble()
        max = (0.0f / 0.0f).toDouble()
        if (ranges.size >= 1) {
            min = ranges[0]!!.min
            max = ranges[0]!!.max
            for (i in 1..<ranges.size) {
                min = min(min, ranges[i]!!.min)
                max = max(max, ranges[i]!!.max)
            }
        }
    }

    constructor(data: DoubleArray) {
        min = (0.0f / 0.0f).toDouble()
        max = (0.0f / 0.0f).toDouble()
        widen(data)
    }

    constructor(data: DoubleArray, valids: IntArray) {
        min = (0.0f / 0.0f).toDouble()
        max = (0.0f / 0.0f).toDouble()
        widen(data, valids)
    }

    constructor(data: kotlin.Array<DoubleArray?>) {
        min = (0.0f / 0.0f).toDouble()
        max = (0.0f / 0.0f).toDouble()
        for (i in data.indices) widen(data[i]!!)
    }

    fun scale(scale: Double): Range {
        return Range(min * scale, max * scale)
    }

    fun log(): Range {
        return Range(ln(min), ln(max))
    }

    fun getSubRanges(count: Int): kotlin.Array<Range?> {
        val result = kotlin.arrayOfNulls<Range>(count)
        val min = this.min
        val range = this.range
        for (i in result.indices) result[i] = Range(
            min + (range * i.toDouble()) / result.size.toDouble(),
            min + (range * (i + 1).toDouble()) / result.size.toDouble()
        )

        return result
    }

    fun contains(value: Double): Boolean {
        return value >= min && value <= max
    }

    fun getClippedValue(value: Double): Double {
        return min(max, max(min, value))
    }

    fun makeSymmetrical(): Range {
        val extent = max(-min, max)
        return Range(-extent, extent)
    }

    fun ensureWidth(width: Double): Range {
        val halfDiff = (width - this.range) / 2.0f
        if (halfDiff <= 0.0f) return this
        else return Range(min - halfDiff, max + halfDiff)
    }

    fun widenAbsolute(extent: Double): Range {
        return Range(min - extent, max + extent)
    }

    fun widenRelative(ratio: Double): Range {
        val extend = (max - min) * ratio
        return widenAbsolute(extend)
    }

    fun widen(data: DoubleArray) {
        for (i in data.indices) {
            min = min(data[i], min)
            max = max(data[i], max)
        }
    }

    fun widen(data: DoubleArray, valids: IntArray) {
        for (i in valids.indices) {
            min = min(data[valids[i]], min)
            max = max(data[valids[i]], max)
        }
    }

    fun toDoubleArray(): DoubleArray? {
        return (doubleArrayOf(
            min, max
        ))
    }

    var min: Double
    var max: Double
}
