package com.macrofocus.common.properties.adapter

import com.macrofocus.common.interval.IntervalEvent
import com.macrofocus.common.interval.IntervalListener
import com.macrofocus.common.interval.MutableBoundedInterval
import com.macrofocus.common.properties.AbstractMutableProperty
import com.macrofocus.common.properties.PropertyEvent


class BoundedIntervalProperty(private val interval: MutableBoundedInterval,
                              private var startEnd: StartEnd)
    : AbstractMutableProperty<Double?>() {
    enum class StartEnd {
        Start, End
    }

    override var value: Double?
        get() = when (startEnd) {
            StartEnd.Start -> interval.start
            StartEnd.End -> interval.end
        }
        set(value) {when (this.startEnd) {
            StartEnd.Start -> interval.start = value!!
            StartEnd.End -> interval.end = value!!
        }}

     init {
        interval.addIntervalListener(object : IntervalListener {
            override fun intervalChanged(event: IntervalEvent) {
                when (startEnd) {
                    StartEnd.Start -> notifyPropertyChanged(
                        PropertyEvent<Double?>(
                            event.oldStart, event.newStart
                        )
                    )
                    StartEnd.End -> notifyPropertyChanged(PropertyEvent<Double?>(event!!.oldEnd, event.newEnd))
                }
            }
        })
    }
}
