/*
 * Copyright (c) 2011 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.hierarchy

class HierarchyEvent<T>(private val hierarchy: Hierarchy<T>, private val type: Type, val child: T?, val parent: T?, val index: Int, val isAdjusting: Boolean) {
    enum class Type {
        Inserted, Changed, Removed, StructureChanged
    }

    override fun toString(): String {
        return "HierarchyEvent{" +
                "hierarchy=" + hierarchy +
                ", type=" + type +
                ", child=" + child +
                ", parent=" + parent +
                ", index=" + index +
                ", isAdjusting=" + isAdjusting +
                '}'
    }
}