package com.macrofocus.common.collection

import java.util.concurrent.ConcurrentHashMap
import java.util.concurrent.CopyOnWriteArrayList

actual object CollectionFactory {
    actual fun <T> copyOnWriteArrayList(): MutableList<T> {
        return CopyOnWriteArrayList<T>()
    }

    actual fun <K, V> concurrentHashMap(): MutableMap<K, V> {
        return ConcurrentHashMap<K, V>()
    }

    actual fun <T> linkedHashSet(): MutableSet<T> {
        return LinkedHashSet<T>()
    }

    actual fun <T> concurrentLinkedHashSet(): MutableSet<T> {
        return ConcurrentLinkedHashSet<T>()
    }
}