package com.macrofocus.common.helper

import javax.swing.UIManager

/**
 * Helper class for dealing with look and feels.
 */
object LookAndFeelHelper {
    val isAqua: Boolean
        /**
         * @return true if the current look and feel is Aqua (Mac OS X)
         */
        get() = UIManager.getLookAndFeel().id == "Aqua"

    val isWindows: Boolean
        /**
         * @return true if the current look and feel is Windows
         */
        get() {
            val lnf = UIManager.getLookAndFeel().javaClass.name
            return "com.sun.java.swing.plaf.windows.WindowsLookAndFeel" == lnf || "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel" == lnf
        }

    val isMetal: Boolean
        /**
         * @return true if the current look and feel is Metal
         */
        get() = UIManager.getCrossPlatformLookAndFeelClassName() == UIManager.getLookAndFeel().javaClass.name

    val isSynth: Boolean
        /**
         * @return true if the current look and feel is Synth
         */
        get() = UIManager.getLookAndFeel().javaClass.name.contains("ynth")
}