/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010)\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0011\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0016J\b\u0010\u0012\u001a\u00020\bH\u0016J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0096\u0002J\u0015\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0016\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0016J\u0016\u0010\u0017\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0016J\u0015\u0010\u001c\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001e\u0018\u00010\u001d\u00a2\u0006\u0002\u0010\u001fR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006 "}, d2={"Lcom/macrofocus/common/collection/ConcurrentHashSet;", "K", "", "<init>", "()V", "map", "Ljava/util/concurrent/ConcurrentHashMap;", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "clear", "", "contains", "containsAll", "isEmpty", "iterator", "", "remove", "removeAll", "retainAll", "size", "", "getSize", "()I", "toArray", "", "", "()[Ljava/lang/Object;", "macrofocus-common"})
@SourceDebugExtension(value={"SMAP\nConcurrentHashSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConcurrentHashSet.kt\ncom/macrofocus/common/collection/ConcurrentHashSet\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,78:1\n37#2:79\n36#2,3:80\n*S KotlinDebug\n*F\n+ 1 ConcurrentHashSet.kt\ncom/macrofocus/common/collection/ConcurrentHashSet\n*L\n72#1:79\n72#1:80,3\n*E\n"})
public final class ConcurrentHashSet<K>
implements Set<K>,
KMutableSet {
    @NotNull
    private final ConcurrentHashMap<K, K> map = new ConcurrentHashMap();

    @Override
    public boolean add(K element) {
        boolean contains = this.map.containsKey(element);
        ((Map)this.map).put(element, element);
        return !contains;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends K> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean changed = false;
        for (K element : elements) {
            changed = this.add(element) || changed;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean contains(Object element) {
        return this.map.containsKey(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        for (Object o : elements) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.map.size() == 0;
    }

    @Override
    @NotNull
    public Iterator<K> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public boolean remove(Object element) {
        return this.map.remove(element) != null;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean changed = false;
        for (Object o : elements) {
            changed = this.remove(o) || changed;
        }
        return changed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.clear();
        for (Object element : elements) {
            this.add((K)element);
        }
        return true;
    }

    public int getSize() {
        return this.map.size();
    }

    @Override
    @Nullable
    public final Object[] toArray() {
        Collection<K> collection = this.map.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Collection<K> $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection<K> thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Object[0]);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }
}

