/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.format;

import com.macrofocus.common.format.DecimalFormatSymbols;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u000bJ\u001a\u0010$\u001a\u00020\u000f2\n\u0010%\u001a\u00060&j\u0002`'2\u0006\u0010(\u001a\u00020\u000bJ\u0014\u0010)\u001a\u00020*2\n\u0010+\u001a\u00060&j\u0002`'H\u0002J\u001c\u0010,\u001a\u00020*2\n\u0010+\u001a\u00060&j\u0002`'2\u0006\u0010-\u001a\u00020\u000fH\u0002J$\u0010\"\u001a\u00020*2\u0006\u0010.\u001a\u00020\u00152\n\u0010+\u001a\u00060&j\u0002`'2\u0006\u0010/\u001a\u00020\u000fH\u0004J\u001c\u00100\u001a\u00020*2\n\u0010+\u001a\u00060&j\u0002`'2\u0006\u00101\u001a\u000202H\u0002J\u0014\u00103\u001a\u00020*2\n\u0010+\u001a\u00060&j\u0002`'H\u0002J\u0014\u00104\u001a\u00020*2\n\u0010+\u001a\u00060&j\u0002`'H\u0002J\u0018\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0011\"\u0004\b\u001a\u0010\u0013R\u000e\u0010\u001b\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0011\"\u0004\b\u001f\u0010\u0013R\u000e\u0010 \u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/macrofocus/common/format/DecimalFormat;", "", "s", "", "symbols", "Lcom/macrofocus/common/format/DecimalFormatSymbols;", "<init>", "(Ljava/lang/String;Lcom/macrofocus/common/format/DecimalFormatSymbols;)V", "getSymbols", "()Lcom/macrofocus/common/format/DecimalFormatSymbols;", "multiplier", "", "getMultiplier", "()D", "decimalPosition", "", "getDecimalPosition", "()I", "setDecimalPosition", "(I)V", "decimalSeparatorAlwaysShown", "", "getDecimalSeparatorAlwaysShown", "()Z", "digitsLength", "getDigitsLength", "setDigitsLength", "exponent", "minimumFractionDigits", "maximumFractionDigits", "getMaximumFractionDigits", "setMaximumFractionDigits", "minimumIntegerDigits", "useExponentialNotation", "format", "number", "toScaledString", "buf", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "val", "processLeadingZeros", "", "digits", "propagateCarry", "i", "isNegative", "scale", "addZeroAndDecimal", "decimalSeparator", "", "adjustFractionDigits", "roundValue", "toPrecision", "d", "macrofocus-common"})
public final class DecimalFormat {
    @NotNull
    private final DecimalFormatSymbols symbols;
    private final double multiplier;
    private int decimalPosition;
    private final boolean decimalSeparatorAlwaysShown;
    private int digitsLength;
    private int exponent;
    private final int minimumFractionDigits;
    private int maximumFractionDigits;
    private final int minimumIntegerDigits;
    private final boolean useExponentialNotation;

    public DecimalFormat(@NotNull String s, @NotNull DecimalFormatSymbols symbols) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)symbols, (String)"symbols");
        this.symbols = symbols;
        this.multiplier = 1.0;
        this.maximumFractionDigits = 3;
        this.minimumIntegerDigits = 1;
    }

    public /* synthetic */ DecimalFormat(String string, DecimalFormatSymbols decimalFormatSymbols, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            decimalFormatSymbols = new DecimalFormatSymbols();
        }
        this(string, decimalFormatSymbols);
    }

    @NotNull
    public final DecimalFormatSymbols getSymbols() {
        return this.symbols;
    }

    public final double getMultiplier() {
        return this.multiplier;
    }

    public final int getDecimalPosition() {
        return this.decimalPosition;
    }

    public final void setDecimalPosition(int n) {
        this.decimalPosition = n;
    }

    public final boolean getDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorAlwaysShown;
    }

    public final int getDigitsLength() {
        return this.digitsLength;
    }

    public final void setDigitsLength(int n) {
        this.digitsLength = n;
    }

    public final int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    public final void setMaximumFractionDigits(int n) {
        this.maximumFractionDigits = n;
    }

    @NotNull
    public final String format(double number) {
        boolean isNegative;
        double number2 = number;
        if (Double.isNaN(number2)) {
            return this.symbols.getNaN();
        }
        boolean bl = number2 < 0.0 || number2 == 0.0 && 1.0 / number2 < 0.0 ? true : (isNegative = false);
        if (isNegative) {
            number2 = -number2;
        }
        StringBuilder buf = new StringBuilder();
        if (Double.isInfinite(number2)) {
            buf.append(isNegative ? this.symbols.getNegativePrefix() : this.symbols.getPositivePrefix());
            buf.append(this.symbols.getInfinity());
            buf.append(isNegative ? this.symbols.getNegativeSuffix() : this.symbols.getPositiveSuffix());
            String string = buf.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        int scale = this.toScaledString(buf, number2 *= this.multiplier);
        int preRound = buf.length() + scale + this.maximumFractionDigits + 3;
        if (preRound > 0 && preRound < buf.length() && buf.charAt(preRound) == '9') {
            this.propagateCarry(buf, preRound - 1);
            scale += buf.length() - preRound;
            Intrinsics.checkNotNullExpressionValue((Object)buf.delete(preRound, preRound + buf.length()), (String)"delete(...)");
        }
        this.format(isNegative, buf, scale);
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final int toScaledString(@NotNull StringBuilder buf, double val) {
        int dot;
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        int startLen = buf.length();
        buf.append(this.toPrecision(val, 20));
        int scale = 0;
        int expIdx = buf.indexOf("e", startLen);
        if (expIdx < 0) {
            expIdx = buf.indexOf("E", startLen);
        }
        if (expIdx >= 0) {
            int expDigits = expIdx + 1;
            if (expDigits < buf.length() && buf.charAt(expDigits) == '+') {
                ++expDigits;
            }
            if (expDigits < buf.length()) {
                String string = buf.substring(expDigits);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                scale = Integer.parseInt(string);
            }
            Intrinsics.checkNotNullExpressionValue((Object)buf.delete(expIdx, expIdx + buf.length()), (String)"delete(...)");
        }
        if ((dot = buf.indexOf(".", startLen)) >= 0) {
            Intrinsics.checkNotNullExpressionValue((Object)buf.deleteCharAt(dot), (String)"deleteCharAt(...)");
            scale -= buf.length() - dot;
        }
        return scale;
    }

    private final void processLeadingZeros(StringBuilder digits) {
        if (this.decimalPosition > this.digitsLength) {
            while (this.digitsLength < this.decimalPosition) {
                digits.append('0');
                ++this.digitsLength;
            }
        }
        if (!this.useExponentialNotation) {
            if (this.decimalPosition < this.minimumIntegerDigits) {
                StringBuilder prefix = new StringBuilder();
                while (this.decimalPosition < this.minimumIntegerDigits) {
                    prefix.append('0');
                    ++this.decimalPosition;
                    ++this.digitsLength;
                }
                digits.insert(0, prefix);
            } else if (this.decimalPosition > this.minimumIntegerDigits) {
                int strip = this.decimalPosition - this.minimumIntegerDigits;
                int n = strip;
                for (int i = 0; i < n; ++i) {
                    if (digits.charAt(i) == '0') continue;
                    strip = i;
                    break;
                }
                if (strip > 0) {
                    Intrinsics.checkNotNullExpressionValue((Object)digits.delete(0, strip), (String)"delete(...)");
                    this.digitsLength -= strip;
                    this.decimalPosition -= strip;
                }
            }
        }
    }

    private final void propagateCarry(StringBuilder digits, int i) {
        int i2 = i;
        boolean carry = true;
        while (carry && i2 >= 0) {
            char digit = digits.charAt(i2);
            if (digit == '9') {
                digits.setCharAt(i2--, '0');
                continue;
            }
            digits.setCharAt(i2, (char)(digit + '\u0001'));
            carry = false;
        }
        if (carry) {
            digits.insert(0, '1');
            ++this.decimalPosition;
            ++this.digitsLength;
        }
    }

    protected final void format(boolean isNegative, @NotNull StringBuilder digits, int scale) {
        Intrinsics.checkNotNullParameter((Object)digits, (String)"digits");
        char decimalSeparator = this.symbols.getDecimalSeparator();
        this.exponent = 0;
        this.digitsLength = digits.length();
        this.decimalPosition = this.digitsLength + scale;
        this.processLeadingZeros(digits);
        this.roundValue(digits);
        this.adjustFractionDigits(digits);
        this.addZeroAndDecimal(digits, decimalSeparator);
        digits.insert(0, isNegative ? this.symbols.getNegativePrefix() : this.symbols.getPositivePrefix());
        digits.append(isNegative ? this.symbols.getNegativeSuffix() : this.symbols.getPositiveSuffix());
    }

    private final void addZeroAndDecimal(StringBuilder digits, char decimalSeparator) {
        if (this.digitsLength == 0) {
            digits.insert(0, '0');
            ++this.decimalPosition;
            ++this.digitsLength;
        }
        if (this.decimalPosition < this.digitsLength || this.decimalSeparatorAlwaysShown) {
            digits.insert(this.decimalPosition, decimalSeparator);
            ++this.digitsLength;
        }
    }

    private final void adjustFractionDigits(StringBuilder digits) {
        int requiredDigits = this.decimalPosition + this.minimumFractionDigits;
        if (this.digitsLength < requiredDigits) {
            while (this.digitsLength < requiredDigits) {
                digits.append('0');
                ++this.digitsLength;
            }
        } else {
            int toRemove = this.decimalPosition + this.maximumFractionDigits;
            if (toRemove > this.digitsLength) {
                toRemove = this.digitsLength;
            }
            while (toRemove > requiredDigits && digits.charAt(toRemove - 1) == '0') {
                --toRemove;
            }
            if (toRemove < this.digitsLength) {
                Intrinsics.checkNotNullExpressionValue((Object)digits.delete(toRemove, toRemove + this.digitsLength), (String)"delete(...)");
                this.digitsLength = toRemove;
            }
        }
    }

    private final void roundValue(StringBuilder digits) {
        if (this.digitsLength > this.decimalPosition + this.maximumFractionDigits && Intrinsics.compare((int)digits.charAt(this.decimalPosition + this.maximumFractionDigits), (int)53) >= 0) {
            int i = this.decimalPosition + this.maximumFractionDigits - 1;
            this.propagateCarry(digits, i);
        }
    }

    private final String toPrecision(double d, int digits) {
        return String.valueOf(d);
    }
}

