/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.format;

import com.macrofocus.common.date.CPTimeZone;
import com.macrofocus.common.format.AbstractFormat;
import com.macrofocus.common.format.CPFormat;
import com.macrofocus.common.format.FormatFactoryCommon;
import com.macrofocus.common.locale.CPLocale;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 $2\u00020\u0001:\u0004!\"#$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005J<\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J,\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005J\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005J\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005J\u0016\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u000fJ\u0018\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u000fJ \u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u001d\u001a\u00020\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u001eJ*\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u001d\u001a\u00020\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 \u00a8\u0006%"}, d2={"Lcom/macrofocus/common/format/FormatFactory;", "Lcom/macrofocus/common/format/FormatFactoryCommon;", "<init>", "()V", "createCurrencyFormat", "Lcom/macrofocus/common/format/CPFormat;", "", "fractionDigits", "", "currency", "Ljava/util/Currency;", "locale", "Ljava/util/Locale;", "createDecimalFormat", "pre", "", "post", "rounding", "", "factor", "createIntegerFormat", "createPercentDecimalFormat", "createDateFormat", "createDateTimeFormat", "createDateOrDateTimeFormat", "createFormat", "format", "Ljava/text/Format;", "createNumberFormat", "pattern", "Lcom/macrofocus/common/locale/CPLocale;", "zone", "Lcom/macrofocus/common/date/CPTimeZone;", "SwingFormat", "SwingNumberFormat", "SwingDateFormat", "Companion", "macrofocus-common"})
public class FormatFactory
implements FormatFactoryCommon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final FormatFactory instance = new FormatFactory();

    @Nullable
    public final CPFormat<Object> createCurrencyFormat(int fractionDigits, @Nullable Currency currency, @Nullable Locale locale) {
        NumberFormat instance = null;
        NumberFormat numberFormat = currency != null ? DecimalFormat.getCurrencyInstance(locale) : DecimalFormat.getNumberInstance(locale);
        Intrinsics.checkNotNull((Object)numberFormat);
        instance = numberFormat;
        instance.setMaximumFractionDigits(fractionDigits);
        if (currency != null) {
            instance.setCurrency(currency);
        }
        return new SwingFormat(instance, null, null, 1.0, 1.0);
    }

    @NotNull
    public final CPFormat<Object> createDecimalFormat() {
        NumberFormat numberFormat = DecimalFormat.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)numberFormat, (String)"getInstance(...)");
        return new SwingFormat(numberFormat, null, null, 1.0, 1.0);
    }

    @Override
    @NotNull
    public CPFormat<Object> createDecimalFormat(int fractionDigits, @Nullable String pre, @Nullable String post, double rounding, double factor) {
        NumberFormat instance = DecimalFormat.getInstance();
        instance.setMaximumFractionDigits(fractionDigits);
        Intrinsics.checkNotNull((Object)instance);
        return new SwingFormat(instance, pre, post, rounding, factor);
    }

    @Override
    @NotNull
    public CPFormat<Object> createIntegerFormat(@Nullable String pre, @Nullable String post, double rounding) {
        NumberFormat numberFormat = DecimalFormat.getIntegerInstance();
        Intrinsics.checkNotNullExpressionValue((Object)numberFormat, (String)"getIntegerInstance(...)");
        return new SwingFormat(numberFormat, pre, post, rounding, 1.0);
    }

    @Override
    @NotNull
    public CPFormat<Object> createPercentDecimalFormat(int fractionDigits, double rounding) {
        NumberFormat instance = DecimalFormat.getPercentInstance();
        instance.setMaximumFractionDigits(fractionDigits);
        Intrinsics.checkNotNull((Object)instance);
        return new SwingFormat(instance, null, null, rounding, 1.0);
    }

    @NotNull
    public final CPFormat<Object> createDateFormat() {
        return new SwingDateFormat("dd.MM.yyyy");
    }

    @NotNull
    public final CPFormat<Object> createDateTimeFormat() {
        return new SwingDateFormat("dd.MM.yyyy HH:mm:ss");
    }

    @NotNull
    public final CPFormat<Object> createDateOrDateTimeFormat() {
        return new CPFormat<Object>(){
            private DateFormat dateFormat;
            private DateFormat fullDateFormat;
            {
                this.dateFormat = new SimpleDateFormat("dd.MM.yyyy");
                this.fullDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            }

            public final DateFormat getDateFormat() {
                return this.dateFormat;
            }

            public final void setDateFormat(DateFormat dateFormat) {
                Intrinsics.checkNotNullParameter((Object)dateFormat, (String)"<set-?>");
                this.dateFormat = dateFormat;
            }

            public final DateFormat getFullDateFormat() {
                return this.fullDateFormat;
            }

            public final void setFullDateFormat(DateFormat dateFormat) {
                Intrinsics.checkNotNullParameter((Object)dateFormat, (String)"<set-?>");
                this.fullDateFormat = dateFormat;
            }

            public String format(Object value) {
                return this.formatHtml(value, false);
            }

            public String formatHtml(Object value, boolean htmlSupported) {
                String string;
                if (value != null) {
                    Date date;
                    Date date2 = null;
                    if (value instanceof Number) {
                        date = new Date(((Number)value).longValue());
                    } else if (value instanceof Date) {
                        date = (Date)value;
                    } else {
                        return value.toString();
                    }
                    date2 = date;
                    string = date2.getHours() != 0 || date2.getMinutes() != 0 || date2.getSeconds() != 0 ? this.fullDateFormat.format(date2) : this.dateFormat.format(date2);
                } else {
                    string = "";
                }
                return string;
            }

            public Object parse(String text) throws CPFormat.ParsingException {
                Date date;
                try {
                    date = this.fullDateFormat.parse(text);
                }
                catch (ParseException e) {
                    Date date2;
                    try {
                        date2 = this.dateFormat.parse(text);
                    }
                    catch (ParseException e1) {
                        throw new CPFormat.ParsingException(e.getMessage(), e.getErrorOffset());
                    }
                    date = date2;
                }
                return date;
            }

            public String getPattern() {
                return null;
            }

            public Object getNativeFormat() {
                return null;
            }

            public CPFormat.HorizontalAlignment getHorizontalAlignment() {
                return null;
            }

            public String getClassName(Object value) {
                return null;
            }
        };
    }

    @NotNull
    public final CPFormat<Object> createFormat(@NotNull Format format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return new SwingFormat(format, null, null, 1.0, 1.0);
    }

    @NotNull
    public final CPFormat<Object> createNumberFormat(@Nullable String pattern) {
        return new SwingNumberFormat(pattern);
    }

    @NotNull
    public final CPFormat<Object> createDateFormat(@Nullable String pattern) {
        return new SwingDateFormat(pattern);
    }

    @NotNull
    public final CPFormat<Object> createDateFormat(@NotNull String pattern, @Nullable CPLocale locale) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return new SwingDateFormat(pattern, locale);
    }

    @NotNull
    public final CPFormat<Object> createDateFormat(@NotNull String pattern, @Nullable CPLocale locale, @Nullable CPTimeZone zone) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return new SwingDateFormat(pattern, locale, zone);
    }

    @Override
    @NotNull
    public CPFormat<Object> createOrdinalFormat() {
        return FormatFactoryCommon.super.createOrdinalFormat();
    }

    @Override
    @NotNull
    public CPFormat<Object> createMilionFormat(@NotNull CPFormat<Object> decimalFormat) {
        return FormatFactoryCommon.super.createMilionFormat(decimalFormat);
    }

    @Override
    @Nullable
    public CPFormat<Object> createDecimalFormat(int fractionDigits) {
        return FormatFactoryCommon.super.createDecimalFormat(fractionDigits);
    }

    @Override
    @NotNull
    public CPFormat<Object> createIntegerFormat() {
        return FormatFactoryCommon.super.createIntegerFormat();
    }

    @Override
    @NotNull
    public CPFormat<Object> createPercentDecimalFormat(int fractionDigits) {
        return FormatFactoryCommon.super.createPercentDecimalFormat(fractionDigits);
    }

    @Override
    @NotNull
    public CPFormat<Object> createStarFormat() {
        return FormatFactoryCommon.super.createStarFormat();
    }

    @Override
    @NotNull
    public CPFormat<Object> createStarFormat(@Nullable String na) {
        return FormatFactoryCommon.super.createStarFormat(na);
    }

    @Override
    @Nullable
    public CPFormat<Object> createBooleanFormat() {
        return FormatFactoryCommon.super.createBooleanFormat();
    }

    @Override
    @Nullable
    public CPFormat<Object> createFormat(@Nullable String pre, @Nullable String post) {
        return FormatFactoryCommon.super.createFormat(pre, post);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/macrofocus/common/format/FormatFactory$Companion;", "", "<init>", "()V", "instance", "Lcom/macrofocus/common/format/FormatFactory;", "getInstance", "()Lcom/macrofocus/common/format/FormatFactory;", "macrofocus-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FormatFactory getInstance() {
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0013\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001b\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0005\u0010\tB'\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0005\u0010\fJ\u0012\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0015\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\u00022\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0016J\u0014\u0010!\u001a\u0004\u0018\u00010\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u001a\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lcom/macrofocus/common/format/FormatFactory$SwingDateFormat;", "Lcom/macrofocus/common/format/CPFormat;", "", "pattern", "", "<init>", "(Ljava/lang/String;)V", "locale", "Lcom/macrofocus/common/locale/CPLocale;", "(Ljava/lang/String;Lcom/macrofocus/common/locale/CPLocale;)V", "timeZone", "Lcom/macrofocus/common/date/CPTimeZone;", "(Ljava/lang/String;Lcom/macrofocus/common/locale/CPLocale;Lcom/macrofocus/common/date/CPTimeZone;)V", "dateFormat", "Ljava/text/DateFormat;", "getDateFormat", "()Ljava/text/DateFormat;", "getPattern", "()Ljava/lang/String;", "format", "value", "formatHtml", "htmlSupported", "", "parse", "text", "nativeFormat", "getNativeFormat", "()Ljava/lang/Object;", "horizontalAlignment", "Lcom/macrofocus/common/format/CPFormat$HorizontalAlignment;", "getHorizontalAlignment", "()Lcom/macrofocus/common/format/CPFormat$HorizontalAlignment;", "getClassName", "macrofocus-common"})
    private static final class SwingDateFormat
    implements CPFormat<Object> {
        @NotNull
        private final DateFormat dateFormat;
        @Nullable
        private final String pattern;

        @NotNull
        public final DateFormat getDateFormat() {
            return this.dateFormat;
        }

        @Override
        @Nullable
        public String getPattern() {
            return this.pattern;
        }

        public SwingDateFormat(@Nullable String pattern) {
            this.dateFormat = new SimpleDateFormat(pattern);
            this.pattern = pattern;
        }

        public SwingDateFormat(@NotNull String pattern, @Nullable CPLocale locale) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            CPLocale cPLocale = locale;
            this.dateFormat = new SimpleDateFormat(pattern, cPLocale != null ? cPLocale.getLocale() : null);
            this.pattern = pattern;
        }

        public SwingDateFormat(@Nullable String pattern, @Nullable CPLocale locale, @Nullable CPTimeZone timeZone) {
            CPLocale cPLocale = locale;
            this.dateFormat = new SimpleDateFormat(pattern, cPLocale != null ? cPLocale.getLocale() : null);
            CPTimeZone cPTimeZone = timeZone;
            ((SimpleDateFormat)this.dateFormat).setTimeZone(cPTimeZone != null ? cPTimeZone.getTimeZone() : null);
            this.pattern = pattern;
        }

        @Override
        @NotNull
        public String format(@Nullable Object value) {
            return this.formatHtml(value, false);
        }

        @Override
        @NotNull
        public String formatHtml(@Nullable Object value, boolean htmlSupported) {
            String string;
            if (value != null) {
                Date date;
                Date date2 = null;
                if (value instanceof Number) {
                    date = new Date(((Number)value).longValue());
                } else if (value instanceof Date) {
                    date = (Date)value;
                } else {
                    return value.toString();
                }
                date2 = date;
                String string2 = this.dateFormat.format(date2);
                Intrinsics.checkNotNull((Object)string2);
                string = string2;
            } else {
                string = "";
            }
            return string;
        }

        @Override
        @NotNull
        public Object parse(@Nullable String text) throws CPFormat.ParsingException {
            Date date;
            try {
                date = this.dateFormat.parse(text);
            }
            catch (ParseException e) {
                throw new CPFormat.ParsingException(e.getMessage(), e.getErrorOffset());
            }
            Date date2 = date;
            Intrinsics.checkNotNull((Object)date2);
            return date2;
        }

        @Override
        @NotNull
        public Object getNativeFormat() {
            return this.dateFormat;
        }

        @Override
        @Nullable
        public CPFormat.HorizontalAlignment getHorizontalAlignment() {
            return null;
        }

        @Override
        @Nullable
        public String getClassName(@Nullable Object value) {
            return null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00022\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/macrofocus/common/format/FormatFactory$SwingFormat;", "Lcom/macrofocus/common/format/AbstractFormat;", "", "nativeFormat", "Ljava/text/Format;", "pre", "", "post", "rounding", "", "factor", "<init>", "(Ljava/text/Format;Ljava/lang/String;Ljava/lang/String;DD)V", "getNativeFormat", "()Ljava/text/Format;", "formatHtml", "value", "htmlSupported", "", "parse", "text", "macrofocus-common"})
    private static final class SwingFormat
    extends AbstractFormat<Object> {
        @NotNull
        private final Format nativeFormat;
        @Nullable
        private final String pre;
        @Nullable
        private final String post;
        private final double rounding;
        private final double factor;

        public SwingFormat(@NotNull Format nativeFormat, @Nullable String pre, @Nullable String post, double rounding, double factor) {
            Intrinsics.checkNotNullParameter((Object)nativeFormat, (String)"nativeFormat");
            this.nativeFormat = nativeFormat;
            this.pre = pre;
            this.post = post;
            this.rounding = rounding;
            this.factor = factor;
        }

        @Override
        @NotNull
        public Format getNativeFormat() {
            return this.nativeFormat;
        }

        @Override
        @Nullable
        public String formatHtml(@Nullable Object value, boolean htmlSupported) {
            Object s = null;
            if (value instanceof Number) {
                Number n = (Number)value;
                if (!(this.rounding == 1.0)) {
                    n = (double)Math.round(n.doubleValue() / this.rounding) * this.rounding;
                }
                if (!(this.factor == 1.0)) {
                    n = n.doubleValue() * this.factor;
                }
                s = this.getNativeFormat().format(n);
                if (this.pre != null) {
                    s = this.pre + (String)s;
                }
                if (this.post != null) {
                    s = (String)s + this.post;
                }
            } else {
                s = null;
            }
            return s;
        }

        @Override
        @Nullable
        public Object parse(@Nullable String text) throws CPFormat.ParsingException {
            Object object;
            Object text2 = text;
            if (text2 != null) {
                Object object2;
                if (this.pre != null && !StringsKt.startsWith$default((String)text2, (String)this.pre, (boolean)false, (int)2, null)) {
                    text2 = this.pre + (String)text2;
                }
                if (this.post != null && !StringsKt.endsWith$default((String)text2, (String)this.post, (boolean)false, (int)2, null)) {
                    text2 = (String)text2 + this.post;
                }
                try {
                    object2 = this.getNativeFormat().parseObject((String)text2);
                }
                catch (ParseException e) {
                    throw new CPFormat.ParsingException(e.getMessage(), e.getErrorOffset());
                }
                object = object2;
            } else {
                object = null;
            }
            return object;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u000f\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u00022\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0016J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0014\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lcom/macrofocus/common/format/FormatFactory$SwingNumberFormat;", "Lcom/macrofocus/common/format/CPFormat;", "", "pattern", "", "<init>", "(Ljava/lang/String;)V", "numberFormat", "Ljava/text/DecimalFormat;", "getNumberFormat", "()Ljava/text/DecimalFormat;", "getPattern", "()Ljava/lang/String;", "format", "value", "formatHtml", "htmlSupported", "", "parse", "text", "nativeFormat", "getNativeFormat", "()Ljava/lang/Object;", "horizontalAlignment", "Lcom/macrofocus/common/format/CPFormat$HorizontalAlignment;", "getHorizontalAlignment", "()Lcom/macrofocus/common/format/CPFormat$HorizontalAlignment;", "getClassName", "macrofocus-common"})
    private static final class SwingNumberFormat
    implements CPFormat<Object> {
        @NotNull
        private final DecimalFormat numberFormat;
        @Nullable
        private final String pattern;

        public SwingNumberFormat(@Nullable String pattern) {
            this.numberFormat = new DecimalFormat(pattern);
            this.pattern = pattern;
        }

        @NotNull
        public final DecimalFormat getNumberFormat() {
            return this.numberFormat;
        }

        @Override
        @Nullable
        public String getPattern() {
            return this.pattern;
        }

        @Override
        @NotNull
        public String format(@Nullable Object value) {
            return this.formatHtml(value, false);
        }

        @Override
        @NotNull
        public String formatHtml(@Nullable Object value, boolean htmlSupported) {
            String string;
            if (value != null) {
                Number number = null;
                if (!(value instanceof Number)) {
                    return value.toString();
                }
                number = (Number)value;
                String string2 = this.numberFormat.format(number);
                Intrinsics.checkNotNull((Object)string2);
                string = string2;
            } else {
                string = "";
            }
            return string;
        }

        @Override
        @NotNull
        public Object parse(@Nullable String text) throws CPFormat.ParsingException {
            Number number;
            try {
                number = this.numberFormat.parse(text);
            }
            catch (ParseException e) {
                throw new CPFormat.ParsingException(e.getMessage(), e.getErrorOffset());
            }
            Number number2 = number;
            Intrinsics.checkNotNull((Object)number2);
            return number2;
        }

        @Override
        @NotNull
        public Object getNativeFormat() {
            return this.numberFormat;
        }

        @Override
        @Nullable
        public CPFormat.HorizontalAlignment getHorizontalAlignment() {
            return null;
        }

        @Override
        @Nullable
        public String getClassName(@Nullable Object value) {
            return null;
        }
    }
}

