/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.json;

import com.macrofocus.common.json.JsonArray;
import com.macrofocus.common.json.JsonArrayContext;
import com.macrofocus.common.json.JsonBoolean;
import com.macrofocus.common.json.JsonContext;
import com.macrofocus.common.json.JsonFactory;
import com.macrofocus.common.json.JsonNumber;
import com.macrofocus.common.json.JsonObject;
import com.macrofocus.common.json.JsonString;
import com.macrofocus.common.json.JsonType;
import com.macrofocus.common.json.JsonUtil;
import com.macrofocus.common.json.JsonValue;
import com.macrofocus.common.json.JsonVisitor;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 72\u00020\u0001:\u00017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\"\u0010\u0013\u001a\u0002H\u0014\"\n\b\u0000\u0010\u0014*\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0096\u0002\u00a2\u0006\u0002\u0010\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010$\u001a\u00020\u000b2\b\u0010%\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010&\u001a\u00020\u0016H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001b\u0010)\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010%\u001a\u0004\u0018\u00010\bH\u0096\u0002J\u0019\u0010)\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u000fH\u0096\u0002J\u0019\u0010)\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\rH\u0096\u0002J\u0019\u0010)\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u000bH\u0096\u0002J\n\u0010-\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010.\u001a\u00020\u000fH\u0016J\u0018\u0010/\u001a\u00020(2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020(2\u0006\u00105\u001a\u000206H\u0002R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001eR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u00068"}, d2={"Lcom/macrofocus/common/json/JvmJsonArray;", "Lcom/macrofocus/common/json/JsonArray;", "factory", "Lcom/macrofocus/common/json/JsonFactory;", "<init>", "(Lcom/macrofocus/common/json/JsonFactory;)V", "arrayValues", "Ljava/util/ArrayList;", "Lcom/macrofocus/common/json/JsonValue;", "Lkotlin/collections/ArrayList;", "asBoolean", "", "asNumber", "", "asString", "", "asJsonArray", "asJsonObject", "Lcom/macrofocus/common/json/JsonObject;", "get", "T", "index", "", "(I)Lcom/macrofocus/common/json/JsonValue;", "getArray", "getBoolean", "getNumber", "getObject", "object", "", "()Ljava/lang/Object;", "getString", "type", "Lcom/macrofocus/common/json/JsonType;", "getType", "()Lcom/macrofocus/common/json/JsonType;", "jsEquals", "value", "length", "remove", "", "set", "string", "number", "bool", "toNative", "toJson", "traverse", "visitor", "Lcom/macrofocus/common/json/JsonVisitor;", "ctx", "Lcom/macrofocus/common/json/JsonContext;", "writeObject", "stream", "Ljava/io/ObjectOutputStream;", "Companion", "macrofocus-common"})
public final class JvmJsonArray
implements JsonArray {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ArrayList<JsonValue> arrayValues;
    @NotNull
    private JsonFactory factory;
    private static final long serialVersionUID = 1L;

    public JvmJsonArray(@NotNull JsonFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this.arrayValues = new ArrayList();
        this.factory = factory;
    }

    @Override
    public boolean asBoolean() {
        return true;
    }

    @Override
    public double asNumber() {
        return switch (this.length()) {
            case 0 -> 0.0;
            case 1 -> {
                Object v1 = this.get(0);
                Intrinsics.checkNotNull(v1, (String)"null cannot be cast to non-null type com.macrofocus.common.json.JsonValue");
                yield v1.asNumber();
            }
            default -> Double.NaN;
        };
    }

    @Override
    @NotNull
    public String asString() {
        StringBuilder toReturn = new StringBuilder();
        int n = this.length();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                toReturn.append(", ");
            }
            Object t = this.get(i);
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type com.macrofocus.common.json.JsonValue");
            toReturn.append(t.asString());
        }
        String string = toReturn.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @Nullable
    public JsonArray asJsonArray() {
        return this;
    }

    @Override
    @Nullable
    public JsonObject asJsonObject() {
        return null;
    }

    @Override
    public <T extends JsonValue> T get(int index) {
        return (T)this.arrayValues.get(index);
    }

    @Override
    @Nullable
    public JsonArray getArray(int index) {
        return (JsonArray)this.get(index);
    }

    @Override
    public boolean getBoolean(int index) {
        Object t = this.get(index);
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type com.macrofocus.common.json.JsonBoolean");
        return ((JsonBoolean)t).getBoolean();
    }

    @Override
    public double getNumber(int index) {
        Object t = this.get(index);
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type com.macrofocus.common.json.JsonNumber");
        return ((JsonNumber)t).getNumber();
    }

    @Override
    @Nullable
    public JsonObject getObject(int index) {
        return (JsonObject)this.get(index);
    }

    @Override
    @NotNull
    public Object getObject() {
        List objs = new ArrayList();
        Iterator<JsonValue> iterator2 = this.arrayValues.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<JsonValue> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            JsonValue val;
            Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
            objs.add(val.getObject());
        }
        return objs;
    }

    @Override
    @Nullable
    public String getString(int index) {
        Object t = this.get(index);
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type com.macrofocus.common.json.JsonString");
        return ((JsonString)t).getString();
    }

    @Override
    @NotNull
    public JsonType getType() {
        return JsonType.ARRAY;
    }

    @Override
    public boolean jsEquals(@Nullable JsonValue value) {
        Object object = this.getObject();
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.macrofocus.common.json.JsonValue");
        return Intrinsics.areEqual((Object)object, (Object)value.getObject());
    }

    @Override
    public int length() {
        return this.arrayValues.size();
    }

    @Override
    public void remove(int index) {
        this.arrayValues.remove(index);
    }

    @Override
    public void set(int index, @Nullable JsonValue value) {
        JsonValue value2 = value;
        if (value2 == null) {
            value2 = this.factory.createNull();
        }
        if (index == this.arrayValues.size()) {
            this.arrayValues.add(index, value2);
        } else {
            JsonValue jsonValue = this.arrayValues.set(index, value2);
            Intrinsics.checkNotNull((Object)jsonValue);
        }
    }

    @Override
    public void set(int index, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this.set(index, this.factory.create(string));
    }

    @Override
    public void set(int index, double number) {
        this.set(index, this.factory.create(number));
    }

    @Override
    public void set(int index, boolean bool) {
        this.set(index, this.factory.create(bool));
    }

    @Override
    @Nullable
    public Object toNative() {
        return this;
    }

    @Override
    @NotNull
    public String toJson() {
        return JsonUtil.INSTANCE.stringify(this);
    }

    @Override
    public void traverse(@NotNull JsonVisitor visitor, @NotNull JsonContext ctx) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (visitor.visit(this, ctx)) {
            JsonArrayContext arrayCtx = new JsonArrayContext(this);
            int n = this.length();
            for (int i = 0; i < n; ++i) {
                arrayCtx.setCurrentIndex(i);
                if (!visitor.visitIndex(arrayCtx.getCurrentIndex(), arrayCtx)) continue;
                visitor.accept((JsonValue)this.get(i), arrayCtx);
                arrayCtx.setFirst(false);
            }
        }
        visitor.endVisit(this, ctx);
    }

    private final void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.toJson());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/macrofocus/common/json/JvmJsonArray$Companion;", "", "<init>", "()V", "serialVersionUID", "", "macrofocus-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

