/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.json;

import com.macrofocus.common.json.JsonArray;
import com.macrofocus.common.json.JsonContext;
import com.macrofocus.common.json.JsonNumber;
import com.macrofocus.common.json.JsonObject;
import com.macrofocus.common.json.JsonType;
import com.macrofocus.common.json.JsonValue;
import com.macrofocus.common.json.JsonVisitor;
import com.macrofocus.common.math.MathKt;
import java.io.IOException;
import java.io.ObjectOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0012\u0010\u0019\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\fH\u0016J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006("}, d2={"Lcom/macrofocus/common/json/JvmJsonNumber;", "Lcom/macrofocus/common/json/JsonNumber;", "number", "", "<init>", "(D)V", "getNumber", "()D", "asBoolean", "", "asNumber", "asString", "", "asJsonArray", "Lcom/macrofocus/common/json/JsonArray;", "asJsonObject", "Lcom/macrofocus/common/json/JsonObject;", "object", "", "getObject", "()Ljava/lang/Object;", "type", "Lcom/macrofocus/common/json/JsonType;", "getType", "()Lcom/macrofocus/common/json/JsonType;", "jsEquals", "value", "Lcom/macrofocus/common/json/JsonValue;", "toNative", "traverse", "", "visitor", "Lcom/macrofocus/common/json/JsonVisitor;", "ctx", "Lcom/macrofocus/common/json/JsonContext;", "toJson", "writeObject", "stream", "Ljava/io/ObjectOutputStream;", "Companion", "macrofocus-common"})
public final class JvmJsonNumber
implements JsonNumber {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double number;
    private static final long serialVersionUID = 1L;

    public JvmJsonNumber(double number) {
        this.number = number;
    }

    @Override
    public double getNumber() {
        return this.number;
    }

    @Override
    public boolean asBoolean() {
        return !MathKt.isNaN(this.getNumber()) && !(Math.abs(this.getNumber()) == 0.0);
    }

    @Override
    public double asNumber() {
        return this.getNumber();
    }

    @Override
    @NotNull
    public String asString() {
        return this.toJson();
    }

    @Override
    @Nullable
    public JsonArray asJsonArray() {
        return null;
    }

    @Override
    @Nullable
    public JsonObject asJsonObject() {
        return null;
    }

    @Override
    @NotNull
    public Object getObject() {
        return this.getNumber();
    }

    @Override
    @NotNull
    public JsonType getType() {
        return JsonType.NUMBER;
    }

    @Override
    public boolean jsEquals(@Nullable JsonValue value) {
        Object object = this.getObject();
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.macrofocus.common.json.JsonValue");
        return Intrinsics.areEqual((Object)object, (Object)value.getObject());
    }

    @Override
    @Nullable
    public Object toNative() {
        return this;
    }

    @Override
    public void traverse(@NotNull JsonVisitor visitor, @NotNull JsonContext ctx) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        visitor.visit(this.getNumber(), ctx);
    }

    @Override
    @NotNull
    public String toJson() {
        if (MathKt.isInfinite(this.getNumber()) || MathKt.isNaN(this.getNumber())) {
            return "null";
        }
        String toReturn = String.valueOf(this.getNumber());
        if (StringsKt.endsWith$default((String)toReturn, (String)".0", (boolean)false, (int)2, null)) {
            String string = toReturn.substring(0, toReturn.length() - 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            toReturn = string;
        }
        return toReturn;
    }

    private final void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.toJson());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/macrofocus/common/json/JvmJsonNumber$Companion;", "", "<init>", "()V", "serialVersionUID", "", "macrofocus-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

