/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.math;

import com.macrofocus.common.math.Float2;
import com.macrofocus.common.math.MatrixColumn;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 +2\u00020\u0001:\u0001+B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\bJ\u0011\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0002J\u0019\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0086\u0002J\u0011\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0014H\u0086\u0002J\u0019\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0011H\u0086\u0002J\u0019\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0002J!\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0012H\u0086\u0002J\u0019\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0003H\u0086\u0002J!\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0012H\u0086\u0002J\t\u0010\u0019\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u001a\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u001b\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0012H\u0086\u0002J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0012H\u0086\u0002J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0012H\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0012H\u0086\u0002J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0086\u0002J\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020#H\u0016J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020\u0011H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\f\u00a8\u0006,"}, d2={"Lcom/macrofocus/common/math/Mat2;", "", "x", "Lcom/macrofocus/common/math/Float2;", "y", "<init>", "(Lcom/macrofocus/common/math/Float2;Lcom/macrofocus/common/math/Float2;)V", "m", "(Lcom/macrofocus/common/math/Mat2;)V", "getX", "()Lcom/macrofocus/common/math/Float2;", "setX", "(Lcom/macrofocus/common/math/Float2;)V", "getY", "setY", "get", "column", "", "", "row", "Lcom/macrofocus/common/math/MatrixColumn;", "invoke", "", "v", "set", "unaryMinus", "inc", "dec", "plus", "minus", "times", "div", "toFloatArray", "", "toString", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "Companion", "macrofocus-common"})
@SourceDebugExtension(value={"SMAP\nMatrix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matrix.kt\ncom/macrofocus/common/math/Mat2\n+ 2 Vector.kt\ncom/macrofocus/common/math/Float2\n*L\n1#1,559:1\n61#2,3:560\n132#2:563\n133#2:564\n134#2:565\n135#2:566\n*S KotlinDebug\n*F\n+ 1 Matrix.kt\ncom/macrofocus/common/math/Mat2\n*L\n62#1:560,3\n80#1:563\n81#1:564\n82#1:565\n83#1:566\n*E\n"})
public final class Mat2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Float2 x;
    @NotNull
    private Float2 y;

    public Mat2(@NotNull Float2 x, @NotNull Float2 y) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        this.x = x;
        this.y = y;
    }

    public /* synthetic */ Mat2(Float2 float2, Float2 float22, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            float2 = new Float2(1.0f, 0.0f, 2, null);
        }
        if ((n & 2) != 0) {
            float22 = new Float2(0.0f, 1.0f, 1, null);
        }
        this(float2, float22);
    }

    @NotNull
    public final Float2 getX() {
        return this.x;
    }

    public final void setX(@NotNull Float2 float2) {
        Intrinsics.checkNotNullParameter((Object)float2, (String)"<set-?>");
        this.x = float2;
    }

    @NotNull
    public final Float2 getY() {
        return this.y;
    }

    public final void setY(@NotNull Float2 float2) {
        Intrinsics.checkNotNullParameter((Object)float2, (String)"<set-?>");
        this.y = float2;
    }

    public Mat2(@NotNull Mat2 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this(Float2.copy$default(m.x, 0.0f, 0.0f, 3, null), Float2.copy$default(m.y, 0.0f, 0.0f, 3, null));
    }

    @NotNull
    public final Float2 get(int column) {
        return switch (column) {
            case 0 -> this.x;
            case 1 -> this.y;
            default -> throw new IllegalArgumentException("column must be in 0..1");
        };
    }

    public final float get(int column, int row) {
        return this.get(column).get(row);
    }

    @NotNull
    public final Float2 get(@NotNull MatrixColumn column) {
        Intrinsics.checkNotNullParameter((Object)((Object)column), (String)"column");
        return switch (WhenMappings.$EnumSwitchMapping$0[column.ordinal()]) {
            case 1 -> this.x;
            case 2 -> this.y;
            default -> throw new IllegalArgumentException("column must be X or Y");
        };
    }

    public final float get(@NotNull MatrixColumn column, int row) {
        Intrinsics.checkNotNullParameter((Object)((Object)column), (String)"column");
        return this.get(column).get(row);
    }

    public final float invoke(int row, int column) {
        return this.get(column - 1).get(row - 1);
    }

    public final void invoke(int row, int column, float v) {
        this.set(column - 1, row - 1, v);
    }

    /*
     * WARNING - void declaration
     */
    public final void set(int column, @NotNull Float2 v) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Float2 float2 = this.get(column);
        Float2 value$iv = v;
        boolean $i$f$setXy = false;
        this_$iv.setX(value$iv.getX());
        this_$iv.setY(value$iv.getY());
    }

    public final void set(int column, int row, float v) {
        this.get(column).set(row, v);
    }

    @NotNull
    public final Mat2 unaryMinus() {
        return new Mat2(this.x.unaryMinus(), this.y.unaryMinus());
    }

    @NotNull
    public final Mat2 inc() {
        Float2 float2 = this.x;
        this.x = float2.inc();
        float2 = this.y;
        this.y = float2.inc();
        return this;
    }

    @NotNull
    public final Mat2 dec() {
        Float2 float2 = this.x;
        this.x = float2.dec();
        float2 = this.y;
        this.y = float2.dec();
        return this;
    }

    @NotNull
    public final Mat2 plus(float v) {
        Float2 this_$iv;
        Float2 float2 = this.x;
        float v$iv = v;
        boolean $i$f$plus = false;
        Float2 float22 = new Float2(this_$iv.getX() + v$iv, this_$iv.getY() + v$iv);
        this_$iv = this.y;
        v$iv = v;
        $i$f$plus = false;
        return new Mat2(float22, new Float2(this_$iv.getX() + v$iv, this_$iv.getY() + v$iv));
    }

    @NotNull
    public final Mat2 minus(float v) {
        Float2 this_$iv;
        Float2 float2 = this.x;
        float v$iv = v;
        boolean $i$f$minus = false;
        Float2 float22 = new Float2(this_$iv.getX() - v$iv, this_$iv.getY() - v$iv);
        this_$iv = this.y;
        v$iv = v;
        $i$f$minus = false;
        return new Mat2(float22, new Float2(this_$iv.getX() - v$iv, this_$iv.getY() - v$iv));
    }

    @NotNull
    public final Mat2 times(float v) {
        Float2 this_$iv;
        Float2 float2 = this.x;
        float v$iv = v;
        boolean $i$f$times = false;
        Float2 float22 = new Float2(this_$iv.getX() * v$iv, this_$iv.getY() * v$iv);
        this_$iv = this.y;
        v$iv = v;
        $i$f$times = false;
        return new Mat2(float22, new Float2(this_$iv.getX() * v$iv, this_$iv.getY() * v$iv));
    }

    @NotNull
    public final Mat2 div(float v) {
        Float2 this_$iv;
        Float2 float2 = this.x;
        float v$iv = v;
        boolean $i$f$div = false;
        Float2 float22 = new Float2(this_$iv.getX() / v$iv, this_$iv.getY() / v$iv);
        this_$iv = this.y;
        v$iv = v;
        $i$f$div = false;
        return new Mat2(float22, new Float2(this_$iv.getX() / v$iv, this_$iv.getY() / v$iv));
    }

    @NotNull
    public final Mat2 times(@NotNull Mat2 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        return new Mat2(new Float2(this.x.getX() * m.x.getX() + this.y.getX() * m.x.getY(), this.x.getY() * m.x.getX() + this.y.getY() * m.x.getY()), new Float2(this.x.getX() * m.y.getX() + this.y.getX() * m.y.getY(), this.x.getY() * m.y.getX() + this.y.getY() * m.y.getY()));
    }

    @NotNull
    public final Float2 times(@NotNull Float2 v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new Float2(this.x.getX() * v.getX() + this.y.getX() * v.getY(), this.x.getY() * v.getX() + this.y.getY() * v.getY());
    }

    @NotNull
    public final float[] toFloatArray() {
        float[] fArray = new float[]{this.x.getX(), this.y.getX(), this.x.getY(), this.y.getY()};
        return fArray;
    }

    @NotNull
    public String toString() {
        return StringsKt.trimIndent((String)("\n            |" + this.x.getX() + " " + this.y.getX() + "|\n            |" + this.x.getY() + " " + this.y.getY() + "|\n            "));
    }

    @NotNull
    public final Float2 component1() {
        return this.x;
    }

    @NotNull
    public final Float2 component2() {
        return this.y;
    }

    @NotNull
    public final Mat2 copy(@NotNull Float2 x, @NotNull Float2 y) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        return new Mat2(x, y);
    }

    public static /* synthetic */ Mat2 copy$default(Mat2 mat2, Float2 float2, Float2 float22, int n, Object object) {
        if ((n & 1) != 0) {
            float2 = mat2.x;
        }
        if ((n & 2) != 0) {
            float22 = mat2.y;
        }
        return mat2.copy(float2, float22);
    }

    public int hashCode() {
        int result = this.x.hashCode();
        result = result * 31 + this.y.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Mat2)) {
            return false;
        }
        Mat2 mat2 = (Mat2)other;
        if (!Intrinsics.areEqual((Object)this.x, (Object)mat2.x)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.y, (Object)mat2.y);
    }

    public Mat2() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00020\u0007\"\u00020\bJ\u0006\u0010\t\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"Lcom/macrofocus/common/math/Mat2$Companion;", "", "<init>", "()V", "of", "Lcom/macrofocus/common/math/Mat2;", "a", "", "", "identity", "macrofocus-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Mat2 of(float ... a) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            if (!(a.length >= 4)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return new Mat2(new Float2(a[0], a[2]), new Float2(a[1], a[3]));
        }

        @NotNull
        public final Mat2 identity() {
            return new Mat2(null, null, 3, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MatrixColumn.values().length];
            try {
                nArray[MatrixColumn.X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MatrixColumn.Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

