/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.math;

import com.macrofocus.common.math.Float2;
import com.macrofocus.common.math.Float3;
import com.macrofocus.common.math.Float4;
import com.macrofocus.common.math.Mat2;
import com.macrofocus.common.math.Mat3;
import com.macrofocus.common.math.Mat4;
import com.macrofocus.common.math.VectorKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0013\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0000\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0005\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0005\u001a\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\b\u001a\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0005\u001a\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0005\u001a\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\b\u001a\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0005\u001a \u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\b\b\u0002\u0010\u0014\u001a\u00020\b\u001a \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\b\b\u0002\u0010\u0014\u001a\u00020\b\u001a&\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f\u001a6\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000f\u00a8\u0006\""}, d2={"transpose", "Lcom/macrofocus/common/math/Mat2;", "m", "Lcom/macrofocus/common/math/Mat3;", "inverse", "Lcom/macrofocus/common/math/Mat4;", "scale", "s", "Lcom/macrofocus/common/math/Float3;", "translation", "t", "rotation", "d", "axis", "angle", "", "normal", "lookAt", "eye", "target", "up", "lookTowards", "forward", "perspective", "fov", "ratio", "near", "far", "ortho", "l", "r", "b", "n", "f", "macrofocus-common"})
@SourceDebugExtension(value={"SMAP\nMatrix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matrix.kt\ncom/macrofocus/common/math/MatrixKt\n+ 2 Matrix.kt\ncom/macrofocus/common/math/Mat4\n+ 3 Vector.kt\ncom/macrofocus/common/math/Float4\n+ 4 Vector.kt\ncom/macrofocus/common/math/VectorKt\n+ 5 Vector.kt\ncom/macrofocus/common/math/Float3\n+ 6 Scalar.kt\ncom/macrofocus/common/math/ScalarKt\n*L\n1#1,559:1\n264#2:560\n266#2:563\n243#2:565\n248#2,6:567\n243#2:590\n248#2,6:593\n410#3:561\n410#3:564\n410#3:566\n410#3:591\n683#4:562\n742#4:573\n742#4:579\n742#4:584\n684#4:592\n680#4:599\n691#4:601\n691#4:602\n324#5:574\n325#5,3:576\n324#5,4:580\n324#5,4:585\n319#5:600\n37#6:575\n37#6:589\n37#6:603\n*S KotlinDebug\n*F\n+ 1 Matrix.kt\ncom/macrofocus/common/math/MatrixKt\n*L\n495#1:560\n498#1:563\n500#1:565\n500#1:567,6\n531#1:590\n531#1:593,6\n495#1:561\n498#1:564\n500#1:566\n531#1:591\n495#1:562\n502#1:573\n503#1:579\n504#1:584\n531#1:592\n531#1:599\n539#1:601\n540#1:602\n502#1:574\n502#1:576,3\n503#1:580,4\n504#1:585,4\n534#1:600\n502#1:575\n518#1:589\n545#1:603\n*E\n"})
public final class MatrixKt {
    @NotNull
    public static final Mat2 transpose(@NotNull Mat2 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        return new Mat2(new Float2(m.getX().getX(), m.getY().getX()), new Float2(m.getX().getY(), m.getY().getY()));
    }

    @NotNull
    public static final Mat3 transpose(@NotNull Mat3 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        return new Mat3(new Float3(m.getX().getX(), m.getY().getX(), m.getZ().getX()), new Float3(m.getX().getY(), m.getY().getY(), m.getZ().getY()), new Float3(m.getX().getZ(), m.getY().getZ(), m.getZ().getZ()));
    }

    @NotNull
    public static final Mat3 inverse(@NotNull Mat3 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        float a = m.getX().getX();
        float b = m.getX().getY();
        float c = m.getX().getZ();
        float d = m.getY().getX();
        float e = m.getY().getY();
        float f = m.getY().getZ();
        float g = m.getZ().getX();
        float h = m.getZ().getY();
        float i = m.getZ().getZ();
        float A2 = e * i - f * h;
        float B = f * g - d * i;
        float C = d * h - e * g;
        float det = a * A2 + b * B + c * C;
        float[] fArray = new float[]{A2 / det, B / det, C / det, (c * h - b * i) / det, (a * i - c * g) / det, (b * g - a * h) / det, (b * f - c * e) / det, (c * d - a * f) / det, (a * e - b * d) / det};
        return Mat3.Companion.of(fArray);
    }

    @NotNull
    public static final Mat4 transpose(@NotNull Mat4 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        return new Mat4(new Float4(m.getX().getX(), m.getY().getX(), m.getZ().getX(), m.getW().getX()), new Float4(m.getX().getY(), m.getY().getY(), m.getZ().getY(), m.getW().getY()), new Float4(m.getX().getZ(), m.getY().getZ(), m.getZ().getZ(), m.getW().getZ()), new Float4(m.getX().getW(), m.getY().getW(), m.getZ().getW(), m.getW().getW()));
    }

    @NotNull
    public static final Mat4 inverse(@NotNull Mat4 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Mat4 result = new Mat4(null, null, null, null, 15, null);
        float pair0 = m.getZ().getZ() * m.getW().getW();
        float pair1 = m.getW().getZ() * m.getZ().getW();
        float pair2 = m.getY().getZ() * m.getW().getW();
        float pair3 = m.getW().getZ() * m.getY().getW();
        float pair4 = m.getY().getZ() * m.getZ().getW();
        float pair5 = m.getZ().getZ() * m.getY().getW();
        float pair6 = m.getX().getZ() * m.getW().getW();
        float pair7 = m.getW().getZ() * m.getX().getW();
        float pair8 = m.getX().getZ() * m.getZ().getW();
        float pair9 = m.getZ().getZ() * m.getX().getW();
        float pair10 = m.getX().getZ() * m.getY().getW();
        float pair11 = m.getY().getZ() * m.getX().getW();
        result.getX().setX(pair0 * m.getY().getY() + pair3 * m.getZ().getY() + pair4 * m.getW().getY());
        Float4 float4 = result.getX();
        float4.setX(float4.getX() - (pair1 * m.getY().getY() + pair2 * m.getZ().getY() + pair5 * m.getW().getY()));
        result.getX().setY(pair1 * m.getX().getY() + pair6 * m.getZ().getY() + pair9 * m.getW().getY());
        float4 = result.getX();
        float4.setY(float4.getY() - (pair0 * m.getX().getY() + pair7 * m.getZ().getY() + pair8 * m.getW().getY()));
        result.getX().setZ(pair2 * m.getX().getY() + pair7 * m.getY().getY() + pair10 * m.getW().getY());
        float4 = result.getX();
        float4.setZ(float4.getZ() - (pair3 * m.getX().getY() + pair6 * m.getY().getY() + pair11 * m.getW().getY()));
        result.getX().setW(pair5 * m.getX().getY() + pair8 * m.getY().getY() + pair11 * m.getZ().getY());
        float4 = result.getX();
        float4.setW(float4.getW() - (pair4 * m.getX().getY() + pair9 * m.getY().getY() + pair10 * m.getZ().getY()));
        result.getY().setX(pair1 * m.getY().getX() + pair2 * m.getZ().getX() + pair5 * m.getW().getX());
        float4 = result.getY();
        float4.setX(float4.getX() - (pair0 * m.getY().getX() + pair3 * m.getZ().getX() + pair4 * m.getW().getX()));
        result.getY().setY(pair0 * m.getX().getX() + pair7 * m.getZ().getX() + pair8 * m.getW().getX());
        float4 = result.getY();
        float4.setY(float4.getY() - (pair1 * m.getX().getX() + pair6 * m.getZ().getX() + pair9 * m.getW().getX()));
        result.getY().setZ(pair3 * m.getX().getX() + pair6 * m.getY().getX() + pair11 * m.getW().getX());
        float4 = result.getY();
        float4.setZ(float4.getZ() - (pair2 * m.getX().getX() + pair7 * m.getY().getX() + pair10 * m.getW().getX()));
        result.getY().setW(pair4 * m.getX().getX() + pair9 * m.getY().getX() + pair10 * m.getZ().getX());
        float4 = result.getY();
        float4.setW(float4.getW() - (pair5 * m.getX().getX() + pair8 * m.getY().getX() + pair11 * m.getZ().getX()));
        pair0 = m.getZ().getX() * m.getW().getY();
        pair1 = m.getW().getX() * m.getZ().getY();
        pair2 = m.getY().getX() * m.getW().getY();
        pair3 = m.getW().getX() * m.getY().getY();
        pair4 = m.getY().getX() * m.getZ().getY();
        pair5 = m.getZ().getX() * m.getY().getY();
        pair6 = m.getX().getX() * m.getW().getY();
        pair7 = m.getW().getX() * m.getX().getY();
        pair8 = m.getX().getX() * m.getZ().getY();
        pair9 = m.getZ().getX() * m.getX().getY();
        pair10 = m.getX().getX() * m.getY().getY();
        pair11 = m.getY().getX() * m.getX().getY();
        result.getZ().setX(pair0 * m.getY().getW() + pair3 * m.getZ().getW() + pair4 * m.getW().getW());
        float4 = result.getZ();
        float4.setX(float4.getX() - (pair1 * m.getY().getW() + pair2 * m.getZ().getW() + pair5 * m.getW().getW()));
        result.getZ().setY(pair1 * m.getX().getW() + pair6 * m.getZ().getW() + pair9 * m.getW().getW());
        float4 = result.getZ();
        float4.setY(float4.getY() - (pair0 * m.getX().getW() + pair7 * m.getZ().getW() + pair8 * m.getW().getW()));
        result.getZ().setZ(pair2 * m.getX().getW() + pair7 * m.getY().getW() + pair10 * m.getW().getW());
        float4 = result.getZ();
        float4.setZ(float4.getZ() - (pair3 * m.getX().getW() + pair6 * m.getY().getW() + pair11 * m.getW().getW()));
        result.getZ().setW(pair5 * m.getX().getW() + pair8 * m.getY().getW() + pair11 * m.getZ().getW());
        float4 = result.getZ();
        float4.setW(float4.getW() - (pair4 * m.getX().getW() + pair9 * m.getY().getW() + pair10 * m.getZ().getW()));
        result.getW().setX(pair2 * m.getZ().getZ() + pair5 * m.getW().getZ() + pair1 * m.getY().getZ());
        float4 = result.getW();
        float4.setX(float4.getX() - (pair4 * m.getW().getZ() + pair0 * m.getY().getZ() + pair3 * m.getZ().getZ()));
        result.getW().setY(pair8 * m.getW().getZ() + pair0 * m.getX().getZ() + pair7 * m.getZ().getZ());
        float4 = result.getW();
        float4.setY(float4.getY() - (pair6 * m.getZ().getZ() + pair9 * m.getW().getZ() + pair1 * m.getX().getZ()));
        result.getW().setZ(pair6 * m.getY().getZ() + pair11 * m.getW().getZ() + pair3 * m.getX().getZ());
        float4 = result.getW();
        float4.setZ(float4.getZ() - (pair10 * m.getW().getZ() + pair2 * m.getX().getZ() + pair7 * m.getY().getZ()));
        result.getW().setW(pair10 * m.getZ().getZ() + pair4 * m.getX().getZ() + pair9 * m.getY().getZ());
        float4 = result.getW();
        float4.setW(float4.getW() - (pair8 * m.getY().getZ() + pair11 * m.getZ().getZ() + pair5 * m.getX().getZ()));
        float determinant = m.getX().getX() * result.getX().getX() + m.getY().getX() * result.getX().getY() + m.getZ().getX() * result.getX().getZ() + m.getW().getX() * result.getX().getW();
        return result.div(determinant);
    }

    @NotNull
    public static final Mat4 scale(@NotNull Float3 s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return new Mat4(new Float4(s.getX(), 0.0f, 0.0f, 0.0f, 14, null), new Float4(0.0f, s.getY(), 0.0f, 0.0f, 13, null), new Float4(0.0f, 0.0f, s.getZ(), 0.0f, 11, null), null, 8, null);
    }

    @NotNull
    public static final Mat4 scale(@NotNull Mat4 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Mat4 this_$iv = m;
        boolean $i$f$getScale = false;
        Float4 this_$iv$iv = this_$iv.getX();
        boolean $i$f$getXyz = false;
        Float3 v$iv$iv = new Float3(this_$iv$iv.getX(), this_$iv$iv.getY(), this_$iv$iv.getZ());
        boolean $i$f$length = false;
        float f = (float)Math.sqrt(v$iv$iv.getX() * v$iv$iv.getX() + v$iv$iv.getY() * v$iv$iv.getY() + v$iv$iv.getZ() * v$iv$iv.getZ());
        this_$iv$iv = this_$iv.getY();
        $i$f$getXyz = false;
        v$iv$iv = new Float3(this_$iv$iv.getX(), this_$iv$iv.getY(), this_$iv$iv.getZ());
        $i$f$length = false;
        float f2 = (float)Math.sqrt(v$iv$iv.getX() * v$iv$iv.getX() + v$iv$iv.getY() * v$iv$iv.getY() + v$iv$iv.getZ() * v$iv$iv.getZ());
        this_$iv$iv = this_$iv.getZ();
        $i$f$getXyz = false;
        v$iv$iv = new Float3(this_$iv$iv.getX(), this_$iv$iv.getY(), this_$iv$iv.getZ());
        $i$f$length = false;
        return MatrixKt.scale(new Float3(f, f2, (float)Math.sqrt(v$iv$iv.getX() * v$iv$iv.getX() + v$iv$iv.getY() * v$iv$iv.getY() + v$iv$iv.getZ() * v$iv$iv.getZ())));
    }

    @NotNull
    public static final Mat4 translation(@NotNull Float3 t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return new Mat4(null, null, null, new Float4(t, 1.0f), 7, null);
    }

    @NotNull
    public static final Mat4 translation(@NotNull Mat4 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Mat4 this_$iv = m;
        boolean $i$f$getTranslation = false;
        Float4 this_$iv$iv = this_$iv.getW();
        boolean $i$f$getXyz = false;
        return MatrixKt.translation(new Float3(this_$iv$iv.getX(), this_$iv$iv.getY(), this_$iv$iv.getZ()));
    }

    @NotNull
    public static final Mat4 rotation(@NotNull Mat4 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Mat4 this_$iv = m;
        boolean $i$f$getRight = false;
        Float4 this_$iv$iv = this_$iv.getX();
        boolean $i$f$getXyz = false;
        Float3 float3 = new Float3(this_$iv$iv.getX(), this_$iv$iv.getY(), this_$iv$iv.getZ());
        this_$iv = m;
        boolean $i$f$getUp = false;
        this_$iv$iv = this_$iv.getY();
        $i$f$getXyz = false;
        Float3 float32 = new Float3(this_$iv$iv.getX(), this_$iv$iv.getY(), this_$iv$iv.getZ());
        this_$iv = m;
        boolean $i$f$getForward = false;
        this_$iv$iv = this_$iv.getZ();
        $i$f$getXyz = false;
        return new Mat4(VectorKt.normalize(float3), VectorKt.normalize(float32), VectorKt.normalize(new Float3(this_$iv$iv.getX(), this_$iv$iv.getY(), this_$iv$iv.getZ())), null, 8, null);
    }

    @NotNull
    public static final Mat4 rotation(@NotNull Float3 d) {
        float x;
        float x2;
        Float3 r;
        float p0;
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        Float3 v$iv = d;
        boolean $i$f$transform = false;
        Float3 this_$iv$iv = Float3.copy$default(v$iv, 0.0f, 0.0f, 0.0f, 7, null);
        boolean $i$f$transform2 = false;
        float f = this_$iv$iv.getX();
        Float3 float3 = this_$iv$iv;
        boolean bl = false;
        float v$iv2 = p0;
        boolean $i$f$radians = false;
        float f2 = v$iv2 * ((float)Math.PI / 180);
        float3.setX(f2);
        p0 = this_$iv$iv.getY();
        float3 = this_$iv$iv;
        bl = false;
        v$iv2 = p0;
        $i$f$radians = false;
        f2 = v$iv2 * ((float)Math.PI / 180);
        float3.setY(f2);
        p0 = this_$iv$iv.getZ();
        float3 = this_$iv$iv;
        bl = false;
        v$iv2 = p0;
        $i$f$radians = false;
        f2 = v$iv2 * ((float)Math.PI / 180);
        float3.setZ(f2);
        Float3 v$iv3 = r = this_$iv$iv;
        boolean $i$f$transform3 = false;
        Float3 this_$iv$iv2 = Float3.copy$default(v$iv3, 0.0f, 0.0f, 0.0f, 7, null);
        boolean $i$f$transform4 = false;
        float $i$a$-transform-MatrixKt$rotation$r$2 = this_$iv$iv2.getX();
        float3 = this_$iv$iv2;
        boolean bl2 = false;
        f2 = (float)Math.cos(x2);
        float3.setX(f2);
        x2 = this_$iv$iv2.getY();
        float3 = this_$iv$iv2;
        bl2 = false;
        f2 = (float)Math.cos(x2);
        float3.setY(f2);
        x2 = this_$iv$iv2.getZ();
        float3 = this_$iv$iv2;
        bl2 = false;
        f2 = (float)Math.cos(x2);
        float3.setZ(f2);
        Float3 c = this_$iv$iv2;
        Float3 v$iv4 = r;
        $i$f$transform = false;
        Float3 this_$iv$iv3 = Float3.copy$default(v$iv4, 0.0f, 0.0f, 0.0f, 7, null);
        boolean $i$f$transform5 = false;
        float $i$a$-transform-MatrixKt$rotation$c$2 = this_$iv$iv3.getX();
        float3 = this_$iv$iv3;
        boolean bl3 = false;
        f2 = (float)Math.sin(x);
        float3.setX(f2);
        x = this_$iv$iv3.getY();
        float3 = this_$iv$iv3;
        bl3 = false;
        f2 = (float)Math.sin(x);
        float3.setY(f2);
        x = this_$iv$iv3.getZ();
        float3 = this_$iv$iv3;
        bl3 = false;
        f2 = (float)Math.sin(x);
        float3.setZ(f2);
        Float3 s = this_$iv$iv3;
        float[] fArray = new float[]{c.getY() * c.getZ(), -c.getX() * s.getZ() + s.getX() * s.getY() * c.getZ(), s.getX() * s.getZ() + c.getX() * s.getY() * c.getZ(), 0.0f, c.getY() * s.getZ(), c.getX() * c.getZ() + s.getX() * s.getY() * s.getZ(), -s.getX() * c.getZ() + c.getX() * s.getY() * s.getZ(), 0.0f, -s.getY(), s.getX() * c.getY(), c.getX() * c.getY(), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        return Mat4.Companion.of(fArray);
    }

    @NotNull
    public static final Mat4 rotation(@NotNull Float3 axis, float angle) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        float x = axis.getX();
        float y = axis.getY();
        float z = axis.getZ();
        float v$iv = angle;
        boolean $i$f$radians = false;
        float r = v$iv * ((float)Math.PI / 180);
        float c = (float)Math.cos(r);
        float s = (float)Math.sin(r);
        float d = 1.0f - c;
        float[] fArray = new float[]{x * x * d + c, x * y * d - z * s, x * z * d + y * s, 0.0f, y * x * d + z * s, y * y * d + c, y * z * d - x * s, 0.0f, z * x * d - y * s, z * y * d + x * s, z * z * d + c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        return Mat4.Companion.of(fArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Mat4 normal(@NotNull Mat4 m) {
        void $this$div$iv;
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        float f = 1.0f;
        Mat4 this_$iv = m;
        boolean $i$f$getRight = false;
        Float4 this_$iv$iv = this_$iv.getX();
        boolean $i$f$getXyz = false;
        Float3 v$iv = new Float3(this_$iv$iv.getX(), this_$iv$iv.getY(), this_$iv$iv.getZ());
        boolean $i$f$length2 = false;
        float f2 = v$iv.getX() * v$iv.getX() + v$iv.getY() * v$iv.getY() + v$iv.getZ() * v$iv.getZ();
        this_$iv = m;
        boolean $i$f$getUp = false;
        this_$iv$iv = this_$iv.getY();
        $i$f$getXyz = false;
        v$iv = new Float3(this_$iv$iv.getX(), this_$iv$iv.getY(), this_$iv$iv.getZ());
        $i$f$length2 = false;
        float f3 = v$iv.getX() * v$iv.getX() + v$iv.getY() * v$iv.getY() + v$iv.getZ() * v$iv.getZ();
        this_$iv = m;
        boolean $i$f$getForward = false;
        this_$iv$iv = this_$iv.getZ();
        $i$f$getXyz = false;
        v$iv = new Float3(this_$iv$iv.getX(), this_$iv$iv.getY(), this_$iv$iv.getZ());
        $i$f$length2 = false;
        v$iv = new Float3(f2, f3, v$iv.getX() * v$iv.getX() + v$iv.getY() * v$iv.getY() + v$iv.getZ() * v$iv.getZ());
        boolean $i$f$div = false;
        return MatrixKt.scale(new Float3((float)($this$div$iv / v$iv.getX()), (float)($this$div$iv / v$iv.getY()), (float)($this$div$iv / v$iv.getZ()))).times(m);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Mat4 lookAt(@NotNull Float3 eye, @NotNull Float3 target, @NotNull Float3 up) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)eye, (String)"eye");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)up, (String)"up");
        Float3 float3 = target;
        Float3 v$iv = eye;
        boolean $i$f$minus = false;
        return MatrixKt.lookTowards(eye, new Float3(this_$iv.getX() - v$iv.getX(), this_$iv.getY() - v$iv.getY(), this_$iv.getZ() - v$iv.getZ()), up);
    }

    public static /* synthetic */ Mat4 lookAt$default(Float3 float3, Float3 float32, Float3 float33, int n, Object object) {
        if ((n & 4) != 0) {
            float33 = new Float3(0.0f, 0.0f, 1.0f, 3, null);
        }
        return MatrixKt.lookAt(float3, float32, float33);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Mat4 lookTowards(@NotNull Float3 eye, @NotNull Float3 forward, @NotNull Float3 up) {
        void $this$x$iv;
        void $this$x$iv2;
        Float3 r;
        Float3 f;
        Intrinsics.checkNotNullParameter((Object)eye, (String)"eye");
        Intrinsics.checkNotNullParameter((Object)forward, (String)"forward");
        Intrinsics.checkNotNullParameter((Object)up, (String)"up");
        Float3 float3 = f = VectorKt.normalize(forward);
        Float3 v$iv = up;
        boolean $i$f$x = false;
        v$iv = r = VectorKt.normalize(new Float3($this$x$iv2.getY() * v$iv.getZ() - $this$x$iv2.getZ() * v$iv.getY(), $this$x$iv2.getZ() * v$iv.getX() - $this$x$iv2.getX() * v$iv.getZ(), $this$x$iv2.getX() * v$iv.getY() - $this$x$iv2.getY() * v$iv.getX()));
        Float3 v$iv2 = f;
        boolean $i$f$x2 = false;
        Float3 u = VectorKt.normalize(new Float3($this$x$iv.getY() * v$iv2.getZ() - $this$x$iv.getZ() * v$iv2.getY(), $this$x$iv.getZ() * v$iv2.getX() - $this$x$iv.getX() * v$iv2.getZ(), $this$x$iv.getX() * v$iv2.getY() - $this$x$iv.getY() * v$iv2.getX()));
        return new Mat4(new Float4(r, 0.0f, 2, null), new Float4(u, 0.0f, 2, null), new Float4(f, 0.0f, 2, null), new Float4(eye, 1.0f));
    }

    public static /* synthetic */ Mat4 lookTowards$default(Float3 float3, Float3 float32, Float3 float33, int n, Object object) {
        if ((n & 4) != 0) {
            float33 = new Float3(0.0f, 0.0f, 1.0f, 3, null);
        }
        return MatrixKt.lookTowards(float3, float32, float33);
    }

    @NotNull
    public static final Mat4 perspective(float fov, float ratio, float near, float far) {
        float v$iv = fov;
        boolean $i$f$radians = false;
        float t = 1.0f / (float)Math.tan(v$iv * ((float)Math.PI / 180) * 0.5f);
        float a = (far + near) / (far - near);
        float b = 2.0f * far * near / (far - near);
        float c = t / ratio;
        return new Mat4(new Float4(c, 0.0f, 0.0f, 0.0f, 14, null), new Float4(0.0f, t, 0.0f, 0.0f, 13, null), new Float4(0.0f, 0.0f, a, 1.0f, 3, null), new Float4(0.0f, 0.0f, -b, 0.0f, 11, null));
    }

    @NotNull
    public static final Mat4 ortho(float l, float r, float b, float t, float n, float f) {
        return new Mat4(new Float4(2.0f / (r - 1.0f), 0.0f, 0.0f, 0.0f, 14, null), new Float4(0.0f, 2.0f / (t - b), 0.0f, 0.0f, 13, null), new Float4(0.0f, 0.0f, -2.0f / (f - n), 0.0f, 11, null), new Float4(-(r + l) / (r - l), -(t + b) / (t - b), -(f + n) / (f - n), 1.0f));
    }
}

