/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.math.big;

import com.macrofocus.common.math.big.BigInteger;
import com.macrofocus.common.math.big.BigIntegerRange;
import com.macrofocus.common.math.big.BitSieve;
import com.macrofocus.common.math.big.MutableBigInteger;
import com.macrofocus.common.math.big.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0016\n\u0002\u0010\u0011\n\u0002\b6\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000f\b\u0000\u0018\u0000 \u00a5\u00012\u00020\u0001:\u0002\u00a5\u0001B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\nB-\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\rB\u0019\b\u0012\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\u000eB\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\u0011B!\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\u0014B\u0019\b\u0016\u0012\u0006\u0010\u0015\u001a\u00020\u0005\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0007\u0010\u0018B!\b\u0016\u0012\u0006\u0010\u0019\u001a\u00020\u0005\u0012\u0006\u0010\u001a\u001a\u00020\u0005\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0007\u0010\u001bB\u0019\b\u0010\u0012\u0006\u0010\f\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\u001cB\u0019\b\u0012\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\u001dB\u0011\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u001e\u00a2\u0006\u0004\b\u0007\u0010\u001fJ \u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u0005H\u0002J\b\u0010.\u001a\u00020\u0000H\u0016J\u001f\u0010/\u001a\u0002002\u0006\u0010\u001a\u001a\u00020\u00052\b\u00101\u001a\u0004\u0018\u00010\u0017H\u0000\u00a2\u0006\u0002\b2J\b\u00103\u001a\u000200H\u0002J\u001a\u00104\u001a\u0002002\u0006\u00105\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\b\u00106\u001a\u000207H\u0002J\u0011\u00108\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0096\u0002J\u0015\u00109\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b:J\u0011\u0010;\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010<\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0096\u0002J\u0015\u0010=\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b>J(\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u00052\u0006\u0010C\u001a\u00020\u0005H\u0002J\b\u0010D\u001a\u00020\u0000H\u0002J\u0010\u0010E\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u0005H\u0002J\u0010\u0010G\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u0005H\u0002J\b\u0010H\u001a\u00020\u0000H\u0002J\b\u0010I\u001a\u00020\u0000H\u0002J\b\u0010J\u001a\u00020\u0000H\u0002J\u0011\u0010K\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0096\u0002J\u0010\u0010L\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0002J\u001b\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00000N2\u0006\u0010\u0002\u001a\u00020\u0001H\u0016\u00a2\u0006\u0002\u0010OJ\u001b\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00000N2\u0006\u0010\u0002\u001a\u00020\u0000H\u0002\u00a2\u0006\u0002\u0010QJ\u0010\u0010R\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0016J\u0010\u0010S\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0002J\u0010\u0010T\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0002J\u0010\u0010U\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0002J\u001b\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00000N2\u0006\u0010\u0002\u001a\u00020\u0000H\u0002\u00a2\u0006\u0002\u0010QJ\u0011\u0010W\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u0005H\u0096\u0004J\b\u0010Y\u001a\u00020\u0000H\u0016J\u0013\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00000NH\u0016\u00a2\u0006\u0002\u0010[J\u0010\u0010\\\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0016J\t\u0010`\u001a\u00020\u0000H\u0096\u0002J\t\u0010a\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010c\u001a\u00020\u00002\u0006\u0010d\u001a\u00020\u0001H\u0096\u0002J\u0018\u0010e\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u00012\u0006\u0010d\u001a\u00020\u0001H\u0016J\u0018\u0010f\u001a\u00020\u00002\u0006\u0010g\u001a\u00020\u00002\u0006\u0010h\u001a\u00020\u0000H\u0002J\u0018\u0010i\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u00002\u0006\u0010j\u001a\u00020\u0005H\u0002J\u0010\u0010k\u001a\u00020\u00002\u0006\u0010j\u001a\u00020\u0005H\u0002J\u0010\u0010l\u001a\u00020\u00002\u0006\u0010d\u001a\u00020\u0001H\u0016J\u0011\u0010m\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u0005H\u0096\u0004J\u0011\u0010n\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u0005H\u0096\u0004J\u0010\u0010o\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u0005H\u0002J\u0010\u0010p\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\tH\u0002J\u0010\u0010q\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0016J\u0010\u0010r\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0016J\u0010\u0010s\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0016J\t\u0010t\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010u\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0016J\u0010\u0010v\u001a\u0002002\u0006\u0010F\u001a\u00020\u0005H\u0016J\u0011\u0010w\u001a\u0002002\u0006\u0010F\u001a\u00020\u0005H\u0096\u0002J\u0019\u0010x\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u00052\u0006\u0010y\u001a\u000200H\u0096\u0002J\u0010\u0010z\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u0005H\u0016J\u0010\u0010{\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u0005H\u0016J\u0010\u0010|\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u0005H\u0016J\u0011\u0010\u0080\u0001\u001a\u0002002\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u0012\u0010\u0081\u0001\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0001H\u0096\u0002J\u0017\u0010\u0082\u0001\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0000H\u0000\u00a2\u0006\u0003\b\u0083\u0001J\u0011\u0010\u0082\u0001\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u001eH\u0002J\u0015\u0010\u0084\u0001\u001a\u0002002\t\u0010\u0002\u001a\u0005\u0018\u00010\u0085\u0001H\u0096\u0002J\u0011\u0010\u0086\u0001\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0016J\u0011\u0010\u0087\u0001\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0016J\t\u0010\u0088\u0001\u001a\u00020\u0005H\u0016J\u0011\u0010\u0089\u0001\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0011\u0010\u008a\u0001\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\t\u0010\u0089\u0001\u001a\u00020\u000fH\u0016J\t\u0010\u008b\u0001\u001a\u00020\u0003H\u0016J\t\u0010\u008c\u0001\u001a\u00020\u0005H\u0016J\t\u0010\u008d\u0001\u001a\u00020\u001eH\u0016J\n\u0010\u008e\u0001\u001a\u00030\u008f\u0001H\u0016J\n\u0010\u0090\u0001\u001a\u00030\u0091\u0001H\u0016J\n\u0010\u0092\u0001\u001a\u00030\u0093\u0001H\u0016J\n\u0010\u0094\u0001\u001a\u00030\u0095\u0001H\u0016J\n\u0010\u0096\u0001\u001a\u00030\u0097\u0001H\u0016J\u0011\u0010\u009e\u0001\u001a\u00020\u00052\u0006\u0010F\u001a\u00020\u0005H\u0002J\t\u0010\u009f\u0001\u001a\u00020\u0005H\u0002J\t\u0010\u00a0\u0001\u001a\u00020\u0003H\u0002J\t\u0010\u00a1\u0001\u001a\u00020\u001eH\u0016J\t\u0010\u00a2\u0001\u001a\u00020\u0005H\u0016J\n\u0010\u00a3\u0001\u001a\u00030\u0093\u0001H\u0016J\n\u0010\u00a4\u0001\u001a\u00030\u008f\u0001H\u0016R\u0014\u0010 \u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0010\u0010#\u001a\u00020\t8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\"R\u0014\u0010]\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b^\u0010_R\u0014\u0010\u000b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bb\u0010\"R\u0014\u0010\u0019\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b}\u0010\"R\u0014\u0010~\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u007f\u0010\"R\u0016\u0010\u0098\u0001\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0007\u001a\u0005\b\u0099\u0001\u0010\"R\u0016\u0010\u009a\u0001\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0007\u001a\u0005\b\u009b\u0001\u0010\"R\u0016\u0010\u009c\u0001\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0007\u001a\u0005\b\u009d\u0001\u0010\"\u00a8\u0006\u00a6\u0001"}, d2={"Lcom/macrofocus/common/math/big/CommonBigInteger;", "Lcom/macrofocus/common/math/big/BigInteger;", "other", "", "off", "", "len", "<init>", "([BII)V", "", "([I)V", "signum", "magnitude", "(I[BII)V", "(I[I)V", "", "radix", "(Ljava/lang/String;I)V", "", "sign", "([CII)V", "numBits", "rnd", "Lkotlin/random/Random;", "(ILkotlin/random/Random;)V", "bitLength", "certainty", "(IILkotlin/random/Random;)V", "([II)V", "([BI)V", "", "(J)V", "_signum", "get_signum$macrofocus_common", "()I", "_mag", "_bitCountPlusOne", "_bitLengthPlusOne", "_lowestSetBitPlusTwo", "_firstNonzeroIntNumPlusTwo", "lowestSetBit", "getLowestSetBit", "parseInt", "source", "start", "end", "nextProbablePrime", "primeToCertainty", "", "random", "primeToCertainty$macrofocus_common", "passesLucasLehmer", "passesMillerRabin", "iterations", "checkRange", "", "plus", "plusLong", "plusLong$macrofocus_common", "minus", "times", "timesLong", "timesLong$macrofocus_common", "getToomSlice", "lowerSize", "upperSize", "slice", "fullsize", "exactDivideBy3", "getLower", "n", "getUpper", "square", "squareKaratsuba", "squareToomCook3", "div", "divideKnuth", "divideAndRemainder", "", "(Lcom/macrofocus/common/math/big/BigInteger;)[Lcom/macrofocus/common/math/big/CommonBigInteger;", "divideAndRemainderKnuth", "(Lcom/macrofocus/common/math/big/CommonBigInteger;)[Lcom/macrofocus/common/math/big/CommonBigInteger;", "remainder", "remainderKnuth", "divideBurnikelZiegler", "remainderBurnikelZiegler", "divideAndRemainderBurnikelZiegler", "pow", "exponent", "sqrt", "sqrtAndRemainder", "()[Lcom/macrofocus/common/math/big/CommonBigInteger;", "gcd", "absoluteValue", "getAbsoluteValue", "()Lcom/macrofocus/common/math/big/CommonBigInteger;", "unaryMinus", "unaryPlus", "getSignum", "rem", "modulus", "modPow", "oddModPow", "y", "z", "modPow2", "p", "mod2", "modInverse", "shl", "shr", "shiftRightImpl", "javaIncrement", "and", "or", "xor", "not", "andNot", "testBit", "get", "set", "b", "setBit", "clearBit", "flipBit", "getBitLength", "bitCount", "getBitCount", "isProbablePrime", "compareTo", "compareMagnitude", "compareMagnitude$macrofocus_common", "equals", "", "min", "max", "hashCode", "toString", "smallToString", "toByteArray", "toInt", "toLong", "toByte", "", "toChar", "", "toShort", "", "toFloat", "", "toDouble", "", "intLength", "getIntLength", "signBit", "getSignBit", "signInt", "getSignInt", "getInt", "firstNonzeroIntNum", "magSerializedForm", "toLongExact", "toIntExact", "toShortExact", "toByteExact", "Companion", "macrofocus-common"})
@SourceDebugExtension(value={"SMAP\nCommonBigInteger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonBigInteger.kt\ncom/macrofocus/common/math/big/CommonBigInteger\n+ 2 JvmUtils.kt\ncom/macrofocus/common/math/big/JvmUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,5194:1\n44#2:5195\n44#2:5196\n44#2:5197\n44#2:5198\n44#2:5199\n44#2:5200\n44#2:5201\n44#2:5202\n44#2:5203\n44#2:5204\n44#2:5213\n44#2:5214\n44#2:5215\n44#2:5216\n44#2:5217\n44#2:5218\n1563#3:5205\n1634#3,3:5206\n37#4:5209\n36#4,3:5210\n*S KotlinDebug\n*F\n+ 1 CommonBigInteger.kt\ncom/macrofocus/common/math/big/CommonBigInteger\n*L\n877#1:5195\n942#1:5196\n978#1:5197\n1325#1:5198\n1364#1:5199\n1399#1:5200\n1630#1:5201\n1693#1:5202\n1719#1:5203\n1720#1:5204\n2117#1:5213\n2280#1:5214\n2297#1:5215\n2314#1:5216\n2348#1:5217\n2576#1:5218\n1912#1:5205\n1912#1:5206,3\n1912#1:5209\n1912#1:5210,3\n*E\n"})
public final class CommonBigInteger
implements BigInteger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int _signum;
    @JvmField
    @NotNull
    public final int[] _mag;
    private int _bitCountPlusOne;
    private int _bitLengthPlusOne;
    private int _lowestSetBitPlusTwo;
    private int _firstNonzeroIntNumPlusTwo;
    public static final long LONG_MASK = 0xFFFFFFFFL;
    private static final int MAX_MAG_LENGTH = 0x4000000;
    private static final int PRIME_SEARCH_BIT_LENGTH_LIMIT = 500000000;
    private static final int KARATSUBA_THRESHOLD = 80;
    private static final int TOOM_COOK_THRESHOLD = 240;
    private static final int KARATSUBA_SQUARE_THRESHOLD = 128;
    private static final int TOOM_COOK_SQUARE_THRESHOLD = 216;
    public static final int BURNIKEL_ZIEGLER_THRESHOLD = 80;
    public static final int BURNIKEL_ZIEGLER_OFFSET = 40;
    private static final int SCHOENHAGE_BASE_CONVERSION_THRESHOLD = 20;
    private static final int MULTIPLY_SQUARE_THRESHOLD = 20;
    private static final int MONTGOMERY_INTRINSIC_THRESHOLD = 512;
    @NotNull
    private static final long[] bitsPerDigit;
    private static final int SMALL_PRIME_THRESHOLD = 95;
    private static final int DEFAULT_PRIME_CERTAINTY = 100;
    @NotNull
    private static final CommonBigInteger SMALL_PRIME_PRODUCT;
    private static final int MAX_CONSTANT;
    @NotNull
    private static final CommonBigInteger[] posConst;
    @NotNull
    private static final CommonBigInteger[] negConst;
    @NotNull
    private static CommonBigInteger[][] powerCache;
    @NotNull
    private static final double[] logCache;
    private static final double LOG_TWO;
    @JvmField
    @NotNull
    public static final CommonBigInteger ZERO;
    @JvmField
    @NotNull
    public static final CommonBigInteger ONE;
    @JvmField
    @NotNull
    public static final CommonBigInteger TWO;
    @JvmField
    @NotNull
    public static final CommonBigInteger NEGATIVE_ONE;
    @JvmField
    @NotNull
    public static final CommonBigInteger TEN;
    @NotNull
    private static int[] bnExpModThreshTable;
    @NotNull
    private static final String[] zeros;
    @NotNull
    private static final int[] digitsPerLong;
    @NotNull
    private static final CommonBigInteger[] longRadix;
    @NotNull
    private static final int[] digitsPerInt;
    @NotNull
    private static final int[] intRadix;

    public final int get_signum$macrofocus_common() {
        return this._signum;
    }

    private final int getLowestSetBit() {
        int lsb = this._lowestSetBitPlusTwo - 2;
        if (lsb == -2) {
            lsb = 0;
            if (this._signum == 0) {
                --lsb;
            } else {
                int i = 0;
                int b = 0;
                i = 0;
                b = this.getInt(i);
                while (b == 0) {
                    b = this.getInt(++i);
                }
                lsb += (i << 5) + Utils.numberOfTrailingZeros(b);
            }
            this._lowestSetBitPlusTwo = lsb + 2;
        }
        return lsb;
    }

    public CommonBigInteger(@NotNull byte[] other, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other.length == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        if (off < 0 || off >= other.length || len < 0 || len > other.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (other[off] < 0) {
            this._mag = CommonBigInteger.Companion.makePositive(other, off, len);
            this._signum = -1;
        } else {
            this._mag = CommonBigInteger.Companion.stripLeadingZeroBytes(other, off, len);
            int n = this._signum = this._mag.length == 0 ? 0 : 1;
        }
        if (this._mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    public /* synthetic */ CommonBigInteger(byte[] byArray, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        this(byArray, n, n2);
    }

    private CommonBigInteger(int[] other) {
        if (other.length == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        if (other[0] < 0) {
            this._mag = CommonBigInteger.Companion.makePositive(other);
            this._signum = -1;
        } else {
            this._mag = CommonBigInteger.Companion.trustedStripLeadingZeroInts(other);
            int n = this._signum = this._mag.length == 0 ? 0 : 1;
        }
        if (this._mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    public CommonBigInteger(int signum, @NotNull byte[] magnitude, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)magnitude, (String)"magnitude");
        if (signum < -1 || signum > 1) {
            throw new NumberFormatException("Invalid _signum value");
        }
        if (off < 0 || len < 0 || len > 0 && (off >= magnitude.length || len > magnitude.length - off)) {
            throw new IndexOutOfBoundsException();
        }
        this._mag = CommonBigInteger.Companion.stripLeadingZeroBytes(magnitude, off, len);
        if (this._mag.length == 0) {
            this._signum = 0;
        } else {
            if (signum == 0) {
                throw new NumberFormatException("_signum-magnitude mismatch");
            }
            this._signum = signum;
        }
        if (this._mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    public /* synthetic */ CommonBigInteger(int n, byte[] byArray, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = byArray.length;
        }
        this(n, byArray, n2, n3);
    }

    private CommonBigInteger(int signum, int[] magnitude) {
        this._mag = CommonBigInteger.Companion.stripLeadingZeroInts(magnitude);
        if (signum < -1 || signum > 1) {
            throw new NumberFormatException("Invalid _signum value");
        }
        if (this._mag.length == 0) {
            this._signum = 0;
        } else {
            if (signum == 0) {
                throw new NumberFormatException("_signum-magnitude mismatch");
            }
            this._signum = signum;
        }
        if (this._mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    public CommonBigInteger(@NotNull String other, int radix) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int cursor = 0;
        int numDigits = 0;
        int len = other.length();
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("Radix out of range");
        }
        if (len == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        int sign = 1;
        int index1 = StringsKt.lastIndexOf$default((CharSequence)other, (char)'-', (int)0, (boolean)false, (int)6, null);
        int index2 = StringsKt.lastIndexOf$default((CharSequence)other, (char)'+', (int)0, (boolean)false, (int)6, null);
        if (index1 >= 0) {
            if (index1 != 0 || index2 >= 0) {
                throw new NumberFormatException("Illegal embedded sign character");
            }
            sign = -1;
            cursor = 1;
        } else if (index2 >= 0) {
            if (index2 != 0) {
                throw new NumberFormatException("Illegal embedded sign character");
            }
            cursor = 1;
        }
        if (cursor == len) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        while (cursor < len && Utils.toDigit(other.charAt(cursor), radix) == 0) {
            ++cursor;
        }
        if (cursor == len) {
            this._signum = 0;
            this._mag = CommonBigInteger.ZERO._mag;
            return;
        }
        numDigits = len - cursor;
        this._signum = sign;
        long numBits = ((long)numDigits * bitsPerDigit[radix] >>> 10) + 1L;
        if (numBits + (long)31 >= 0x100000000L) {
            CommonBigInteger.Companion.reportOverflow();
        }
        int numWords = (int)(numBits + (long)31) >>> 5;
        int[] magnitude = new int[numWords];
        int firstGroupLen = numDigits % digitsPerInt[radix];
        if (firstGroupLen == 0) {
            firstGroupLen = digitsPerInt[radix];
        }
        String string = other.substring(cursor, cursor + firstGroupLen);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String group = string;
        cursor += firstGroupLen;
        magnitude[numWords - 1] = Integer.parseInt(group, CharsKt.checkRadix((int)radix));
        if (magnitude[numWords - 1] < 0) {
            throw new NumberFormatException("Illegal digit");
        }
        int superRadix = intRadix[radix];
        int groupVal = 0;
        while (cursor < len) {
            Intrinsics.checkNotNullExpressionValue((Object)other.substring(cursor, cursor + digitsPerInt[radix]), (String)"substring(...)");
            cursor += digitsPerInt[radix];
            groupVal = Integer.parseInt(group, CharsKt.checkRadix((int)radix));
            if (groupVal < 0) {
                throw new NumberFormatException("Illegal digit");
            }
            CommonBigInteger.Companion.destructiveMulAdd(magnitude, superRadix, groupVal);
        }
        this._mag = CommonBigInteger.Companion.trustedStripLeadingZeroInts(magnitude);
        if (this._mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    public /* synthetic */ CommonBigInteger(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 10;
        }
        this(string, n);
    }

    public CommonBigInteger(@NotNull char[] other, int sign, int len) {
        int cursor;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int numDigits = 0;
        for (cursor = 0; cursor < len && Utils.toDigit(other[cursor], 10) == 0; ++cursor) {
        }
        if (cursor == len) {
            this._signum = 0;
            this._mag = CommonBigInteger.ZERO._mag;
            return;
        }
        numDigits = len - cursor;
        this._signum = sign;
        int numWords = 0;
        if (len < 10) {
            numWords = 1;
        } else {
            long numBits = ((long)numDigits * bitsPerDigit[10] >>> 10) + 1L;
            if (numBits + (long)31 >= 0x100000000L) {
                CommonBigInteger.Companion.reportOverflow();
            }
            numWords = (int)(numBits + (long)31) >>> 5;
        }
        int[] magnitude = new int[numWords];
        int firstGroupLen = numDigits % digitsPerInt[10];
        if (firstGroupLen == 0) {
            firstGroupLen = digitsPerInt[10];
        }
        magnitude[numWords - 1] = this.parseInt(other, cursor, cursor + firstGroupLen);
        cursor += firstGroupLen;
        while (cursor < len) {
            int groupVal = this.parseInt(other, cursor, cursor + digitsPerInt[10]);
            cursor += digitsPerInt[10];
            CommonBigInteger.Companion.destructiveMulAdd(magnitude, CommonBigInteger.intRadix[10], groupVal);
        }
        this._mag = CommonBigInteger.Companion.trustedStripLeadingZeroInts(magnitude);
        if (this._mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    private final int parseInt(char[] source, int start, int end) {
        int result = Utils.toDigit(source[start], 10);
        if (result == -1) {
            throw new NumberFormatException(StringsKt.concatToString((char[])source));
        }
        for (int index = start + 1; index < end; ++index) {
            int nextVal = Utils.toDigit(source[index], 10);
            if (nextVal == -1) {
                throw new NumberFormatException(StringsKt.concatToString((char[])source));
            }
            result = 10 * result + nextVal;
        }
        return result;
    }

    public CommonBigInteger(int numBits, @NotNull Random rnd) {
        Intrinsics.checkNotNullParameter((Object)rnd, (String)"rnd");
        this(1, CommonBigInteger.Companion.randomBits(numBits, rnd), 0, 0, 12, null);
    }

    public CommonBigInteger(int bitLength, int certainty, @NotNull Random rnd) {
        Intrinsics.checkNotNullParameter((Object)rnd, (String)"rnd");
        CommonBigInteger prime = null;
        if (bitLength < 2) {
            throw new ArithmeticException("bitLength < 2");
        }
        prime = bitLength < 95 ? CommonBigInteger.Companion.smallPrime(bitLength, certainty, rnd) : CommonBigInteger.Companion.largePrime(bitLength, certainty, rnd);
        this._signum = 1;
        this._mag = prime._mag;
    }

    @Override
    @NotNull
    public CommonBigInteger nextProbablePrime() {
        BitSieve searchSieve;
        if (this._signum < 0) {
            throw new ArithmeticException("start < 0: " + this);
        }
        if (this._signum == 0 || Intrinsics.areEqual((Object)this, (Object)ONE)) {
            return TWO;
        }
        CommonBigInteger result = this.plus(ONE);
        if (result.getBitLength() < 95) {
            if (!result.testBit(0)) {
                result = result.plus(ONE);
            }
            while (true) {
                long r;
                if (result.getBitLength() > 6 && ((r = result.remainder(SMALL_PRIME_PRODUCT).toLong()) % (long)3 == 0L || r % (long)5 == 0L || r % (long)7 == 0L || r % (long)11 == 0L || r % (long)13 == 0L || r % (long)17 == 0L || r % (long)19 == 0L || r % (long)23 == 0L || r % (long)29 == 0L || r % (long)31 == 0L || r % (long)37 == 0L || r % (long)41 == 0L)) {
                    result = result.plus(TWO);
                    continue;
                }
                if (result.getBitLength() < 4) {
                    return result;
                }
                if (result.primeToCertainty$macrofocus_common(100, null)) {
                    return result;
                }
                result = result.plus(TWO);
            }
        }
        if (result.testBit(0)) {
            result = result.minus(ONE);
        }
        int searchLen = CommonBigInteger.Companion.getPrimeSearchLen(result.getBitLength());
        BitSieve bitSieve = searchSieve = new BitSieve(result, searchLen);
        CommonBigInteger commonBigInteger = result;
        int n = 100;
        Intrinsics.checkNotNull(null);
        throw new KotlinNothingValueException();
    }

    public final boolean primeToCertainty$macrofocus_common(int certainty, @Nullable Random random) {
        int rounds = 0;
        int n = (Math.max(certainty, 0x7FFFFFFE) + 1) / 2;
        int sizeInBits = this.getBitLength();
        if (sizeInBits < 100) {
            rounds = 50;
            rounds = n < rounds ? n : rounds;
            return this.passesMillerRabin(rounds, random);
        }
        rounds = sizeInBits < 256 ? 27 : (sizeInBits < 512 ? 15 : (sizeInBits < 768 ? 8 : (sizeInBits < 1024 ? 4 : 2)));
        rounds = n < rounds ? n : rounds;
        return this.passesMillerRabin(rounds, random) && this.passesLucasLehmer();
    }

    private final boolean passesLucasLehmer() {
        CommonBigInteger thisPlusOne = this.plus(ONE);
        int d = 5;
        while (CommonBigInteger.Companion.jacobiSymbol(d, this) != -1) {
            d = d < 0 ? Math.abs(d) + 2 : -(d + 2);
        }
        CommonBigInteger u = CommonBigInteger.Companion.lucasLehmerSequence(d, thisPlusOne, this);
        return Intrinsics.areEqual((Object)u.rem(this), (Object)ZERO);
    }

    private final boolean passesMillerRabin(int iterations, Random rnd) {
        CommonBigInteger thisMinusOne;
        Random rnd2 = rnd;
        CommonBigInteger m = thisMinusOne = this.minus(ONE);
        int a = m.getLowestSetBit();
        m = m.shr(a);
        if (rnd2 == null) {
            rnd2 = (Random)Random.Default;
        }
        for (int i = 0; i < iterations; ++i) {
            CommonBigInteger b = null;
            while ((b = new CommonBigInteger(this.getBitLength(), rnd2)).compareTo(ONE) <= 0 || b.compareTo(this) >= 0) {
            }
            int j = 0;
            CommonBigInteger z = b.modPow(m, this);
            while (!(j == 0 && Intrinsics.areEqual((Object)z, (Object)ONE) || Intrinsics.areEqual((Object)z, (Object)thisMinusOne))) {
                if (j > 0 && Intrinsics.areEqual((Object)z, (Object)ONE) || ++j == a) {
                    return false;
                }
                z = z.modPow(TWO, this);
            }
        }
        return true;
    }

    public CommonBigInteger(@NotNull int[] magnitude, int signum) {
        Intrinsics.checkNotNullParameter((Object)magnitude, (String)"magnitude");
        this._signum = magnitude.length == 0 ? 0 : signum;
        this._mag = magnitude;
        if (this._mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    private CommonBigInteger(byte[] magnitude, int signum) {
        this._signum = magnitude.length == 0 ? 0 : signum;
        this._mag = CommonBigInteger.Companion.stripLeadingZeroBytes(magnitude, 0, magnitude.length);
        if (this._mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    private final void checkRange() {
        if (this._mag.length > 0x4000000 || this._mag.length == 0x4000000 && this._mag[0] < 0) {
            CommonBigInteger.Companion.reportOverflow();
        }
    }

    private CommonBigInteger(long other) {
        long other2 = other;
        if (other2 < 0L) {
            other2 = -other2;
            this._signum = -1;
        } else {
            this._signum = 1;
        }
        int highWord = (int)(other2 >>> 32);
        if (highWord == 0) {
            this._mag = new int[1];
            this._mag[0] = (int)other2;
        } else {
            this._mag = new int[2];
            this._mag[0] = highWord;
            this._mag[1] = (int)other2;
        }
    }

    @Override
    @NotNull
    public CommonBigInteger plus(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        BigInteger $this$castTo$iv = other;
        boolean $i$f$castTo = false;
        CommonBigInteger other2 = (CommonBigInteger)$this$castTo$iv;
        if (other2.getSignum() == 0) {
            return this;
        }
        if (this._signum == 0) {
            return other2;
        }
        if (other2._signum == this._signum) {
            return new CommonBigInteger(CommonBigInteger.Companion.sum(this._mag, other2._mag), this._signum);
        }
        int cmp = this.compareMagnitude$macrofocus_common(other2);
        if (cmp == 0) {
            return ZERO;
        }
        int[] resultMag = cmp > 0 ? CommonBigInteger.Companion.subtract(this._mag, other2._mag) : CommonBigInteger.Companion.subtract(other2._mag, this._mag);
        resultMag = CommonBigInteger.Companion.trustedStripLeadingZeroInts(resultMag);
        return new CommonBigInteger(resultMag, cmp == this._signum ? 1 : -1);
    }

    @NotNull
    public final CommonBigInteger plusLong$macrofocus_common(long other) {
        if (other == 0L) {
            return this;
        }
        if (this._signum == 0) {
            return Companion.of(other);
        }
        if (MathKt.getSign((long)other) == this._signum) {
            return new CommonBigInteger(CommonBigInteger.Companion.sum(this._mag, Math.abs(other)), this._signum);
        }
        int cmp = this.compareMagnitude(other);
        if (cmp == 0) {
            return ZERO;
        }
        int[] resultMag = cmp > 0 ? CommonBigInteger.Companion.subtract(this._mag, Math.abs(other)) : CommonBigInteger.Companion.subtract(Math.abs(other), this._mag);
        resultMag = CommonBigInteger.Companion.trustedStripLeadingZeroInts(resultMag);
        return new CommonBigInteger(resultMag, cmp == this._signum ? 1 : -1);
    }

    @Override
    @NotNull
    public CommonBigInteger minus(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        BigInteger $this$castTo$iv = other;
        boolean $i$f$castTo = false;
        CommonBigInteger other2 = (CommonBigInteger)$this$castTo$iv;
        if (other2._signum == 0) {
            return this;
        }
        if (this._signum == 0) {
            return other2.unaryMinus();
        }
        if (other2._signum != this._signum) {
            return new CommonBigInteger(CommonBigInteger.Companion.sum(this._mag, other2._mag), this._signum);
        }
        int cmp = this.compareMagnitude$macrofocus_common(other2);
        if (cmp == 0) {
            return ZERO;
        }
        int[] resultMag = cmp > 0 ? CommonBigInteger.Companion.subtract(this._mag, other2._mag) : CommonBigInteger.Companion.subtract(other2._mag, this._mag);
        resultMag = CommonBigInteger.Companion.trustedStripLeadingZeroInts(resultMag);
        return new CommonBigInteger(resultMag, cmp == this._signum ? 1 : -1);
    }

    @Override
    @NotNull
    public CommonBigInteger times(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        BigInteger $this$castTo$iv = other;
        boolean $i$f$castTo = false;
        CommonBigInteger other2 = (CommonBigInteger)$this$castTo$iv;
        if (other2._signum == 0 || this._signum == 0) {
            return ZERO;
        }
        int xlen = this._mag.length;
        if (other2 == this && xlen > 20) {
            return this.square();
        }
        int ylen = other2._mag.length;
        if (xlen < 80 || ylen < 80) {
            int resultSign;
            int n = resultSign = this._signum == other2._signum ? 1 : -1;
            if (other2._mag.length == 1) {
                return CommonBigInteger.Companion.multiplyByInt(this._mag, other2._mag[0], resultSign);
            }
            if (this._mag.length == 1) {
                return CommonBigInteger.Companion.multiplyByInt(other2._mag, this._mag[0], resultSign);
            }
            int[] result = CommonBigInteger.Companion.multiplyToLen(this._mag, xlen, other2._mag, ylen, null);
            result = CommonBigInteger.Companion.trustedStripLeadingZeroInts(result);
            return new CommonBigInteger(result, resultSign);
        }
        return xlen < 240 && ylen < 240 ? CommonBigInteger.Companion.multiplyKaratsuba(this, other2) : CommonBigInteger.Companion.multiplyToomCook3(this, other2);
    }

    @NotNull
    public final CommonBigInteger timesLong$macrofocus_common(long other) {
        long product;
        int i;
        int rsign;
        long v = other;
        if (v == 0L || this._signum == 0) {
            return ZERO;
        }
        if (v == Long.MIN_VALUE) {
            return this.times(Companion.of(v));
        }
        int n = rsign = v > 0L ? this._signum : -this._signum;
        if (v < 0L) {
            v = -v;
        }
        long dh = v >>> 32;
        long dl = v & 0xFFFFFFFFL;
        int xlen = this._mag.length;
        int[] value = this._mag;
        int[] rmag = dh == 0L ? new int[xlen + 1] : new int[xlen + 2];
        long carry = 0L;
        int rstart = rmag.length - 1;
        for (i = xlen - 1; -1 < i; --i) {
            product = ((long)value[i] & 0xFFFFFFFFL) * dl + carry;
            rmag[rstart--] = (int)product;
            carry = product >>> 32;
        }
        rmag[rstart] = (int)carry;
        if (dh != 0L) {
            carry = 0L;
            rstart = rmag.length - 2;
            for (i = xlen - 1; -1 < i; --i) {
                product = ((long)value[i] & 0xFFFFFFFFL) * dh + ((long)rmag[rstart] & 0xFFFFFFFFL) + carry;
                rmag[rstart--] = (int)product;
                carry = product >>> 32;
            }
            rmag[0] = (int)carry;
        }
        if (carry == 0L) {
            rmag = ArraysKt.copyOfRange((int[])rmag, (int)1, (int)rmag.length);
        }
        return new CommonBigInteger(rmag, rsign);
    }

    private final CommonBigInteger getToomSlice(int lowerSize, int upperSize, int slice, int fullsize) {
        int start = 0;
        int end = 0;
        int sliceSize = 0;
        int len = 0;
        int offset = 0;
        len = this._mag.length;
        offset = fullsize - len;
        if (slice == 0) {
            start = 0 - offset;
            end = upperSize - 1 - offset;
        } else {
            start = upperSize + (slice - 1) * lowerSize - offset;
            end = start + lowerSize - 1;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            return ZERO;
        }
        sliceSize = end - start + 1;
        if (sliceSize <= 0) {
            return ZERO;
        }
        if (start == 0 && sliceSize >= len) {
            return this.getAbsoluteValue();
        }
        int[] intSlice = new int[sliceSize];
        Utils.arrayCopy(this._mag, start, intSlice, 0, sliceSize);
        return new CommonBigInteger(CommonBigInteger.Companion.trustedStripLeadingZeroInts(intSlice), 1);
    }

    private final CommonBigInteger exactDivideBy3() {
        int len = this._mag.length;
        int[] result = new int[len];
        long x = 0L;
        long w = 0L;
        long q = 0L;
        long borrow = 0L;
        borrow = 0L;
        for (int i = len - 1; -1 < i; --i) {
            x = (long)this._mag[i] & 0xFFFFFFFFL;
            w = x - borrow;
            borrow = borrow > x ? 1L : 0L;
            q = w * 0xAAAAAAABL & 0xFFFFFFFFL;
            result[i] = (int)q;
            if (q < 0x55555556L) continue;
            long l = borrow;
            borrow = l + 1L;
            if (q < 0xAAAAAAABL) continue;
            l = borrow;
            borrow = l + 1L;
        }
        result = CommonBigInteger.Companion.trustedStripLeadingZeroInts(result);
        return new CommonBigInteger(result, this._signum);
    }

    private final CommonBigInteger getLower(int n) {
        int len = this._mag.length;
        if (len <= n) {
            return this.getAbsoluteValue();
        }
        int[] lowerInts = new int[n];
        Utils.arrayCopy(this._mag, len - n, lowerInts, 0, n);
        return new CommonBigInteger(CommonBigInteger.Companion.trustedStripLeadingZeroInts(lowerInts), 1);
    }

    private final CommonBigInteger getUpper(int n) {
        int len = this._mag.length;
        if (len <= n) {
            return ZERO;
        }
        int upperLen = len - n;
        int[] upperInts = new int[upperLen];
        Utils.arrayCopy(this._mag, 0, upperInts, 0, upperLen);
        return new CommonBigInteger(CommonBigInteger.Companion.trustedStripLeadingZeroInts(upperInts), 1);
    }

    private final CommonBigInteger square() {
        if (this._signum == 0) {
            return ZERO;
        }
        int len = this._mag.length;
        if (len < 128) {
            int[] z = CommonBigInteger.Companion.squareToLen(this._mag, len, null);
            return new CommonBigInteger(CommonBigInteger.Companion.trustedStripLeadingZeroInts(z), 1);
        }
        return len < 216 ? this.squareKaratsuba() : this.squareToomCook3();
    }

    private final CommonBigInteger squareKaratsuba() {
        int half = (this._mag.length + 1) / 2;
        CommonBigInteger xl = this.getLower(half);
        CommonBigInteger xh = this.getUpper(half);
        CommonBigInteger xhs = xh.square();
        CommonBigInteger xls = xl.square();
        return xhs.shl(half * 32).plus(xl.plus(xh).square().minus(xhs.plus(xls))).shl(half * 32).plus(xls);
    }

    private final CommonBigInteger squareToomCook3() {
        int len = this._mag.length;
        int k = (len + 2) / 3;
        int r = len - 2 * k;
        CommonBigInteger a0 = null;
        CommonBigInteger a1 = null;
        CommonBigInteger a2 = null;
        a2 = this.getToomSlice(k, r, 0, len);
        a1 = this.getToomSlice(k, r, 1, len);
        a0 = this.getToomSlice(k, r, 2, len);
        CommonBigInteger v0 = null;
        CommonBigInteger v1 = null;
        CommonBigInteger v2 = null;
        CommonBigInteger vm1 = null;
        CommonBigInteger vinf = null;
        CommonBigInteger t1 = null;
        CommonBigInteger t2 = null;
        CommonBigInteger tm1 = null;
        CommonBigInteger da1 = null;
        v0 = a0.square();
        da1 = a2.plus(a0);
        vm1 = da1.minus(a1).square();
        da1 = da1.plus(a1);
        v1 = da1.square();
        vinf = a2.square();
        v2 = da1.plus(a2).shl(1).minus(a0).square();
        t2 = v2.minus(vm1).exactDivideBy3();
        tm1 = v1.minus(vm1).shr(1);
        t1 = v1.minus(v0);
        t2 = t2.minus(t1).shr(1);
        t1 = t1.minus(tm1).minus(vinf);
        t2 = t2.minus(vinf.shl(1));
        tm1 = tm1.minus(t2);
        int ss = k * 32;
        return vinf.shl(ss).plus(t2).shl(ss).plus(t1).shl(ss).plus(tm1).shl(ss).plus(v0);
    }

    @Override
    @NotNull
    public CommonBigInteger div(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        BigInteger $this$castTo$iv = other;
        boolean $i$f$castTo = false;
        CommonBigInteger other2 = (CommonBigInteger)$this$castTo$iv;
        boolean magSizeBelowThreshold = this._mag.length < 80;
        boolean magSizeDiffIsOffset = this._mag.length - other2._mag.length < 40;
        return magSizeBelowThreshold || magSizeDiffIsOffset ? this.divideKnuth(other2) : this.divideBurnikelZiegler(other2);
    }

    private final CommonBigInteger divideKnuth(CommonBigInteger other) {
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger a = new MutableBigInteger(this._mag);
        MutableBigInteger b = new MutableBigInteger(other._mag);
        a.divideKnuth(b, q, false);
        return q.toBigInteger(this._signum * other._signum);
    }

    @NotNull
    public CommonBigInteger[] divideAndRemainder(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        BigInteger $this$castTo$iv = other;
        boolean $i$f$castTo = false;
        CommonBigInteger other2 = (CommonBigInteger)$this$castTo$iv;
        boolean magSizeBelowThreshold = this._mag.length < 80;
        boolean magSizeDiffIsOffset = this._mag.length - other2._mag.length < 40;
        return magSizeBelowThreshold || magSizeDiffIsOffset ? this.divideAndRemainderKnuth(other2) : this.divideAndRemainderBurnikelZiegler(other2);
    }

    private final CommonBigInteger[] divideAndRemainderKnuth(CommonBigInteger other) {
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger a = new MutableBigInteger(this._mag);
        MutableBigInteger b = new MutableBigInteger(other._mag);
        MutableBigInteger r = MutableBigInteger.divideKnuth$default(a, b, q, false, 4, null);
        CommonBigInteger[] commonBigIntegerArray = new CommonBigInteger[2];
        commonBigIntegerArray[0] = q.toBigInteger(this._signum == other._signum ? 1 : -1);
        MutableBigInteger mutableBigInteger = r;
        Intrinsics.checkNotNull((Object)mutableBigInteger);
        commonBigIntegerArray[1] = mutableBigInteger.toBigInteger(this._signum);
        return commonBigIntegerArray;
    }

    @Override
    @NotNull
    public CommonBigInteger remainder(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        BigInteger $this$castTo$iv = other;
        boolean $i$f$castTo = false;
        CommonBigInteger other2 = (CommonBigInteger)$this$castTo$iv;
        boolean magSizeBelowThreshold = this._mag.length < 80;
        boolean magSizeDiffIsOffset = this._mag.length - other2._mag.length < 40;
        return magSizeBelowThreshold || magSizeDiffIsOffset ? this.remainderKnuth(other2) : this.remainderBurnikelZiegler(other2);
    }

    private final CommonBigInteger remainderKnuth(CommonBigInteger other) {
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger a = new MutableBigInteger(this._mag);
        MutableBigInteger b = new MutableBigInteger(other._mag);
        MutableBigInteger mutableBigInteger = MutableBigInteger.divideKnuth$default(a, b, q, false, 4, null);
        Intrinsics.checkNotNull((Object)mutableBigInteger);
        return mutableBigInteger.toBigInteger(this._signum);
    }

    private final CommonBigInteger divideBurnikelZiegler(CommonBigInteger other) {
        return this.divideAndRemainderBurnikelZiegler(other)[0];
    }

    private final CommonBigInteger remainderBurnikelZiegler(CommonBigInteger other) {
        return this.divideAndRemainderBurnikelZiegler(other)[1];
    }

    private final CommonBigInteger[] divideAndRemainderBurnikelZiegler(CommonBigInteger other) {
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger r = new MutableBigInteger(this).divideAndRemainderBurnikelZiegler(new MutableBigInteger(other), q);
        CommonBigInteger qBigInt = q.isZero() ? ZERO : q.toBigInteger(this._signum * other._signum);
        CommonBigInteger rBigInt = r.isZero() ? ZERO : r.toBigInteger(this._signum);
        CommonBigInteger[] commonBigIntegerArray = new CommonBigInteger[]{qBigInt, rBigInt};
        return commonBigIntegerArray;
    }

    @Override
    @NotNull
    public CommonBigInteger pow(int exponent) {
        if (exponent < 0) {
            throw new ArithmeticException("Negative exponent");
        }
        if (this._signum == 0) {
            return exponent == 0 ? ONE : this;
        }
        CommonBigInteger partToSquare = this.getAbsoluteValue();
        int powersOfTwo = partToSquare.getLowestSetBit();
        long bitsToShift = (long)powersOfTwo * (long)exponent;
        if (bitsToShift > Integer.MAX_VALUE) {
            CommonBigInteger.Companion.reportOverflow();
        }
        int remainingBits = 0;
        if (powersOfTwo > 0) {
            remainingBits = (partToSquare = partToSquare.shr(powersOfTwo)).getBitLength();
            if (remainingBits == 1) {
                return this._signum < 0 && (exponent & 1) == 1 ? NEGATIVE_ONE.shl(powersOfTwo * exponent) : ONE.shl(powersOfTwo * exponent);
            }
        } else {
            remainingBits = partToSquare.getBitLength();
            if (remainingBits == 1) {
                return this._signum < 0 && (exponent & 1) == 1 ? NEGATIVE_ONE : ONE;
            }
        }
        long scaleFactor = (long)remainingBits * (long)exponent;
        if (partToSquare._mag.length == 1 && scaleFactor <= 62L) {
            int newSign = this._signum < 0 && (exponent & 1) == 1 ? -1 : 1;
            long result = 1L;
            long baseToPow2 = (long)partToSquare._mag[0] & 0xFFFFFFFFL;
            int workingExponent = exponent;
            while (workingExponent != 0) {
                if ((workingExponent & 1) == 1) {
                    result *= baseToPow2;
                }
                if ((workingExponent >>>= 1) == 0) continue;
                baseToPow2 *= baseToPow2;
            }
            return powersOfTwo > 0 ? (bitsToShift + scaleFactor <= 62L ? Companion.of((result << (int)bitsToShift) * (long)newSign) : Companion.of(result * (long)newSign).shl((int)bitsToShift)) : Companion.of(result * (long)newSign);
        }
        CommonBigInteger answer = ONE;
        int workingExponent = exponent;
        while (workingExponent != 0) {
            if ((workingExponent & 1) == 1) {
                answer = answer.times(partToSquare);
            }
            if ((workingExponent >>>= 1) == 0) continue;
            partToSquare = partToSquare.square();
        }
        if (powersOfTwo > 0) {
            answer = answer.shl(powersOfTwo * exponent);
        }
        return this._signum < 0 && (exponent & 1) == 1 ? answer.unaryMinus() : answer;
    }

    @Override
    @NotNull
    public CommonBigInteger sqrt() {
        if (this._signum < 0) {
            throw new ArithmeticException("Negative BigInteger");
        }
        return new MutableBigInteger(this._mag).sqrt().toBigInteger();
    }

    @NotNull
    public CommonBigInteger[] sqrtAndRemainder() {
        CommonBigInteger s = this.sqrt();
        CommonBigInteger r = this.minus(s.square());
        if (!(r.compareTo(ZERO) >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        CommonBigInteger[] commonBigIntegerArray = new CommonBigInteger[]{s, r};
        return commonBigIntegerArray;
    }

    @Override
    @NotNull
    public CommonBigInteger gcd(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        BigInteger $this$castTo$iv = other;
        boolean $i$f$castTo = false;
        CommonBigInteger other2 = (CommonBigInteger)$this$castTo$iv;
        if (other2._signum == 0) {
            return this.getAbsoluteValue();
        }
        if (this._signum == 0) {
            return other2.getAbsoluteValue();
        }
        MutableBigInteger a = new MutableBigInteger(this);
        MutableBigInteger b = new MutableBigInteger(other2);
        MutableBigInteger result = a.hybridGCD(b);
        return result.toBigInteger(1);
    }

    @Override
    @NotNull
    public CommonBigInteger getAbsoluteValue() {
        return this._signum >= 0 ? this : this.unaryMinus();
    }

    @Override
    @NotNull
    public CommonBigInteger unaryMinus() {
        return new CommonBigInteger(this._mag, -this._signum);
    }

    @Override
    @NotNull
    public CommonBigInteger unaryPlus() {
        return this;
    }

    @Override
    public int getSignum() {
        return this._signum;
    }

    @Override
    @NotNull
    public CommonBigInteger rem(@NotNull BigInteger modulus) {
        Intrinsics.checkNotNullParameter((Object)modulus, (String)"modulus");
        BigInteger $this$castTo$iv = modulus;
        boolean $i$f$castTo = false;
        CommonBigInteger other = (CommonBigInteger)$this$castTo$iv;
        if (other._signum <= 0) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        CommonBigInteger result = this.remainder(other);
        return result._signum >= 0 ? result : result.plus(other);
    }

    @Override
    @NotNull
    public CommonBigInteger modPow(@NotNull BigInteger exponent, @NotNull BigInteger modulus) {
        boolean invertResult;
        Intrinsics.checkNotNullParameter((Object)exponent, (String)"exponent");
        Intrinsics.checkNotNullParameter((Object)modulus, (String)"modulus");
        BigInteger $this$castTo$iv = exponent;
        boolean $i$f$castTo = false;
        CommonBigInteger exponent2 = (CommonBigInteger)$this$castTo$iv;
        BigInteger $this$castTo$iv2 = modulus;
        boolean $i$f$castTo2 = false;
        CommonBigInteger modulus2 = (CommonBigInteger)$this$castTo$iv2;
        if (modulus2._signum <= 0) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        if (exponent2._signum == 0) {
            return Intrinsics.areEqual((Object)modulus2, (Object)ONE) ? ZERO : ONE;
        }
        if (Intrinsics.areEqual((Object)this, (Object)ONE)) {
            return Intrinsics.areEqual((Object)modulus2, (Object)ONE) ? ZERO : ONE;
        }
        if (Intrinsics.areEqual((Object)this, (Object)ZERO) && exponent2._signum >= 0) {
            return ZERO;
        }
        if (Intrinsics.areEqual((Object)this, (Object)negConst[1]) && !exponent2.testBit(0)) {
            return Intrinsics.areEqual((Object)modulus2, (Object)ONE) ? ZERO : ONE;
        }
        boolean bl = invertResult = exponent2._signum < 0;
        if (invertResult) {
            exponent2 = exponent2.unaryMinus();
        }
        CommonBigInteger base = this._signum < 0 || this.compareTo(modulus2) >= 0 ? this.rem(modulus2) : this;
        CommonBigInteger result = null;
        if (modulus2.testBit(0)) {
            result = base.oddModPow(exponent2, modulus2);
        } else {
            int p = modulus2.getLowestSetBit();
            CommonBigInteger m1 = modulus2.shr(p);
            CommonBigInteger m2 = ONE.shl(p);
            CommonBigInteger base2 = this._signum < 0 || this.compareTo(m1) >= 0 ? this.rem(m1) : this;
            CommonBigInteger a1 = Intrinsics.areEqual((Object)m1, (Object)ONE) ? ZERO : base2.oddModPow(exponent2, m1);
            CommonBigInteger a2 = base.modPow2(exponent2, p);
            CommonBigInteger y1 = m2.modInverse(m1);
            CommonBigInteger y2 = m1.modInverse(m2);
            if (modulus2._mag.length < 0x2000000) {
                result = a1.times(m2).times(y1).plus(a2.times(m1).times(y2)).rem(modulus2);
            } else {
                MutableBigInteger t1 = new MutableBigInteger();
                new MutableBigInteger(a1.times(m2)).multiply(new MutableBigInteger(y1), t1);
                MutableBigInteger t2 = new MutableBigInteger();
                new MutableBigInteger(a2.times(m1)).multiply(new MutableBigInteger(y2), t2);
                t1.add(t2);
                MutableBigInteger q = new MutableBigInteger();
                MutableBigInteger mutableBigInteger = MutableBigInteger.divide$default(t1, new MutableBigInteger(modulus2), q, false, 4, null);
                Intrinsics.checkNotNull((Object)mutableBigInteger);
                result = mutableBigInteger.toBigInteger();
            }
        }
        return invertResult ? result.modInverse(modulus2) : result;
    }

    /*
     * WARNING - void declaration
     */
    private final CommonBigInteger oddModPow(CommonBigInteger y, CommonBigInteger z) {
        MutableBigInteger r;
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        if (Intrinsics.areEqual((Object)y, (Object)ONE)) {
            return this;
        }
        if (this._signum == 0) {
            return ZERO;
        }
        int[] base = Utils.cloneArray(this._mag);
        int[] exp = y._mag;
        int[] mod = z._mag;
        int modLen = 0;
        modLen = mod.length;
        if ((modLen & 1) != 0) {
            int[] x = new int[modLen + 1];
            Utils.arrayCopy(mod, 0, x, 1, modLen);
            mod = x;
            int n = modLen;
            modLen = n + 1;
        }
        int wbits = 0;
        int ebits = CommonBigInteger.Companion.bitLength(exp, exp.length);
        if (ebits != 17 || exp[0] != 65537) {
            while (ebits > bnExpModThreshTable[wbits]) {
                ++wbits;
            }
        }
        int tblmask = 1 << wbits;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)tblmask);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new int[modLen]);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        int[][] table = (int[][])thisCollection$iv.toArray((T[])new int[0][]);
        long n0 = ((long)mod[modLen - 1] & 0xFFFFFFFFL) + (((long)mod[modLen - 2] & 0xFFFFFFFFL) << 32);
        long inv = -MutableBigInteger.Companion.inverseMod64(n0);
        int[] a = CommonBigInteger.Companion.leftShift(base, base.length, modLen << 5);
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger a2 = new MutableBigInteger(a);
        MutableBigInteger b2 = new MutableBigInteger(mod);
        b2.normalize();
        MutableBigInteger mutableBigInteger = r = MutableBigInteger.divide$default(a2, b2, q, false, 4, null);
        Intrinsics.checkNotNull((Object)mutableBigInteger);
        table[0] = mutableBigInteger.toIntArray();
        if (table[0].length < modLen) {
            int offset = modLen - table[0].length;
            int[] t2 = new int[modLen];
            Utils.arrayCopy(table[0], 0, t2, offset, table[0].length);
            table[0] = t2;
        }
        int[] b = CommonBigInteger.Companion.montgomerySquare(table[0], mod, modLen, inv, null);
        int[] nArray = Arrays.copyOf(b, modLen);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
        int[] t = nArray;
        for (int i = 1; i < tblmask; ++i) {
            table[i] = CommonBigInteger.Companion.montgomeryMultiply(t, table[i - 1], mod, modLen, inv, null);
        }
        int bitpos = 1 << (ebits - 1 & 0x1F);
        int buf = 0;
        int elen = exp.length;
        int eIndex = 0;
        int i = 0;
        int n = wbits;
        if (i <= n) {
            while (true) {
                buf = buf << 1 | ((exp[eIndex] & bitpos) != 0 ? 1 : 0);
                if ((bitpos >>>= 1) == 0) {
                    ++eIndex;
                    bitpos = Integer.MIN_VALUE;
                    --elen;
                }
                if (i == n) break;
                ++i;
            }
        }
        int multpos = ebits--;
        boolean isone = true;
        multpos = ebits - wbits;
        while ((buf & 1) == 0) {
            buf >>>= 1;
            ++multpos;
        }
        int[] mult = table[buf >>> 1];
        buf = 0;
        if (multpos == ebits) {
            isone = false;
        }
        while (true) {
            --ebits;
            buf <<= 1;
            if (elen != 0) {
                buf |= (exp[eIndex] & bitpos) != 0 ? 1 : 0;
                if ((bitpos >>>= 1) == 0) {
                    ++eIndex;
                    bitpos = Integer.MIN_VALUE;
                    --elen;
                }
            }
            if ((buf & tblmask) != 0) {
                multpos = ebits - wbits;
                while ((buf & 1) == 0) {
                    buf >>>= 1;
                    ++multpos;
                }
                mult = table[buf >>> 1];
                buf = 0;
            }
            if (ebits == multpos) {
                if (isone) {
                    b = Utils.cloneArray(mult);
                    isone = false;
                } else {
                    t = b;
                    a = CommonBigInteger.Companion.montgomeryMultiply(t, mult, mod, modLen, inv, a);
                    t = a;
                    a = b;
                    b = t;
                }
            }
            if (ebits == 0) break;
            if (isone) continue;
            t = b;
            a = CommonBigInteger.Companion.montgomerySquare(t, mod, modLen, inv, a);
            t = a;
            a = b;
            b = t;
        }
        int[] t2 = new int[2 * modLen];
        Utils.arrayCopy(b, 0, t2, modLen, modLen);
        b = CommonBigInteger.Companion.montReduce(t2, mod, modLen, (int)inv);
        int[] nArray2 = Arrays.copyOf(b, modLen);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        t2 = nArray2;
        return new CommonBigInteger(1, t2);
    }

    private final CommonBigInteger modPow2(CommonBigInteger exponent, int p) {
        CommonBigInteger result = ONE;
        CommonBigInteger baseToPow2 = this.mod2(p);
        int expOffset = 0;
        int limit = exponent.getBitLength();
        if (this.testBit(0)) {
            int n = limit = p - 1 < limit ? p - 1 : limit;
        }
        while (expOffset < limit) {
            if (exponent.testBit(expOffset)) {
                result = result.times(baseToPow2).mod2(p);
            }
            if (++expOffset >= limit) continue;
            baseToPow2 = baseToPow2.square().mod2(p);
        }
        return result;
    }

    private final CommonBigInteger mod2(int p) {
        if (this.getBitLength() <= p) {
            return this;
        }
        int numInts = p + 31 >>> 5;
        int[] mag = new int[numInts];
        Utils.arrayCopy(this._mag, this._mag.length - numInts, mag, 0, numInts);
        int excessBits = (numInts << 5) - p;
        mag[0] = mag[0] & (int)((1L << 32 - excessBits) - 1L);
        return mag[0] == 0 ? new CommonBigInteger(1, mag) : new CommonBigInteger(mag, 1);
    }

    @Override
    @NotNull
    public CommonBigInteger modInverse(@NotNull BigInteger modulus) {
        MutableBigInteger result;
        Intrinsics.checkNotNullParameter((Object)modulus, (String)"modulus");
        BigInteger $this$castTo$iv = modulus;
        boolean $i$f$castTo = false;
        CommonBigInteger modulus2 = (CommonBigInteger)$this$castTo$iv;
        if (modulus2._signum != 1) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        if (Intrinsics.areEqual((Object)modulus2, (Object)ONE)) {
            return ZERO;
        }
        CommonBigInteger modVal = this;
        if (this._signum < 0 || this.compareMagnitude$macrofocus_common(modulus2) >= 0) {
            modVal = this.rem(modulus2);
        }
        if (Intrinsics.areEqual((Object)modVal, (Object)ONE)) {
            return ONE;
        }
        MutableBigInteger a = new MutableBigInteger(modVal);
        MutableBigInteger b = new MutableBigInteger(modulus2);
        MutableBigInteger mutableBigInteger = result = a.mutableModInverse(b);
        Intrinsics.checkNotNull((Object)mutableBigInteger);
        return mutableBigInteger.toBigInteger(1);
    }

    @Override
    @NotNull
    public CommonBigInteger shl(int n) {
        if (this._signum == 0) {
            return ZERO;
        }
        return n > 0 ? new CommonBigInteger(CommonBigInteger.Companion.shl(this._mag, n), this._signum) : (n == 0 ? this : this.shiftRightImpl(-n));
    }

    @Override
    @NotNull
    public CommonBigInteger shr(int n) {
        if (this._signum == 0) {
            return ZERO;
        }
        return n > 0 ? this.shiftRightImpl(n) : (n == 0 ? this : new CommonBigInteger(CommonBigInteger.Companion.shl(this._mag, -n), this._signum));
    }

    private final CommonBigInteger shiftRightImpl(int n) {
        int nInts = n >>> 5;
        int nBits = n & 0x1F;
        int magLen = this._mag.length;
        int[] newMag = null;
        if (nInts >= magLen) {
            CommonBigInteger commonBigInteger;
            if (this._signum >= 0) {
                commonBigInteger = ZERO;
            } else {
                commonBigInteger = negConst[1];
                if (commonBigInteger == null) {
                    throw new IllegalStateException();
                }
            }
            return commonBigInteger;
        }
        if (nBits == 0) {
            int newMagLen = magLen - nInts;
            int[] nArray = Arrays.copyOf(this._mag, newMagLen);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            newMag = nArray;
        } else {
            int i = 0;
            int highBits = this._mag[0] >>> nBits;
            if (highBits != 0) {
                newMag = new int[magLen - nInts];
                newMag[i++] = highBits;
            } else {
                newMag = new int[magLen - nInts - 1];
            }
            int nBits2 = 32 - nBits;
            int j = 0;
            while (j < magLen - nInts - 1) {
                newMag[i++] = this._mag[j++] << nBits2 | this._mag[j] >>> nBits;
            }
        }
        if (this._signum < 0) {
            boolean onesLost = false;
            int j = magLen - nInts;
            for (int i = magLen - 1; i >= j && !onesLost; --i) {
                onesLost = this._mag[i] != 0;
            }
            if (!onesLost && nBits != 0) {
                boolean bl = onesLost = this._mag[magLen - nInts - 1] << 32 - nBits != 0;
            }
            if (onesLost) {
                newMag = this.javaIncrement(newMag);
            }
        }
        return new CommonBigInteger(newMag, this._signum);
    }

    private final int[] javaIncrement(int[] other) {
        int[] result = other;
        int lastSum = 0;
        int i = result.length - 1;
        while (i >= 0 && lastSum == 0) {
            int[] nArray = result;
            int n = i--;
            int n2 = nArray[n];
            nArray[n] = n2 + 1;
            lastSum = n2;
        }
        if (lastSum == 0) {
            result = new int[result.length + 1];
            result[0] = 1;
        }
        return result;
    }

    @Override
    @NotNull
    public CommonBigInteger and(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        BigInteger $this$castTo$iv = other;
        boolean $i$f$castTo = false;
        CommonBigInteger other2 = (CommonBigInteger)$this$castTo$iv;
        int[] result = new int[Math.max(this.getIntLength(), other2.getIntLength())];
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            result[i] = this.getInt(result.length - i - 1) & other2.getInt(result.length - i - 1);
        }
        return Companion.of(result);
    }

    @Override
    @NotNull
    public CommonBigInteger or(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        BigInteger $this$castTo$iv = other;
        boolean $i$f$castTo = false;
        CommonBigInteger other2 = (CommonBigInteger)$this$castTo$iv;
        int[] result = new int[Math.max(this.getIntLength(), other2.getIntLength())];
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            result[i] = this.getInt(result.length - i - 1) | other2.getInt(result.length - i - 1);
        }
        return Companion.of(result);
    }

    @Override
    @NotNull
    public CommonBigInteger xor(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        BigInteger $this$castTo$iv = other;
        boolean $i$f$castTo = false;
        CommonBigInteger other2 = (CommonBigInteger)$this$castTo$iv;
        int[] result = new int[Math.max(this.getIntLength(), other2.getIntLength())];
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            result[i] = this.getInt(result.length - i - 1) ^ other2.getInt(result.length - i - 1);
        }
        return Companion.of(result);
    }

    @Override
    @NotNull
    public CommonBigInteger not() {
        int[] result = new int[this.getIntLength()];
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            result[i] = ~this.getInt(result.length - i - 1);
        }
        return Companion.of(result);
    }

    @Override
    @NotNull
    public CommonBigInteger andNot(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        BigInteger $this$castTo$iv = other;
        boolean $i$f$castTo = false;
        CommonBigInteger other2 = (CommonBigInteger)$this$castTo$iv;
        int[] result = new int[Math.max(this.getIntLength(), other2.getIntLength())];
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            result[i] = this.getInt(result.length - i - 1) & ~other2.getInt(result.length - i - 1);
        }
        return Companion.of(result);
    }

    @Override
    public boolean testBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        return (this.getInt(n >>> 5) & 1 << (n & 0x1F)) != 0;
    }

    @Override
    public boolean get(int n) {
        return this.testBit(n);
    }

    @Override
    @NotNull
    public CommonBigInteger set(int n, boolean b) {
        return b ? this.setBit(n) : this.clearBit(n);
    }

    @Override
    @NotNull
    public CommonBigInteger setBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int intNum = n >>> 5;
        int[] result = new int[Math.max(this.getIntLength(), intNum + 2)];
        int n2 = result.length;
        for (int i = 0; i < n2; ++i) {
            result[result.length - i - 1] = this.getInt(i);
        }
        result[result.length - intNum - 1] = result[result.length - intNum - 1] | 1 << (n & 0x1F);
        return Companion.of(result);
    }

    @Override
    @NotNull
    public CommonBigInteger clearBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int intNum = n >>> 5;
        int[] result = new int[Math.max(this.getIntLength(), (n + 1 >>> 5) + 1)];
        int n2 = result.length;
        for (int i = 0; i < n2; ++i) {
            result[result.length - i - 1] = this.getInt(i);
        }
        result[result.length - intNum - 1] = result[result.length - intNum - 1] & ~(1 << (n & 0x1F));
        return Companion.of(result);
    }

    @Override
    @NotNull
    public CommonBigInteger flipBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int intNum = n >>> 5;
        int[] result = new int[Math.max(this.getIntLength(), intNum + 2)];
        int n2 = result.length;
        for (int i = 0; i < n2; ++i) {
            result[result.length - i - 1] = this.getInt(i);
        }
        result[result.length - intNum - 1] = result[result.length - intNum - 1] ^ 1 << (n & 0x1F);
        return Companion.of(result);
    }

    @Override
    public int getBitLength() {
        int n = this._bitLengthPlusOne - 1;
        if (n == -1) {
            int[] m = this._mag;
            int len = m.length;
            if (len == 0) {
                n = 0;
            } else {
                int magBitLength = (len - 1 << 5) + Companion.bitLengthForInt$macrofocus_common(this._mag[0]);
                if (this._signum < 0) {
                    boolean pow2 = Utils.bitCount(this._mag[0]) == 1;
                    for (int i = 1; i < len && pow2; ++i) {
                        pow2 = this._mag[i] == 0;
                    }
                    n = pow2 ? magBitLength - 1 : magBitLength;
                } else {
                    n = magBitLength;
                }
            }
            this._bitLengthPlusOne = n + 1;
        }
        return n;
    }

    @Override
    public int getBitCount() {
        int bc = this._bitCountPlusOne - 1;
        if (bc == -1) {
            bc = 0;
            int n = this._mag.length;
            for (int i = 0; i < n; ++i) {
                bc += Utils.bitCount(this._mag[i]);
            }
            if (this._signum < 0) {
                int magTrailingZeroCount = 0;
                int j = 0;
                j = this._mag.length - 1;
                while (this._mag[j] == 0) {
                    magTrailingZeroCount += 32;
                    --j;
                }
                bc += (magTrailingZeroCount += Utils.numberOfTrailingZeros(this._mag[j])) - 1;
            }
            this._bitCountPlusOne = bc + 1;
        }
        return bc;
    }

    @Override
    public boolean isProbablePrime(int certainty) {
        if (certainty <= 0) {
            return true;
        }
        CommonBigInteger w = this.getAbsoluteValue();
        if (Intrinsics.areEqual((Object)w, (Object)TWO)) {
            return true;
        }
        return !w.testBit(0) || Intrinsics.areEqual((Object)w, (Object)ONE) ? false : w.primeToCertainty$macrofocus_common(certainty, null);
    }

    @Override
    public int compareTo(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        BigInteger $this$castTo$iv = other;
        boolean $i$f$castTo = false;
        CommonBigInteger other2 = (CommonBigInteger)$this$castTo$iv;
        if (this._signum == other2._signum) {
            switch (this._signum) {
                case 1: {
                    return this.compareMagnitude$macrofocus_common(other2);
                }
                case -1: {
                    return other2.compareMagnitude$macrofocus_common(this);
                }
            }
            return 0;
        }
        return this._signum > other2._signum ? 1 : -1;
    }

    public final int compareMagnitude$macrofocus_common(@NotNull CommonBigInteger other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int[] m1 = this._mag;
        int len1 = m1.length;
        int[] m2 = other._mag;
        int len2 = m2.length;
        if (len1 < len2) {
            return -1;
        }
        if (len1 > len2) {
            return 1;
        }
        for (int i = 0; i < len1; ++i) {
            int a = m1[i];
            int b = m2[i];
            if (a == b) continue;
            return ((long)a & 0xFFFFFFFFL) < ((long)b & 0xFFFFFFFFL) ? -1 : 1;
        }
        return 0;
    }

    private final int compareMagnitude(long other) {
        int highWord;
        long other2 = other;
        if (!(other2 != Long.MIN_VALUE)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int[] m1 = this._mag;
        int len = m1.length;
        if (len > 2) {
            return 1;
        }
        if (other2 < 0L) {
            other2 = -other2;
        }
        if ((highWord = (int)(other2 >>> 32)) == 0) {
            if (len < 1) {
                return -1;
            }
            if (len > 1) {
                return 1;
            }
            int a = m1[0];
            int b = (int)other2;
            return a != b ? (((long)a & 0xFFFFFFFFL) < ((long)b & 0xFFFFFFFFL) ? -1 : 1) : 0;
        }
        if (len < 2) {
            return -1;
        }
        int a = m1[0];
        int b = highWord;
        if (a != b) {
            return ((long)a & 0xFFFFFFFFL) < ((long)b & 0xFFFFFFFFL) ? -1 : 1;
        }
        a = m1[1];
        b = (int)other2;
        return a != b ? (((long)a & 0xFFFFFFFFL) < ((long)b & 0xFFFFFFFFL) ? -1 : 1) : 0;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CommonBigInteger)) {
            return false;
        }
        CommonBigInteger xInt = (CommonBigInteger)other;
        if (xInt._signum != this._signum) {
            return false;
        }
        int[] m = this._mag;
        int len = m.length;
        int[] xm = xInt._mag;
        if (len != xm.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (xm[i] == m[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public BigInteger min(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) < 0 ? (BigInteger)this : other;
    }

    @Override
    @NotNull
    public BigInteger max(@NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) > 0 ? (BigInteger)this : other;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int n = this._mag.length;
        for (int i = 0; i < n; ++i) {
            hashCode = 31 * hashCode + (int)((long)this._mag[i] & 0xFFFFFFFFL);
        }
        return hashCode * this._signum;
    }

    @Override
    @NotNull
    public String toString(int radix) {
        int radix2 = radix;
        if (this._signum == 0) {
            return "0";
        }
        if (radix2 < 2 || radix2 > 36) {
            radix2 = 10;
        }
        if (this._mag.length <= 20) {
            return this.smallToString(radix2);
        }
        StringBuilder sb = new StringBuilder();
        if (this._signum < 0) {
            CommonBigInteger.Companion.toString(this.unaryMinus(), sb, radix2, 0);
            sb = Utils.insertChar(sb, 0, '-');
        } else {
            CommonBigInteger.Companion.toString(this, sb, radix2, 0);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String smallToString(int radix) {
        if (this._signum == 0) {
            return "0";
        }
        int maxNumDigitGroups = (4 * this._mag.length + 6) / 7;
        String[] digitGroup = new String[maxNumDigitGroups];
        CommonBigInteger tmp = this.getAbsoluteValue();
        int numGroups = 0;
        while (tmp._signum != 0) {
            CommonBigInteger d = longRadix[radix];
            MutableBigInteger q = new MutableBigInteger();
            MutableBigInteger a = new MutableBigInteger(tmp._mag);
            CommonBigInteger commonBigInteger = d;
            Intrinsics.checkNotNull((Object)commonBigInteger);
            MutableBigInteger b = new MutableBigInteger(commonBigInteger._mag);
            MutableBigInteger r = MutableBigInteger.divide$default(a, b, q, false, 4, null);
            CommonBigInteger q2 = q.toBigInteger(tmp._signum * d._signum);
            MutableBigInteger mutableBigInteger = r;
            Intrinsics.checkNotNull((Object)mutableBigInteger);
            CommonBigInteger r2 = mutableBigInteger.toBigInteger(tmp._signum * d._signum);
            int n = numGroups++;
            String string = Long.toString(r2.toLong(), CharsKt.checkRadix((int)radix));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            digitGroup[n] = string;
            tmp = q2;
        }
        StringBuilder buf = new StringBuilder(numGroups * digitsPerLong[radix] + 1);
        if (this._signum < 0) {
            buf.append('-');
        }
        buf.append(digitGroup[numGroups - 1]);
        for (int i = numGroups - 2; -1 < i; --i) {
            int n = digitsPerLong[radix];
            String string = digitGroup[i];
            Intrinsics.checkNotNull((Object)string);
            int numLeadingZeros = n - string.length();
            if (numLeadingZeros != 0) {
                buf.append(zeros[numLeadingZeros]);
            }
            buf.append(digitGroup[i]);
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public String toString() {
        return this.toString(10);
    }

    @Override
    @NotNull
    public byte[] toByteArray() {
        int byteLen = this.getBitLength() / 8 + 1;
        byte[] byteArray = new byte[byteLen];
        int bytesCopied = 4;
        int nextInt = 0;
        int intIndex = 0;
        for (int i = byteLen - 1; i >= 0; --i) {
            if (bytesCopied == 4) {
                nextInt = this.getInt(intIndex++);
                bytesCopied = 1;
            } else {
                nextInt >>>= 8;
                ++bytesCopied;
            }
            byteArray[i] = (byte)nextInt;
        }
        return byteArray;
    }

    @Override
    public int toInt() {
        int result = 0;
        result = this.getInt(0);
        return result;
    }

    @Override
    public long toLong() {
        long result = 0L;
        for (int i = 1; -1 < i; --i) {
            result = (result << 32) + ((long)this.getInt(i) & 0xFFFFFFFFL);
        }
        return result;
    }

    @Override
    public byte toByte() {
        return (byte)this.toInt();
    }

    @Override
    public char toChar() {
        return (char)this.toInt();
    }

    @Override
    public short toShort() {
        return (short)this.toInt();
    }

    @Override
    public float toFloat() {
        return this.toInt();
    }

    @Override
    public double toDouble() {
        return this.toLong();
    }

    private final int getIntLength() {
        return (this.getBitLength() >>> 5) + 1;
    }

    private final int getSignBit() {
        return this._signum < 0 ? 1 : 0;
    }

    private final int getSignInt() {
        return this._signum < 0 ? -1 : 0;
    }

    private final int getInt(int n) {
        if (n < 0) {
            return 0;
        }
        if (n >= this._mag.length) {
            return this.getSignInt();
        }
        int magInt = this._mag[this._mag.length - n - 1];
        return this._signum >= 0 ? magInt : (n <= this.firstNonzeroIntNum() ? -magInt : ~magInt);
    }

    private final int firstNonzeroIntNum() {
        int fn = this._firstNonzeroIntNumPlusTwo - 2;
        if (fn == -2) {
            int i = 0;
            int mlen = this._mag.length;
            for (i = mlen - 1; i >= 0 && this._mag[i] == 0; --i) {
            }
            fn = mlen - i - 1;
            this._firstNonzeroIntNumPlusTwo = fn + 2;
        }
        return fn;
    }

    private final byte[] magSerializedForm() {
        int len = this._mag.length;
        int bitLen = len == 0 ? 0 : (len - 1 << 5) + Companion.bitLengthForInt$macrofocus_common(this._mag[0]);
        int byteLen = bitLen + 7 >>> 3;
        byte[] result = new byte[byteLen];
        int bytesCopied = 4;
        int intIndex = len - 1;
        int nextInt = 0;
        for (int i = byteLen - 1; i >= 0; --i) {
            if (bytesCopied == 4) {
                nextInt = this._mag[intIndex--];
                bytesCopied = 1;
            } else {
                nextInt >>>= 8;
                ++bytesCopied;
            }
            result[i] = (byte)nextInt;
        }
        return result;
    }

    @Override
    public long toLongExact() {
        if (this._mag.length > 2 || this.getBitLength() > 63) {
            throw new ArithmeticException("BigInteger out of long range");
        }
        return this.toLong();
    }

    @Override
    public int toIntExact() {
        if (this._mag.length > 1 || this.getBitLength() > 31) {
            throw new ArithmeticException("BigInteger out of int range");
        }
        return this.toInt();
    }

    @Override
    public short toShortExact() {
        int value;
        if (this._mag.length <= 1 && this.getBitLength() <= 31 && (value = this.toInt()) >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            return this.toShort();
        }
        throw new ArithmeticException("BigInteger out of short range");
    }

    @Override
    public byte toByteExact() {
        int value;
        if (this._mag.length <= 1 && this.getBitLength() <= 31 && (value = this.toInt()) >= -128 && value <= 127) {
            return this.toByte();
        }
        throw new ArithmeticException("BigInteger out of byte range");
    }

    @Override
    @NotNull
    public BigIntegerRange rangeTo(@NotNull BigInteger endInclusive) {
        return BigInteger.super.rangeTo(endInclusive);
    }

    @Override
    @NotNull
    public BigIntegerRange rangeTo(int endInclusive) {
        return BigInteger.super.rangeTo(endInclusive);
    }

    @Override
    @NotNull
    public BigIntegerRange rangeTo(long endInclusive) {
        return BigInteger.super.rangeTo(endInclusive);
    }

    @Override
    @NotNull
    public BigInteger plus(int other) {
        return BigInteger.super.plus(other);
    }

    @Override
    @NotNull
    public BigInteger plus(long other) {
        return BigInteger.super.plus(other);
    }

    @Override
    @NotNull
    public BigInteger minus(int other) {
        return BigInteger.super.minus(other);
    }

    @Override
    @NotNull
    public BigInteger minus(long other) {
        return BigInteger.super.minus(other);
    }

    @Override
    @NotNull
    public BigInteger times(int other) {
        return BigInteger.super.times(other);
    }

    @Override
    @NotNull
    public BigInteger times(long other) {
        return BigInteger.super.times(other);
    }

    @Override
    @NotNull
    public BigInteger div(int other) {
        return BigInteger.super.div(other);
    }

    @Override
    @NotNull
    public BigInteger div(long other) {
        return BigInteger.super.div(other);
    }

    @Override
    @NotNull
    public BigInteger[] divideAndRemainder(int other) {
        return BigInteger.super.divideAndRemainder(other);
    }

    @Override
    @NotNull
    public BigInteger[] divideAndRemainder(long other) {
        return BigInteger.super.divideAndRemainder(other);
    }

    @Override
    @NotNull
    public BigInteger remainder(int other) {
        return BigInteger.super.remainder(other);
    }

    @Override
    @NotNull
    public BigInteger remainder(long other) {
        return BigInteger.super.remainder(other);
    }

    @Override
    @NotNull
    public BigInteger gcd(int other) {
        return BigInteger.super.gcd(other);
    }

    @Override
    @NotNull
    public BigInteger gcd(long other) {
        return BigInteger.super.gcd(other);
    }

    @Override
    @NotNull
    public BigInteger rem(int modulus) {
        return BigInteger.super.rem(modulus);
    }

    @Override
    @NotNull
    public BigInteger rem(long modulus) {
        return BigInteger.super.rem(modulus);
    }

    @Override
    @NotNull
    public BigInteger modInverse(int modulus) {
        return BigInteger.super.modInverse(modulus);
    }

    @Override
    @NotNull
    public BigInteger modInverse(long modulus) {
        return BigInteger.super.modInverse(modulus);
    }

    @Override
    @NotNull
    public BigInteger and(int other) {
        return BigInteger.super.and(other);
    }

    @Override
    @NotNull
    public BigInteger and(long other) {
        return BigInteger.super.and(other);
    }

    @Override
    @NotNull
    public BigInteger or(int other) {
        return BigInteger.super.or(other);
    }

    @Override
    @NotNull
    public BigInteger or(long other) {
        return BigInteger.super.or(other);
    }

    @Override
    @NotNull
    public BigInteger xor(int other) {
        return BigInteger.super.xor(other);
    }

    @Override
    @NotNull
    public BigInteger xor(long other) {
        return BigInteger.super.xor(other);
    }

    @Override
    @NotNull
    public BigInteger andNot(int other) {
        return BigInteger.super.andNot(other);
    }

    @Override
    @NotNull
    public BigInteger andNot(long other) {
        return BigInteger.super.andNot(other);
    }

    @JvmStatic
    @NotNull
    public static final CommonBigInteger probablePrime(int bitLength, @NotNull Random rnd) {
        return Companion.probablePrime(bitLength, rnd);
    }

    @JvmStatic
    @NotNull
    public static final CommonBigInteger of(long other) {
        return Companion.of(other);
    }

    @JvmStatic
    @NotNull
    public static final CommonBigInteger of(int value) {
        return Companion.of(value);
    }

    @JvmStatic
    @NotNull
    public static final CommonBigInteger of(@NotNull String value) {
        return Companion.of(value);
    }

    @JvmStatic
    @NotNull
    public static final CommonBigInteger of(@NotNull String value, int radix) {
        return Companion.of(value, radix);
    }

    @JvmStatic
    @NotNull
    public static final CommonBigInteger of(@NotNull int[] other) {
        return Companion.of(other);
    }

    public static final /* synthetic */ CommonBigInteger access$getSMALL_PRIME_PRODUCT$cp() {
        return SMALL_PRIME_PRODUCT;
    }

    public /* synthetic */ CommonBigInteger(long other, DefaultConstructorMarker $constructor_marker) {
        this(other);
    }

    public /* synthetic */ CommonBigInteger(int[] other, DefaultConstructorMarker $constructor_marker) {
        this(other);
    }

    static {
        long[] lArray = new long[]{0L, 0L, 1024L, 1624L, 2048L, 2378L, 2648L, 2875L, 3072L, 3247L, 3402L, 3543L, 3672L, 3790L, 3899L, 4001L, 4096L, 4186L, 4271L, 4350L, 4426L, 4498L, 4567L, 4633L, 4696L, 4756L, 4814L, 4870L, 4923L, 4975L, 5025L, 5074L, 5120L, 5166L, 5210L, 5253L, 5295L};
        bitsPerDigit = lArray;
        SMALL_PRIME_PRODUCT = Companion.of(152125131763605L);
        MAX_CONSTANT = 16;
        posConst = new CommonBigInteger[MAX_CONSTANT + 1];
        negConst = new CommonBigInteger[MAX_CONSTANT + 1];
        powerCache = new CommonBigInteger[0][];
        LOG_TWO = Math.log(2.0);
        int i = 1;
        int n = MAX_CONSTANT;
        if (i <= n) {
            do {
                int[] magnitude = new int[]{++i};
                CommonBigInteger.posConst[i] = new CommonBigInteger(magnitude, 1);
                CommonBigInteger.negConst[i] = new CommonBigInteger(magnitude, -1);
            } while (i != n);
        }
        powerCache = new CommonBigInteger[37][];
        logCache = new double[37];
        for (i = 2; i < 37; ++i) {
            CommonBigInteger[] commonBigIntegerArray = new CommonBigInteger[]{Companion.of((long)i)};
            CommonBigInteger.powerCache[i] = commonBigIntegerArray;
            CommonBigInteger.logCache[i] = Math.log(i);
        }
        ZERO = new CommonBigInteger(new int[0], 0);
        ONE = Companion.of(1);
        TWO = Companion.of(2);
        NEGATIVE_ONE = Companion.of(-1);
        TEN = Companion.of(10);
        int[] i2 = new int[]{7, 25, 81, 241, 673, 1793, Integer.MAX_VALUE};
        bnExpModThreshTable = i2;
        zeros = new String[64];
        CommonBigInteger.zeros[63] = "000000000000000000000000000000000000000000000000000000000000000";
        for (i = 0; i < 63; ++i) {
            String string = zeros[63];
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNullExpressionValue((Object)string.substring(0, i), (String)"substring(...)");
        }
        Object[] objectArray = new int[]{0, 0, 62, 39, 31, 27, 24, 22, 20, 19, 18, 18, 17, 17, 16, 16, 15, 15, 15, 14, 14, 14, 14, 13, 13, 13, 13, 13, 13, 12, 12, 12, 12, 12, 12, 12, 12};
        digitsPerLong = objectArray;
        objectArray = new CommonBigInteger[37];
        objectArray[0] = (int)null;
        objectArray[1] = (int)null;
        objectArray[2] = (int)Companion.of(0x4000000000000000L);
        objectArray[3] = (int)Companion.of(4052555153018976267L);
        objectArray[4] = (int)Companion.of(0x4000000000000000L);
        objectArray[5] = (int)Companion.of(7450580596923828125L);
        objectArray[6] = (int)Companion.of(4738381338321616896L);
        objectArray[7] = (int)Companion.of(3909821048582988049L);
        objectArray[8] = (int)Companion.of(0x1000000000000000L);
        objectArray[9] = (int)Companion.of(1350851717672992089L);
        objectArray[10] = (int)Companion.of(1000000000000000000L);
        objectArray[11] = (int)Companion.of(5559917313492231481L);
        objectArray[12] = (int)Companion.of(2218611106740436992L);
        objectArray[13] = (int)Companion.of(8650415919381337933L);
        objectArray[14] = (int)Companion.of(2177953337809371136L);
        objectArray[15] = (int)Companion.of(6568408355712890625L);
        objectArray[16] = (int)Companion.of(0x1000000000000000L);
        objectArray[17] = (int)Companion.of(2862423051509815793L);
        objectArray[18] = (int)Companion.of(6746640616477458432L);
        objectArray[19] = (int)Companion.of(799006685782884121L);
        objectArray[20] = (int)Companion.of(1638400000000000000L);
        objectArray[21] = (int)Companion.of(3243919932521508681L);
        objectArray[22] = (int)Companion.of(6221821273427820544L);
        objectArray[23] = (int)Companion.of(504036361936467383L);
        objectArray[24] = (int)Companion.of(876488338465357824L);
        objectArray[25] = (int)Companion.of(1490116119384765625L);
        objectArray[26] = (int)Companion.of(2481152873203736576L);
        objectArray[27] = (int)Companion.of(4052555153018976267L);
        objectArray[28] = (int)Companion.of(6502111422497947648L);
        objectArray[29] = (int)Companion.of(353814783205469041L);
        objectArray[30] = (int)Companion.of(531441000000000000L);
        objectArray[31] = (int)Companion.of(787662783788549761L);
        objectArray[32] = (int)Companion.of(0x1000000000000000L);
        objectArray[33] = (int)Companion.of(1667889514952984961L);
        objectArray[34] = (int)Companion.of(2386420683693101056L);
        objectArray[35] = (int)Companion.of(3379220508056640625L);
        objectArray[36] = (int)Companion.of(4738381338321616896L);
        longRadix = (CommonBigInteger[])objectArray;
        objectArray = new int[]{0, 0, 30, 19, 15, 13, 11, 11, 10, 9, 9, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5};
        digitsPerInt = objectArray;
        objectArray = new int[]{0, 0, 0x40000000, 1162261467, 0x40000000, 1220703125, 362797056, 1977326743, 0x40000000, 387420489, 1000000000, 214358881, 429981696, 815730721, 1475789056, 170859375, 0x10000000, 410338673, 612220032, 893871739, 1280000000, 1801088541, 113379904, 148035889, 191102976, 244140625, 308915776, 387420489, 481890304, 594823321, 729000000, 887503681, 0x40000000, 1291467969, 1544804416, 1838265625, 60466176};
        intRadix = objectArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0006\n\u0002\bF\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J \u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010(\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007H\u0002J\u0018\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\"H\u0002J \u0010,\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\"2\u0006\u0010+\u001a\u00020\"H\u0002J\b\u0010.\u001a\u00020\u0015H\u0002J\u0010\u0010/\u001a\u00020\"2\u0006\u00100\u001a\u00020\u0005H\u0007J\u0010\u0010/\u001a\u00020\"2\u0006\u00101\u001a\u00020\u0007H\u0007J\u0010\u0010/\u001a\u00020\"2\u0006\u00101\u001a\u000202H\u0007J\u0018\u0010/\u001a\u00020\"2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0007H\u0007J\u0010\u0010/\u001a\u00020\"2\u0006\u00100\u001a\u00020\u0017H\u0007J\u0018\u0010I\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00100\u001a\u00020\u0005H\u0002J\u0018\u0010I\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0018\u0010J\u001a\u00020\u00172\u0006\u00100\u001a\u00020\u00052\u0006\u0010K\u001a\u00020\u0017H\u0002J\u0018\u0010J\u001a\u00020\u00172\u0006\u0010L\u001a\u00020\u00172\u0006\u00100\u001a\u00020\u0005H\u0002J\u0018\u0010J\u001a\u00020\u00172\u0006\u0010L\u001a\u00020\u00172\u0006\u0010K\u001a\u00020\u0017H\u0002J \u0010M\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010N\u001a\u00020\u0007H\u0002J2\u0010O\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010P\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010Q\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u0017H\u0002J2\u0010R\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010P\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010Q\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u0017H\u0002J\u0018\u0010S\u001a\u00020\u00152\u0006\u0010T\u001a\u00020\u00172\u0006\u0010U\u001a\u00020\u0007H\u0002J\u0018\u0010V\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\"H\u0002J\u0018\u0010W\u001a\u00020\"2\u0006\u0010X\u001a\u00020\"2\u0006\u0010Y\u001a\u00020\"H\u0002J\"\u0010Z\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010[\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u0017H\u0002J(\u0010\\\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010[\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010]\u001a\u00020\u0007H\u0002J(\u0010^\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010[\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010]\u001a\u00020\u0007H\u0002J\u0015\u0010_\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b`J \u0010a\u001a\u00020\u00172\u0006\u0010X\u001a\u00020\u00172\u0006\u0010[\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0007H\u0002J \u0010b\u001a\u00020\u00152\u0006\u0010X\u001a\u00020\u00172\u0006\u0010[\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0007H\u0002J \u0010c\u001a\u00020\u00152\u0006\u0010X\u001a\u00020\u00172\u0006\u0010[\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0007H\u0002J\u0018\u0010#\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u00172\u0006\u0010[\u001a\u00020\u0007H\u0002J:\u0010d\u001a\u00020\u00172\u0006\u0010X\u001a\u00020\u00172\u0006\u0010Y\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00172\u0006\u0010[\u001a\u00020\u00072\u0006\u0010e\u001a\u00020\u00052\b\u0010f\u001a\u0004\u0018\u00010\u0017H\u0002J2\u0010g\u001a\u00020\u00172\u0006\u0010X\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00172\u0006\u0010[\u001a\u00020\u00072\u0006\u0010e\u001a\u00020\u00052\b\u0010f\u001a\u0004\u0018\u00010\u0017H\u0002J2\u0010h\u001a\u00020\u00152\u0006\u0010X\u001a\u00020\u00172\u0006\u0010Y\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00172\u0006\u0010[\u001a\u00020\u00072\b\u0010f\u001a\u0004\u0018\u00010\u0017H\u0002J\u001a\u0010i\u001a\u00020\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u00172\u0006\u0010[\u001a\u00020\u0007H\u0002J8\u0010j\u001a\u00020\u00172\u0006\u0010X\u001a\u00020\u00172\u0006\u0010Y\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00172\u0006\u0010[\u001a\u00020\u00072\u0006\u0010e\u001a\u00020\u00052\u0006\u0010f\u001a\u00020\u0017H\u0002J0\u0010k\u001a\u00020\u00172\u0006\u0010X\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00172\u0006\u0010[\u001a\u00020\u00072\u0006\u0010e\u001a\u00020\u00052\u0006\u0010f\u001a\u00020\u0017H\u0002J(\u0010q\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00172\u0006\u0010r\u001a\u00020\u00172\u0006\u0010s\u001a\u00020\u00072\u0006\u0010e\u001a\u00020\u0007H\u0002J \u0010t\u001a\u00020\u00072\u0006\u0010u\u001a\u00020\u00172\u0006\u0010v\u001a\u00020\u00172\u0006\u0010[\u001a\u00020\u0007H\u0002J \u0010w\u001a\u00020\u00072\u0006\u0010X\u001a\u00020\u00172\u0006\u0010Y\u001a\u00020\u00172\u0006\u0010[\u001a\u00020\u0007H\u0002J0\u0010x\u001a\u00020\u00072\u0006\u0010y\u001a\u00020\u00172\u0006\u0010z\u001a\u00020\u00172\u0006\u0010{\u001a\u00020\u00072\u0006\u0010[\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007H\u0002J0\u0010|\u001a\u00020\u00152\u0006\u0010y\u001a\u00020\u00172\u0006\u0010z\u001a\u00020\u00172\u0006\u0010{\u001a\u00020\u00072\u0006\u0010[\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007H\u0002J0\u0010}\u001a\u00020\u00072\u0006\u0010y\u001a\u00020\u00172\u0006\u0010z\u001a\u00020\u00172\u0006\u0010{\u001a\u00020\u00072\u0006\u0010[\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007H\u0002J(\u0010~\u001a\u00020\u00072\u0006\u0010X\u001a\u00020\u00172\u0006\u0010{\u001a\u00020\u00072\u0006\u0010s\u001a\u00020\u00072\u0006\u0010\u007f\u001a\u00020\u0007H\u0002J\u001a\u0010\u0080\u0001\u001a\u00020\u00172\u0007\u0010\u0081\u0001\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u0007H\u0002J2\u0010\u0082\u0001\u001a\u00020\u00152\u0007\u0010\u0083\u0001\u001a\u00020\"2\r\u0010\u0084\u0001\u001a\b0\u0085\u0001j\u0003`\u0086\u00012\u0006\u00103\u001a\u00020\u00072\u0007\u0010\u0087\u0001\u001a\u00020\u0007H\u0002J\u001a\u0010\u0088\u0001\u001a\u00020\"2\u0006\u00103\u001a\u00020\u00072\u0007\u0010\u0089\u0001\u001a\u00020\u0007H\u0002J\u0011\u0010\u008c\u0001\u001a\u00020\u00172\u0006\u00100\u001a\u00020\u0017H\u0002J\u0011\u0010\u008d\u0001\u001a\u00020\u00172\u0006\u00100\u001a\u00020\u0017H\u0002J\"\u0010\u008e\u0001\u001a\u00020\u00172\u0006\u0010X\u001a\u00020\u001b2\u0007\u0010\u008f\u0001\u001a\u00020\u00072\u0006\u0010[\u001a\u00020\u0007H\u0002J\"\u0010\u0090\u0001\u001a\u00020\u00172\u0006\u0010X\u001a\u00020\u001b2\u0007\u0010\u008f\u0001\u001a\u00020\u00072\u0006\u0010[\u001a\u00020\u0007H\u0002J\u0011\u0010\u0090\u0001\u001a\u00020\u00172\u0006\u0010X\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0018\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"06X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00107R\u0018\u00108\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"06X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00107R\u001e\u00109\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\"\u0018\u00010606X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010:R\u000e\u0010;\u001a\u00020<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010?\u001a\u00020\"8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b@\u0010\u0003R\u0016\u0010A\u001a\u00020\"8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\bB\u0010\u0003R\u0016\u0010C\u001a\u00020\"8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\bD\u0010\u0003R\u0016\u0010E\u001a\u00020\"8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\bF\u0010\u0003R\u0016\u0010G\u001a\u00020\"8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\bH\u0010\u0003R\u001a\u0010l\u001a\u00020\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bm\u0010n\"\u0004\bo\u0010pR\u001a\u0010\u008a\u0001\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010206X\u0082\u0004\u00a2\u0006\u0005\n\u0003\u0010\u008b\u0001R\u000f\u0010\u0091\u0001\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0092\u0001\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"06X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00107R\u000f\u0010\u0093\u0001\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0094\u0001\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0095\u0001"}, d2={"Lcom/macrofocus/common/math/big/CommonBigInteger$Companion;", "", "<init>", "()V", "LONG_MASK", "", "MAX_MAG_LENGTH", "", "PRIME_SEARCH_BIT_LENGTH_LIMIT", "KARATSUBA_THRESHOLD", "TOOM_COOK_THRESHOLD", "KARATSUBA_SQUARE_THRESHOLD", "TOOM_COOK_SQUARE_THRESHOLD", "BURNIKEL_ZIEGLER_THRESHOLD", "BURNIKEL_ZIEGLER_OFFSET", "SCHOENHAGE_BASE_CONVERSION_THRESHOLD", "MULTIPLY_SQUARE_THRESHOLD", "MONTGOMERY_INTRINSIC_THRESHOLD", "bitsPerDigit", "", "destructiveMulAdd", "", "x", "", "y", "z", "randomBits", "", "numBits", "rnd", "Lkotlin/random/Random;", "SMALL_PRIME_THRESHOLD", "DEFAULT_PRIME_CERTAINTY", "probablePrime", "Lcom/macrofocus/common/math/big/CommonBigInteger;", "bitLength", "smallPrime", "certainty", "SMALL_PRIME_PRODUCT", "largePrime", "getPrimeSearchLen", "jacobiSymbol", "p", "n", "lucasLehmerSequence", "k", "reportOverflow", "of", "other", "value", "", "radix", "MAX_CONSTANT", "posConst", "", "[Lcom/macrofocus/common/math/big/CommonBigInteger;", "negConst", "powerCache", "[[Lcom/macrofocus/common/math/big/CommonBigInteger;", "logCache", "", "LOG_TWO", "", "ZERO", "getZERO$annotations", "ONE", "getONE$annotations", "TWO", "getTWO$annotations", "NEGATIVE_ONE", "getNEGATIVE_ONE$annotations", "TEN", "getTEN$annotations", "sum", "subtract", "little", "big", "multiplyByInt", "sign", "multiplyToLen", "xlen", "ylen", "implMultiplyToLen", "multiplyToLenCheck", "array", "length", "multiplyKaratsuba", "multiplyToomCook3", "a", "b", "squareToLen", "len", "implSquareToLenChecks", "zlen", "implSquareToLen", "bitLengthForInt", "bitLengthForInt$macrofocus_common", "leftShift", "primitiveRightShift", "primitiveLeftShift", "montgomeryMultiply", "inv", "product", "montgomerySquare", "implMontgomeryMultiplyChecks", "materialize", "implMontgomeryMultiply", "implMontgomerySquare", "bnExpModThreshTable", "getBnExpModThreshTable$macrofocus_common", "()[I", "setBnExpModThreshTable$macrofocus_common", "([I)V", "montReduce", "mod", "mlen", "intArrayCmpToLen", "arg1", "arg2", "subN", "mulAdd", "out", "in", "offset", "implMulAddCheck", "implMulAdd", "addOne", "carry", "shl", "mag", "toString", "u", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "digits", "getRadixConversionCache", "exponent", "zeros", "[Ljava/lang/String;", "stripLeadingZeroInts", "trustedStripLeadingZeroInts", "stripLeadingZeroBytes", "off", "makePositive", "digitsPerLong", "longRadix", "digitsPerInt", "intRadix", "macrofocus-common"})
    @SourceDebugExtension(value={"SMAP\nCommonBigInteger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonBigInteger.kt\ncom/macrofocus/common/math/big/CommonBigInteger$Companion\n+ 2 Utils.kt\ncom/macrofocus/common/math/big/Utils\n*L\n1#1,5194:1\n311#2:5195\n*S KotlinDebug\n*F\n+ 1 CommonBigInteger.kt\ncom/macrofocus/common/math/big/CommonBigInteger$Companion\n*L\n4836#1:5195\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void destructiveMulAdd(int[] x, int y, int z) {
            long ylong = (long)y & 0xFFFFFFFFL;
            long zlong = (long)z & 0xFFFFFFFFL;
            int len = x.length;
            long product = 0L;
            long carry = 0L;
            for (int i = len - 1; -1 < i; --i) {
                product = ylong * ((long)x[i] & 0xFFFFFFFFL) + carry;
                x[i] = (int)product;
                carry = product >>> 32;
            }
            long sum = ((long)x[len - 1] & 0xFFFFFFFFL) + zlong;
            x[len - 1] = (int)sum;
            carry = sum >>> 32;
            for (int i = len - 2; -1 < i; --i) {
                sum = ((long)x[i] & 0xFFFFFFFFL) + carry;
                x[i] = (int)sum;
                carry = sum >>> 32;
            }
        }

        private final byte[] randomBits(int numBits, Random rnd) {
            if (numBits < 0) {
                throw new IllegalArgumentException("numBits must be non-negative");
            }
            int numBytes = (int)(((long)numBits + (long)7) / (long)8);
            byte[] randomBits = new byte[numBytes];
            if (numBytes > 0) {
                rnd.nextBytes(randomBits);
                int excessBits = 8 * numBytes - numBits;
                randomBits[0] = (byte)(randomBits[0] & (byte)((1 << 8 - excessBits) - 1));
            }
            return randomBits;
        }

        @JvmStatic
        @NotNull
        public final CommonBigInteger probablePrime(int bitLength, @NotNull Random rnd) {
            Intrinsics.checkNotNullParameter((Object)rnd, (String)"rnd");
            if (bitLength < 2) {
                throw new ArithmeticException("bitLength < 2");
            }
            return bitLength < 95 ? this.smallPrime(bitLength, 100, rnd) : this.largePrime(bitLength, 100, rnd);
        }

        /*
         * Unable to fully structure code
         */
        private final CommonBigInteger smallPrime(int bitLength, int certainty, Random rnd) {
            magLen = bitLength + 31 >>> 5;
            temp = new int[magLen];
            highBit = 1 << (bitLength + 31 & 31);
            highMask = (highBit << 1) - 1;
            while (true) {
                for (i = 0; i < magLen; ++i) {
                    temp[i] = rnd.nextInt();
                }
                temp[0] = temp[0] & highMask | highBit;
                if (bitLength > 2) {
                    temp[magLen - 1] = temp[magLen - 1] | 1;
                }
                p = new CommonBigInteger(temp, 1);
                if (bitLength > 6 && ((r = p.remainder(CommonBigInteger.access$getSMALL_PRIME_PRODUCT$cp()).toLong()) % (long)3 == 0L || r % (long)5 == 0L || r % (long)7 == 0L || r % (long)11 == 0L || r % (long)13 == 0L || r % (long)17 == 0L || r % (long)19 == 0L || r % (long)23 == 0L || r % (long)29 == 0L || r % (long)31 == 0L || r % (long)37 == 0L || r % (long)41 == 0L)) ** continue;
                if (bitLength < 4) {
                    return p;
                }
                if (p.primeToCertainty$macrofocus_common(certainty, rnd)) break;
            }
            return p;
        }

        private final CommonBigInteger largePrime(int bitLength, int certainty, Random rnd) {
            CommonBigInteger p = null;
            p = new CommonBigInteger(bitLength, rnd).setBit(bitLength - 1);
            p._mag[p._mag.length - 1] = p._mag[p._mag.length - 1] & 0xFFFFFFFE;
            int searchLen = this.getPrimeSearchLen(bitLength);
            BitSieve searchSieve = new BitSieve(p, searchLen);
            CommonBigInteger candidate = searchSieve.retrieve(p, certainty, rnd);
            while (candidate == null || candidate.getBitLength() != bitLength) {
                if ((p = p.plus(this.of((long)(2 * searchLen)))).getBitLength() != bitLength) {
                    p = new CommonBigInteger(bitLength, rnd).setBit(bitLength - 1);
                }
                p._mag[p._mag.length - 1] = p._mag[p._mag.length - 1] & 0xFFFFFFFE;
                searchSieve = new BitSieve(p, searchLen);
                candidate = searchSieve.retrieve(p, certainty, rnd);
            }
            return candidate;
        }

        private final int getPrimeSearchLen(int bitLength) {
            if (bitLength > 500000001) {
                throw new ArithmeticException("Prime search implementation restriction on bitLength");
            }
            return bitLength / 20 * 64;
        }

        private final int jacobiSymbol(int p, CommonBigInteger n) {
            int p2 = p;
            if (p2 == 0) {
                return 0;
            }
            int j = 1;
            int u = n._mag[n._mag.length - 1];
            if (p2 < 0) {
                p2 = -p2;
                int n8 = u & 7;
                switch (n8) {
                    case 3: 
                    case 7: {
                        j = -j;
                    }
                }
            }
            while ((p2 & 3) == 0) {
                p2 >>= 2;
            }
            if ((p2 & 1) == 0) {
                p2 >>= 1;
                if (((u ^ u >> 1) & 2) != 0) {
                    j = -j;
                }
            }
            if (p2 == 1) {
                return j;
            }
            if ((p2 & u & 2) != 0) {
                j = -j;
            }
            for (u = n.rem(this.of((long)p2)).toInt(); u != 0; u %= p2) {
                while ((u & 3) == 0) {
                    u >>= 2;
                }
                if ((u & 1) == 0) {
                    u >>= 1;
                    if (((p2 ^ p2 >> 1) & 2) != 0) {
                        j = -j;
                    }
                }
                if (u == 1) {
                    return j;
                }
                if (!(u < p2)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                u = p2;
                int t = u;
                if ((u & (p2 = t) & 2) == 0) continue;
                j = -j;
            }
            return 0;
        }

        private final CommonBigInteger lucasLehmerSequence(int z, CommonBigInteger k, CommonBigInteger n) {
            CommonBigInteger d = this.of((long)z);
            CommonBigInteger u = ONE;
            CommonBigInteger u2 = null;
            CommonBigInteger v = ONE;
            CommonBigInteger v2 = null;
            for (int i = k.getBitLength() - 2; -1 < i; --i) {
                u2 = u.times(v).rem(n);
                v2 = v.square().plus(d.times(u.square())).rem(n);
                if (v2.testBit(0)) {
                    v2 = v2.minus(n);
                }
                v2 = v2.shr(1);
                u = u2;
                v = v2;
                if (!k.testBit(i)) continue;
                u2 = u.plus(v).rem(n);
                if (u2.testBit(0)) {
                    u2 = u2.minus(n);
                }
                u2 = u2.shr(1);
                v2 = v.plus(d.times(u)).rem(n);
                if (v2.testBit(0)) {
                    v2 = v2.minus(n);
                }
                v2 = v2.shr(1);
                u = u2;
                v = v2;
            }
            return u;
        }

        private final void reportOverflow() {
            throw new ArithmeticException("BigInteger would overflow supported range");
        }

        @JvmStatic
        @NotNull
        public final CommonBigInteger of(long other) {
            if (other == 0L) {
                return ZERO;
            }
            boolean bl = 1L <= other ? other <= (long)MAX_CONSTANT : false;
            if (bl) {
                CommonBigInteger commonBigInteger = posConst[(int)other];
                if (commonBigInteger == null) {
                    throw new IllegalStateException();
                }
                return commonBigInteger;
            }
            if (other < 0L && other >= (long)(-MAX_CONSTANT)) {
                CommonBigInteger commonBigInteger = negConst[(int)(-other)];
                if (commonBigInteger == null) {
                    throw new IllegalStateException();
                }
                return commonBigInteger;
            }
            return new CommonBigInteger(other, null);
        }

        @JvmStatic
        @NotNull
        public final CommonBigInteger of(int value) {
            return this.of((long)value);
        }

        @JvmStatic
        @NotNull
        public final CommonBigInteger of(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Pair<Integer, String> radixed = Utils.getRadix(value);
            return new CommonBigInteger((String)radixed.getSecond(), ((Number)radixed.getFirst()).intValue());
        }

        @JvmStatic
        @NotNull
        public final CommonBigInteger of(@NotNull String value, int radix) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new CommonBigInteger(value, radix);
        }

        @JvmStatic
        @NotNull
        public final CommonBigInteger of(@NotNull int[] other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return other[0] > 0 ? new CommonBigInteger(other, 1) : new CommonBigInteger(other, null);
        }

        public static /* synthetic */ void getZERO$annotations() {
        }

        public static /* synthetic */ void getONE$annotations() {
        }

        public static /* synthetic */ void getTWO$annotations() {
        }

        public static /* synthetic */ void getNEGATIVE_ONE$annotations() {
        }

        public static /* synthetic */ void getTEN$annotations() {
        }

        private final int[] sum(int[] x, long other) {
            boolean carry;
            long sum = 0L;
            int xIndex = x.length;
            int[] result = null;
            int highWord = (int)(other >>> 32);
            if (highWord == 0) {
                result = new int[xIndex];
                sum = ((long)x[--xIndex] & 0xFFFFFFFFL) + other;
                result[xIndex] = (int)sum;
            } else {
                if (xIndex == 1) {
                    result = new int[2];
                    sum = other + ((long)x[0] & 0xFFFFFFFFL);
                    result[1] = (int)sum;
                    result[0] = (int)(sum >>> 32);
                    return result;
                }
                result = new int[xIndex];
                sum = ((long)x[--xIndex] & 0xFFFFFFFFL) + (other & 0xFFFFFFFFL);
                result[xIndex] = (int)sum;
                sum = ((long)x[--xIndex] & 0xFFFFFFFFL) + ((long)highWord & 0xFFFFFFFFL) + (sum >>> 32);
                result[xIndex] = (int)sum;
            }
            boolean bl = carry = sum >>> 32 != 0L;
            while (xIndex > 0 && carry) {
                result[xIndex - 1] = x[xIndex] + 1;
                carry = result[--xIndex] == 0;
            }
            while (xIndex > 0) {
                result[--xIndex] = x[xIndex];
            }
            if (carry) {
                int[] bigger = new int[result.length + 1];
                Utils.arrayCopy(result, 0, bigger, 1, result.length);
                bigger[0] = 1;
                return bigger;
            }
            return result;
        }

        private final int[] sum(int[] x, int[] y) {
            boolean carry;
            int[] x2 = x;
            int[] y2 = y;
            if (x2.length < y2.length) {
                int[] tmp = x2;
                x2 = y2;
                y2 = tmp;
            }
            int xIndex = x2.length;
            int yIndex = y2.length;
            int[] result = new int[xIndex];
            long sum = 0L;
            if (yIndex == 1) {
                sum = ((long)x2[--xIndex] & 0xFFFFFFFFL) + ((long)y2[0] & 0xFFFFFFFFL);
                result[xIndex] = (int)sum;
            } else {
                while (yIndex > 0) {
                    sum = ((long)x2[--xIndex] & 0xFFFFFFFFL) + ((long)y2[--yIndex] & 0xFFFFFFFFL) + (sum >>> 32);
                    result[xIndex] = (int)sum;
                }
            }
            boolean bl = carry = sum >>> 32 != 0L;
            while (xIndex > 0 && carry) {
                result[--xIndex] = x2[xIndex] + 1;
                carry = result[xIndex] == 0;
            }
            while (xIndex > 0) {
                result[--xIndex] = x2[xIndex];
            }
            if (carry) {
                int[] bigger = new int[result.length + 1];
                Utils.arrayCopy(result, 0, bigger, 1, result.length);
                bigger[0] = 1;
                return bigger;
            }
            return result;
        }

        private final int[] subtract(long other, int[] little) {
            int highWord = (int)(other >>> 32);
            if (highWord == 0) {
                int[] result = new int[]{(int)(other - ((long)little[0] & 0xFFFFFFFFL))};
                return result;
            }
            int[] result = new int[2];
            if (little.length == 1) {
                long difference = ((long)((int)other) & 0xFFFFFFFFL) - ((long)little[0] & 0xFFFFFFFFL);
                result[1] = (int)difference;
                boolean borrow = difference >> 32 != 0L;
                result[0] = borrow ? highWord - 1 : highWord;
                return result;
            }
            long difference = ((long)((int)other) & 0xFFFFFFFFL) - ((long)little[1] & 0xFFFFFFFFL);
            result[1] = (int)difference;
            difference = ((long)highWord & 0xFFFFFFFFL) - ((long)little[0] & 0xFFFFFFFFL) + (difference >> 32);
            result[0] = (int)difference;
            return result;
        }

        private final int[] subtract(int[] big, long other) {
            boolean borrow;
            int highWord = (int)(other >>> 32);
            int bigIndex = big.length;
            int[] result = new int[bigIndex];
            long difference = 0L;
            if (highWord == 0) {
                difference = ((long)big[--bigIndex] & 0xFFFFFFFFL) - other;
                result[bigIndex] = (int)difference;
            } else {
                difference = ((long)big[--bigIndex] & 0xFFFFFFFFL) - (other & 0xFFFFFFFFL);
                result[bigIndex] = (int)difference;
                difference = ((long)big[--bigIndex] & 0xFFFFFFFFL) - ((long)highWord & 0xFFFFFFFFL) + (difference >> 32);
                result[bigIndex] = (int)difference;
            }
            boolean bl = borrow = difference >> 32 != 0L;
            while (bigIndex > 0 && borrow) {
                result[--bigIndex] = big[bigIndex] - 1;
                borrow = result[bigIndex] == -1;
            }
            while (bigIndex > 0) {
                result[--bigIndex] = big[bigIndex];
            }
            return result;
        }

        private final int[] subtract(int[] big, int[] little) {
            boolean borrow;
            int bigIndex = big.length;
            int[] result = new int[bigIndex];
            int littleIndex = little.length;
            long difference = 0L;
            while (littleIndex > 0) {
                difference = ((long)big[--bigIndex] & 0xFFFFFFFFL) - ((long)little[--littleIndex] & 0xFFFFFFFFL) + (difference >> 32);
                result[bigIndex] = (int)difference;
            }
            boolean bl = borrow = difference >> 32 != 0L;
            while (bigIndex > 0 && borrow) {
                result[--bigIndex] = big[bigIndex] - 1;
                borrow = result[bigIndex] == -1;
            }
            while (bigIndex > 0) {
                result[--bigIndex] = big[bigIndex];
            }
            return result;
        }

        private final CommonBigInteger multiplyByInt(int[] x, int y, int sign) {
            if (Utils.bitCount(y) == 1) {
                return new CommonBigInteger(this.shl(x, Utils.numberOfTrailingZeros(y)), sign);
            }
            int xlen = x.length;
            int[] rmag = new int[xlen + 1];
            long carry = 0L;
            long yl = (long)y & 0xFFFFFFFFL;
            int rstart = rmag.length - 1;
            for (int i = xlen - 1; -1 < i; --i) {
                long product = ((long)x[i] & 0xFFFFFFFFL) * yl + carry;
                rmag[rstart--] = (int)product;
                carry = product >>> 32;
            }
            if (carry == 0L) {
                rmag = ArraysKt.copyOfRange((int[])rmag, (int)1, (int)rmag.length);
            } else {
                rmag[rstart] = (int)carry;
            }
            return new CommonBigInteger(rmag, sign);
        }

        private final int[] multiplyToLen(int[] x, int xlen, int[] y, int ylen, int[] z) {
            this.multiplyToLenCheck(x, xlen);
            this.multiplyToLenCheck(y, ylen);
            return this.implMultiplyToLen(x, xlen, y, ylen, z);
        }

        private final int[] implMultiplyToLen(int[] x, int xlen, int[] y, int ylen, int[] z) {
            int[] z2 = null;
            z2 = z;
            int xstart = xlen - 1;
            int ystart = ylen - 1;
            if (z2 == null || z2.length < xlen + ylen) {
                z2 = new int[xlen + ylen];
            }
            long carry = 0L;
            Companion $this$implMultiplyToLen_u24lambda_u240 = this;
            boolean bl = false;
            int j = ystart;
            int k = ystart + 1 + xstart;
            while (j >= 0) {
                long product = ((long)y[j] & 0xFFFFFFFFL) * ((long)x[xstart] & 0xFFFFFFFFL) + carry;
                z2[k] = (int)product;
                carry = product >>> 32;
                --j;
                --k;
            }
            z2[xstart] = (int)carry;
            for (int i = xstart - 1; -1 < i; --i) {
                carry = 0L;
                int j2 = ystart;
                int k2 = ystart + 1 + i;
                while (j2 >= 0) {
                    long product = ((long)y[j2] & 0xFFFFFFFFL) * ((long)x[i] & 0xFFFFFFFFL) + ((long)z2[k2] & 0xFFFFFFFFL) + carry;
                    z2[k2] = (int)product;
                    carry = product >>> 32;
                    --j2;
                    --k2;
                }
                z2[i] = (int)carry;
            }
            return z2;
        }

        private final void multiplyToLenCheck(int[] array, int length) {
            if (length <= 0) {
                return;
            }
            if (length > array.length) {
                throw new IndexOutOfBoundsException(String.valueOf(length - 1));
            }
        }

        private final CommonBigInteger multiplyKaratsuba(CommonBigInteger x, CommonBigInteger y) {
            int xlen = x._mag.length;
            int ylen = y._mag.length;
            int half = (Math.max(xlen, ylen) + 1) / 2;
            CommonBigInteger xl = x.getLower(half);
            CommonBigInteger xh = x.getUpper(half);
            CommonBigInteger yl = y.getLower(half);
            CommonBigInteger yh = y.getUpper(half);
            CommonBigInteger p1 = xh.times(yh);
            CommonBigInteger p2 = xl.times(yl);
            CommonBigInteger p3 = xh.plus(xl).times(yh.plus(yl));
            CommonBigInteger result = p1.shl(32 * half).plus(p3.minus(p1).minus(p2)).shl(32 * half).plus(p2);
            return x.get_signum$macrofocus_common() != y.get_signum$macrofocus_common() ? result.unaryMinus() : result;
        }

        private final CommonBigInteger multiplyToomCook3(CommonBigInteger a, CommonBigInteger b) {
            int alen = a._mag.length;
            int blen = b._mag.length;
            int largest = Math.max(alen, blen);
            int k = (largest + 2) / 3;
            int r = largest - 2 * k;
            CommonBigInteger a0 = null;
            CommonBigInteger a1 = null;
            CommonBigInteger a2 = null;
            CommonBigInteger b0 = null;
            CommonBigInteger b1 = null;
            CommonBigInteger b2 = null;
            a2 = a.getToomSlice(k, r, 0, largest);
            a1 = a.getToomSlice(k, r, 1, largest);
            a0 = a.getToomSlice(k, r, 2, largest);
            b2 = b.getToomSlice(k, r, 0, largest);
            b1 = b.getToomSlice(k, r, 1, largest);
            b0 = b.getToomSlice(k, r, 2, largest);
            CommonBigInteger v0 = null;
            CommonBigInteger v1 = null;
            CommonBigInteger v2 = null;
            CommonBigInteger vm1 = null;
            CommonBigInteger vinf = null;
            CommonBigInteger t1 = null;
            CommonBigInteger t2 = null;
            CommonBigInteger tm1 = null;
            CommonBigInteger da1 = null;
            CommonBigInteger db1 = null;
            v0 = a0.times(b0);
            da1 = a2.plus(a0);
            db1 = b2.plus(b0);
            vm1 = da1.minus(a1).times(db1.minus(b1));
            da1 = da1.plus(a1);
            db1 = db1.plus(b1);
            v1 = da1.times(db1);
            v2 = da1.plus(a2).shl(1).minus(a0).times(db1.plus(b2).shl(1).minus(b0));
            vinf = a2.times(b2);
            t2 = v2.minus(vm1).exactDivideBy3();
            tm1 = v1.minus(vm1).shr(1);
            t1 = v1.minus(v0);
            t2 = t2.minus(t1).shr(1);
            t1 = t1.minus(tm1).minus(vinf);
            t2 = t2.minus(vinf.shl(1));
            tm1 = tm1.minus(t2);
            int ss = k * 32;
            CommonBigInteger result = vinf.shl(ss).plus(t2).shl(ss).plus(t1).shl(ss).plus(tm1).shl(ss).plus(v0);
            return a.get_signum$macrofocus_common() != b.get_signum$macrofocus_common() ? result.unaryMinus() : result;
        }

        private final int[] squareToLen(int[] x, int len, int[] z) {
            int[] z2 = z;
            int zlen = len << 1;
            if (z2 == null || z2.length < zlen) {
                z2 = new int[zlen];
            }
            this.implSquareToLenChecks(x, len, z2, zlen);
            return this.implSquareToLen(x, len, z2, zlen);
        }

        private final void implSquareToLenChecks(int[] x, int len, int[] z, int zlen) {
            if (len < 1) {
                throw new IllegalArgumentException("invalid input length: " + len);
            }
            if (len > x.length) {
                throw new IllegalArgumentException("input length out of bound: " + len + " > " + x.length);
            }
            if (len * 2 > z.length) {
                throw new IllegalArgumentException("input length out of bound: " + len * 2 + " > " + z.length);
            }
            if (zlen < 1) {
                throw new IllegalArgumentException("invalid input length: " + zlen);
            }
            if (zlen > z.length) {
                throw new IllegalArgumentException("input length out of bound: " + len + " > " + z.length);
            }
        }

        private final int[] implSquareToLen(int[] x, int len, int[] z, int zlen) {
            int lastProductLowWord = 0;
            Companion $this$implSquareToLen_u24lambda_u241 = this;
            boolean bl = false;
            int i = 0;
            for (int j = 0; j < len; ++j) {
                long piece = (long)x[j] & 0xFFFFFFFFL;
                long product = piece * piece;
                z[i++] = lastProductLowWord << 31 | (int)(product >>> 33);
                z[i++] = (int)(product >>> 1);
                lastProductLowWord = (int)product;
            }
            int i2 = len;
            int offset = 1;
            while (i2 > 0) {
                int t = x[i2 - 1];
                t = this.mulAdd(z, x, offset, i2 - 1, t);
                this.addOne(z, offset - 1, i2, t);
                --i2;
                offset += 2;
            }
            this.primitiveLeftShift(z, zlen, 1);
            z[zlen - 1] = z[zlen - 1] | x[len - 1] & 1;
            return z;
        }

        public final int bitLengthForInt$macrofocus_common(int n) {
            return 32 - Utils.numberOfLeadingZeros(n);
        }

        private final int[] leftShift(int[] a, int len, int n) {
            int nInts = n >>> 5;
            int nBits = n & 0x1F;
            int bitsInHighWord = this.bitLengthForInt$macrofocus_common(a[0]);
            if (n <= 32 - bitsInHighWord) {
                this.primitiveLeftShift(a, len, nBits);
                return a;
            }
            if (nBits <= 32 - bitsInHighWord) {
                int[] result = new int[nInts + len];
                Utils.arrayCopy(a, 0, result, 0, len);
                this.primitiveLeftShift(result, result.length, nBits);
                return result;
            }
            int[] result = new int[nInts + len + 1];
            Utils.arrayCopy(a, 0, result, 0, len);
            this.primitiveRightShift(result, result.length, 32 - nBits);
            return result;
        }

        private final void primitiveRightShift(int[] a, int len, int n) {
            int i;
            int n2 = 32 - n;
            int c = a[i];
            for (i = len - 1; i > 0; --i) {
                int b = c;
                c = a[i - 1];
                a[i] = c << n2 | b >>> n;
            }
            a[0] = a[0] >>> n;
        }

        private final void primitiveLeftShift(int[] a, int len, int n) {
            int i;
            if (len == 0 || n == 0) {
                return;
            }
            int n2 = 32 - n;
            int c = a[i];
            int m = i + len - 1;
            for (i = 0; i < m; ++i) {
                int b = c;
                c = a[i + 1];
                a[i] = b << n | c >>> n2;
            }
            a[len - 1] = a[len - 1] << n;
        }

        private final int bitLength(int[] other, int len) {
            return len == 0 ? 0 : (len - 1 << 5) + this.bitLengthForInt$macrofocus_common(other[0]);
        }

        private final int[] montgomeryMultiply(int[] a, int[] b, int[] n, int len, long inv, int[] product) {
            int[] product2 = product;
            this.implMontgomeryMultiplyChecks(a, b, n, len, product2);
            if (len > 512) {
                product2 = this.multiplyToLen(a, len, b, len, product2);
                return this.montReduce(product2, n, len, (int)inv);
            }
            return this.implMontgomeryMultiply(a, b, n, len, inv, this.materialize(product2, len));
        }

        private final int[] montgomerySquare(int[] a, int[] n, int len, long inv, int[] product) {
            int[] product2 = product;
            this.implMontgomeryMultiplyChecks(a, a, n, len, product2);
            if (len > 512) {
                product2 = this.squareToLen(a, len, product2);
                return this.montReduce(product2, n, len, (int)inv);
            }
            return this.implMontgomerySquare(a, n, len, inv, this.materialize(product2, len));
        }

        private final void implMontgomeryMultiplyChecks(int[] a, int[] b, int[] n, int len, int[] product) {
            if (len % 2 != 0) {
                throw new IllegalArgumentException("input array length must be even: " + len);
            }
            if (len < 1) {
                throw new IllegalArgumentException("invalid input length: " + len);
            }
            if (len > a.length || len > b.length || len > n.length || product != null && len > product.length) {
                throw new IllegalArgumentException("input array length out of bound: " + len);
            }
        }

        private final int[] materialize(int[] z, int len) {
            int[] z2 = z;
            if (z2 == null || z2.length < len) {
                z2 = new int[len];
            }
            return z2;
        }

        private final int[] implMontgomeryMultiply(int[] a, int[] b, int[] n, int len, long inv, int[] product) {
            int[] product2 = product;
            product2 = this.multiplyToLen(a, len, b, len, product2);
            return this.montReduce(product2, n, len, (int)inv);
        }

        private final int[] implMontgomerySquare(int[] a, int[] n, int len, long inv, int[] product) {
            int[] product2 = product;
            product2 = this.squareToLen(a, len, product2);
            return this.montReduce(product2, n, len, (int)inv);
        }

        @NotNull
        public final int[] getBnExpModThreshTable$macrofocus_common() {
            return bnExpModThreshTable;
        }

        public final void setBnExpModThreshTable$macrofocus_common(@NotNull int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
            bnExpModThreshTable = nArray;
        }

        private final int[] montReduce(int[] n, int[] mod, int mlen, int inv) {
            int c = 0;
            int len = mlen;
            int offset = 0;
            do {
                int nEnd = n[n.length - 1 - offset];
                int carry = this.mulAdd(n, mod, offset, mlen, inv * nEnd);
                c += this.addOne(n, offset, mlen, carry);
                ++offset;
            } while (--len > 0);
            while (c > 0) {
                c += this.subN(n, mod, mlen);
            }
            while (this.intArrayCmpToLen(n, mod, mlen) >= 0) {
                this.subN(n, mod, mlen);
            }
            return n;
        }

        private final int intArrayCmpToLen(int[] arg1, int[] arg2, int len) {
            for (int i = 0; i < len; ++i) {
                long b1 = (long)arg1[i] & 0xFFFFFFFFL;
                long b2 = (long)arg2[i] & 0xFFFFFFFFL;
                if (b1 < b2) {
                    return -1;
                }
                if (b1 <= b2) continue;
                return 1;
            }
            return 0;
        }

        private final int subN(int[] a, int[] b, int len) {
            int len2 = len;
            long sum = 0L;
            while (--len2 >= 0) {
                sum = ((long)a[len2] & 0xFFFFFFFFL) - ((long)b[len2] & 0xFFFFFFFFL) + (sum >> 32);
                a[len2] = (int)sum;
            }
            return (int)(sum >> 32);
        }

        private final int mulAdd(int[] out, int[] in, int offset, int len, int k) {
            this.implMulAddCheck(out, in, offset, len, k);
            return this.implMulAdd(out, in, offset, len, k);
        }

        private final void implMulAddCheck(int[] out, int[] in, int offset, int len, int k) {
            if (len > in.length) {
                throw new IllegalArgumentException("input length is out of bound: " + len + " > " + in.length);
            }
            if (offset < 0) {
                throw new IllegalArgumentException("input offset is invalid: " + offset);
            }
            if (offset > out.length - 1) {
                throw new IllegalArgumentException("input offset is out of bound: " + offset + " > " + (out.length - 1));
            }
            if (len > out.length - offset) {
                throw new IllegalArgumentException("input len is out of bound: " + len + " > " + (out.length - offset));
            }
        }

        private final int implMulAdd(int[] out, int[] in, int offset, int len, int k) {
            int offset2 = offset;
            long kLong = (long)k & 0xFFFFFFFFL;
            long carry = 0L;
            offset2 = out.length - offset2 - 1;
            for (int j = len - 1; -1 < j; --j) {
                long product = ((long)in[j] & 0xFFFFFFFFL) * kLong + ((long)out[offset2] & 0xFFFFFFFFL) + carry;
                out[offset2--] = (int)product;
                carry = product >>> 32;
            }
            return (int)carry;
        }

        private final int addOne(int[] a, int offset, int mlen, int carry) {
            int offset2 = offset;
            int mlen2 = mlen;
            offset2 = a.length - 1 - mlen2 - offset2;
            long t = ((long)a[offset2] & 0xFFFFFFFFL) + ((long)carry & 0xFFFFFFFFL);
            a[offset2] = (int)t;
            if (t >>> 32 == 0L) {
                return 0;
            }
            while (--mlen2 >= 0) {
                if (--offset2 < 0) {
                    return 1;
                }
                int n = offset2;
                int n2 = a[n];
                a[n] = n2 + 1;
                if (a[offset2] == 0) continue;
                return 0;
            }
            return 1;
        }

        private final int[] shl(int[] mag, int n) {
            int nInts = n >>> 5;
            int nBits = n & 0x1F;
            int magLen = mag.length;
            int[] newMag = null;
            if (nBits == 0) {
                newMag = new int[magLen + nInts];
                Utils.arrayCopy(mag, 0, newMag, 0, magLen);
            } else {
                int i = 0;
                int nBits2 = 32 - nBits;
                int highBits = mag[0] >>> nBits2;
                if (highBits != 0) {
                    newMag = new int[magLen + nInts + 1];
                    newMag[i++] = highBits;
                } else {
                    newMag = new int[magLen + nInts];
                }
                int j = 0;
                while (j < magLen - 1) {
                    newMag[i++] = mag[j++] << nBits | mag[j] >>> nBits2;
                }
                newMag[i] = mag[j] << nBits;
            }
            return newMag;
        }

        private final void toString(CommonBigInteger u, StringBuilder sb, int radix, int digits) {
            if (u._mag.length <= 20) {
                String s = u.smallToString(radix);
                if (s.length() < digits && sb.length() > 0) {
                    for (int i = s.length(); i < digits; ++i) {
                        sb.append('0');
                    }
                }
                sb.append(s);
                return;
            }
            int b = 0;
            int n = 0;
            b = u.getBitLength();
            n = (int)Math.rint(Math.log((double)b * LOG_TWO / logCache[radix]) / LOG_TWO - 1.0);
            CommonBigInteger v = this.getRadixConversionCache(radix, n);
            CommonBigInteger[] results = null;
            results = u.divideAndRemainder(v);
            int expectedDigits = 1 << n;
            this.toString(results[0], sb, radix, digits - expectedDigits);
            this.toString(results[1], sb, radix, expectedDigits);
        }

        private final CommonBigInteger getRadixConversionCache(int radix, int exponent) {
            CommonBigInteger[] cacheLine = powerCache[radix];
            Intrinsics.checkNotNull((Object)cacheLine);
            if (exponent < cacheLine.length) {
                return cacheLine[exponent];
            }
            int oldLength = cacheLine.length;
            Object[] objectArray = Arrays.copyOf(cacheLine, exponent + 1);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            Object[] cacheLine2 = objectArray;
            int i = oldLength;
            if (i <= exponent) {
                while (true) {
                    CommonBigInteger commonBigInteger = cacheLine2[i - 1];
                    Intrinsics.checkNotNull((Object)commonBigInteger);
                    cacheLine2[i] = commonBigInteger.pow(2);
                    if (i == exponent) break;
                    ++i;
                }
            }
            CommonBigInteger[][] pc = powerCache;
            CommonBigInteger[] commonBigIntegerArray = pc[radix];
            Intrinsics.checkNotNull((Object)commonBigIntegerArray);
            if (exponent >= commonBigIntegerArray.length) {
                Object[] $this$cloneArray$iv = (Object[])pc;
                boolean $i$f$cloneArray = false;
                int n = 0;
                int n2 = $this$cloneArray$iv.length;
                CommonBigInteger[][] commonBigIntegerArrayArray = new CommonBigInteger[n2][];
                while (n < n2) {
                    int n3 = n++;
                    commonBigIntegerArrayArray[n3] = $this$cloneArray$iv[n3];
                }
                pc = commonBigIntegerArrayArray;
                pc[radix] = ArraysKt.requireNoNulls((Object[])cacheLine2);
                powerCache = pc;
            }
            CommonBigInteger commonBigInteger = cacheLine2[exponent];
            Intrinsics.checkNotNull((Object)commonBigInteger);
            return commonBigInteger;
        }

        private final int[] stripLeadingZeroInts(int[] other) {
            int vlen = other.length;
            int keep = 0;
            for (keep = 0; keep < vlen && other[keep] == 0; ++keep) {
            }
            return ArraysKt.copyOfRange((int[])other, (int)keep, (int)vlen);
        }

        private final int[] trustedStripLeadingZeroInts(int[] other) {
            int vlen = other.length;
            int keep = 0;
            for (keep = 0; keep < vlen && other[keep] == 0; ++keep) {
            }
            return keep == 0 ? other : ArraysKt.copyOfRange((int[])other, (int)keep, (int)vlen);
        }

        private final int[] stripLeadingZeroBytes(byte[] a, int off, int len) {
            int indexBound = off + len;
            int keep = 0;
            for (keep = off; keep < indexBound && a[keep] == 0; ++keep) {
            }
            int intLength = indexBound - keep + 3 >>> 2;
            int[] result = new int[intLength];
            int b = indexBound - 1;
            for (int i = intLength - 1; -1 < i; --i) {
                result[i] = a[b--] & 0xFF;
                int bytesRemaining = b - keep + 1;
                int bytesToTransfer = Math.min(3, bytesRemaining);
                for (int j = 8; j <= bytesToTransfer << 3; j += 8) {
                    result[i] = result[i] | (a[b--] & 0xFF) << j;
                }
            }
            return result;
        }

        private final int[] makePositive(byte[] a, int off, int len) {
            int keep = 0;
            int k = 0;
            int indexBound = off + len;
            for (keep = off; keep < indexBound && a[keep] == -1; ++keep) {
            }
            for (k = keep; k < indexBound && a[k] == 0; ++k) {
            }
            int extraByte = k == indexBound ? 1 : 0;
            int intLength = indexBound - keep + extraByte + 3 >>> 2;
            int[] result = new int[intLength];
            int b = indexBound - 1;
            for (int i = intLength - 1; -1 < i; --i) {
                result[i] = a[b--] & 0xFF;
                int numBytesToTransfer = Math.min(3, b - keep + 1);
                if (numBytesToTransfer < 0) {
                    numBytesToTransfer = 0;
                }
                for (int j = 8; j <= 8 * numBytesToTransfer; j += 8) {
                    result[i] = result[i] | (a[b--] & 0xFF) << j;
                }
                int mask = -1 >>> 8 * (3 - numBytesToTransfer);
                result[i] = ~result[i] & mask;
            }
            int n = result.length + -1;
            if (0 <= n) {
                int i;
                do {
                    i = n--;
                    result[i] = (int)(((long)result[i] & 0xFFFFFFFFL) + 1L);
                } while (result[i] == 0 && 0 <= n);
            }
            return result;
        }

        private final int[] makePositive(int[] a) {
            int i;
            int keep = 0;
            int j = 0;
            for (keep = 0; keep < a.length && a[keep] == -1; ++keep) {
            }
            for (j = keep; j < a.length && a[j] == 0; ++j) {
            }
            int extraInt = j == a.length ? 1 : 0;
            int[] result = new int[a.length - keep + extraInt];
            int n = a.length;
            for (i = keep; i < n; ++i) {
                result[i - keep + extraInt] = ~a[i];
            }
            i = result.length - 1;
            do {
                n = i--;
                result[n] = result[n] + 1;
            } while (result[n] == 0);
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

