/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.persistence;

import com.macrofocus.common.persistence.Attribute;
import com.macrofocus.common.persistence.DefaultElements;
import com.macrofocus.common.persistence.Element;
import com.macrofocus.common.persistence.Elements;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\fH\u0016J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0001H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006 "}, d2={"Lcom/macrofocus/common/persistence/DefaultElement;", "Lcom/macrofocus/common/persistence/Element;", "localName", "", "<init>", "(Ljava/lang/String;)V", "getLocalName", "()Ljava/lang/String;", "elemens", "Lcom/macrofocus/common/persistence/DefaultElements;", "attributes", "", "Lcom/macrofocus/common/persistence/Attribute;", "map", "", "attributeCount", "", "getAttributeCount", "()I", "getAttribute", "index", "key", "childElements", "Lcom/macrofocus/common/persistence/Elements;", "getChildElements", "()Lcom/macrofocus/common/persistence/Elements;", "getAttributeValue", "addAttribute", "", "attribute", "appendChild", "element", "macrofocus-common"})
public final class DefaultElement
implements Element {
    @NotNull
    private final String localName;
    @NotNull
    private final DefaultElements elemens;
    @NotNull
    private final List<Attribute> attributes;
    @NotNull
    private final Map<String, Attribute> map;

    public DefaultElement(@NotNull String localName) {
        Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
        this.localName = localName;
        this.elemens = new DefaultElements();
        this.attributes = new ArrayList();
        this.map = new HashMap();
    }

    @Override
    @NotNull
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public int getAttributeCount() {
        return this.attributes.size();
    }

    @Override
    @NotNull
    public Attribute getAttribute(int index) {
        return this.attributes.get(index);
    }

    @Override
    @NotNull
    public Attribute getAttribute(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Attribute attribute = this.map.get(key);
        Intrinsics.checkNotNull((Object)attribute);
        return attribute;
    }

    @Override
    @Nullable
    public Elements getChildElements() {
        return this.elemens;
    }

    @Override
    @NotNull
    public String getAttributeValue(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getAttribute(key).getValue();
    }

    @Override
    public void addAttribute(@NotNull Attribute attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        this.attributes.add(attribute);
        this.map.put(attribute.getQualifiedName(), attribute);
    }

    @Override
    public void appendChild(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.elemens.appendChild(element);
    }
}

