/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.timer;

import com.macrofocus.common.timer.AbstractCPTimer;
import com.macrofocus.common.timer.CPTimerListener;
import com.macrofocus.common.timer.CoalescingTimer;
import com.macrofocus.common.timer.Timer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB+\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\u0013J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/macrofocus/common/timer/SwingTimer;", "Lcom/macrofocus/common/timer/AbstractCPTimer;", "name", "", "delay", "", "postponing", "", "<init>", "(Ljava/lang/String;IZ)V", "keepAlive", "(Ljava/lang/String;IIZ)V", "timer", "Lcom/macrofocus/common/timer/CoalescingTimer;", "keepAliveTimer", "timerThread", "Ljava/lang/Thread;", "keepAliveThread", "restart", "", "stop", "toString", "macrofocus-common"})
public final class SwingTimer
extends AbstractCPTimer {
    @Nullable
    private final String name;
    @NotNull
    private CoalescingTimer timer;
    @Nullable
    private CoalescingTimer keepAliveTimer;
    @Nullable
    private Thread timerThread;
    @Nullable
    private Thread keepAliveThread;

    public SwingTimer(@Nullable String name, int delay, boolean postponing) {
        this.name = name;
        this.timer = new CoalescingTimer(delay, postponing);
        this.keepAliveTimer = null;
        this.timer.addActionListener(new Timer.TimerListener(){

            @Override
            public void timerTriggered() {
                for (CPTimerListener listener2 : this.getListeners()) {
                    listener2.timerTriggered();
                }
            }
        });
    }

    public SwingTimer(@Nullable String name, int delay, int keepAlive, boolean postponing) {
        boolean bl;
        this.name = name;
        boolean bl2 = bl = keepAlive > delay;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.timer = new CoalescingTimer(delay, postponing);
        this.keepAliveTimer = new CoalescingTimer(keepAlive, false, 2, null);
        this.timer.addActionListener(new Timer.TimerListener(){

            @Override
            public void timerTriggered() {
                for (CPTimerListener listener2 : this.getListeners()) {
                    listener2.timerTriggered();
                }
            }
        });
        CoalescingTimer coalescingTimer = this.keepAliveTimer;
        Intrinsics.checkNotNull((Object)coalescingTimer);
        coalescingTimer.addActionListener(new Timer.TimerListener(){

            @Override
            public void timerTriggered() {
                timer.stop();
                CoalescingTimer coalescingTimer = keepAliveTimer;
                Intrinsics.checkNotNull((Object)coalescingTimer);
                coalescingTimer.stop();
                keepAliveThread = null;
                timerThread = null;
            }
        });
    }

    @Override
    public void restart() {
        block10: {
            block9: {
                block8: {
                    block7: {
                        if (this.timerThread == null) break block7;
                        Thread thread = this.timerThread;
                        Intrinsics.checkNotNull((Object)thread);
                        if (thread.isAlive()) break block8;
                    }
                    Thread thread = this.timerThread = new Thread(this.timer);
                    Intrinsics.checkNotNull((Object)thread);
                    thread.setName((String)(this.name != null ? this.name + "$Timer" : "Coalescing$Timer"));
                    Thread thread2 = this.timerThread;
                    Intrinsics.checkNotNull((Object)thread2);
                    thread2.setDaemon(true);
                    Thread thread3 = this.timerThread;
                    Intrinsics.checkNotNull((Object)thread3);
                    thread3.start();
                }
                if (this.keepAliveTimer != null && this.keepAliveThread == null) break block9;
                Thread thread = this.keepAliveThread;
                Intrinsics.checkNotNull((Object)thread);
                if (thread.isAlive()) break block10;
            }
            Thread thread = this.keepAliveThread = new Thread(this.keepAliveTimer);
            Intrinsics.checkNotNull((Object)thread);
            thread.setName((String)(this.name != null ? this.name + "$KeepAlive" : "Coalescing$KeepAlive"));
            Thread thread4 = this.keepAliveThread;
            Intrinsics.checkNotNull((Object)thread4);
            thread4.setDaemon(true);
            Thread thread5 = this.keepAliveThread;
            Intrinsics.checkNotNull((Object)thread5);
            thread5.start();
        }
        this.timer.restart();
        if (this.keepAliveTimer != null) {
            CoalescingTimer coalescingTimer = this.keepAliveTimer;
            Intrinsics.checkNotNull((Object)coalescingTimer);
            coalescingTimer.restart();
        }
    }

    public final void stop() {
        this.timer.stop();
        if (this.keepAliveTimer != null) {
            CoalescingTimer coalescingTimer = this.keepAliveTimer;
            Intrinsics.checkNotNull((Object)coalescingTimer);
            coalescingTimer.stop();
        }
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public String toString() {
        if (this.timerThread == null) ** GOTO lbl-1000
        v0 = this.timerThread;
        Intrinsics.checkNotNull((Object)v0);
        if (v0.isAlive()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        if (this.keepAliveThread == null) ** GOTO lbl-1000
        v2 = this.keepAliveThread;
        Intrinsics.checkNotNull((Object)v2);
        if (v2.isAlive()) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        return "SwingTimer{timer=" + this.timer + "timerThread=" + v1 + "keepAliveThread=" + v3 + "}";
    }
}

