/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.order;

import com.macrofocus.common.collection.CollectionFactory;
import com.macrofocus.common.collection.WeakReference;
import com.macrofocus.order.Order;
import com.macrofocus.order.OrderEvent;
import com.macrofocus.order.OrderListener;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0016J\u0016\u0010\u000b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0016J\u0016\u0010\f\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0016J\u0006\u0010\r\u001a\u00020\tJ\u0018\u0010\u000e\u001a\u00020\t2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0010H\u0004J\u0016\u0010\u0011\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0004J\u0016\u0010\u0012\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0004J\u0016\u0010\u0013\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0004R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/macrofocus/order/AbstractOrder;", "E", "Lcom/macrofocus/order/Order;", "<init>", "()V", "listeners", "", "Lcom/macrofocus/order/OrderListener;", "addOrderListener", "", "listener", "addWeakOrderListener", "removeOrderListener", "removeFilterListeners", "notifyOrderChanged", "event", "Lcom/macrofocus/order/OrderEvent;", "notifyOrderVisibility", "notifyOrderAdded", "notifyOrderRemoved", "WeakOrderListener", "macrofocus-common"})
public abstract class AbstractOrder<E>
implements Order<E> {
    @NotNull
    private final List<OrderListener<E>> listeners = CollectionFactory.INSTANCE.copyOnWriteArrayList();

    @Override
    public void addOrderListener(@NotNull OrderListener<E> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void addWeakOrderListener(@NotNull OrderListener<E> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.listeners.add(new WeakOrderListener(listener2));
    }

    @Override
    public void removeOrderListener(@NotNull OrderListener<E> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        if (listener2 instanceof WeakOrderListener) {
            boolean bl = this.listeners.remove(listener2);
        } else {
            OrderListener<E> toRemove = null;
            for (OrderListener<E> orderListener : this.listeners) {
                OrderListener<E> comparable = null;
                comparable = orderListener instanceof WeakOrderListener ? ((WeakOrderListener)orderListener).getReference() : orderListener;
                if (!Intrinsics.areEqual(listener2, comparable)) continue;
                toRemove = orderListener;
            }
            if (toRemove != null) {
                boolean bl = this.listeners.remove(toRemove);
            }
        }
    }

    public final void removeFilterListeners() {
        this.listeners.clear();
    }

    protected final void notifyOrderChanged(@Nullable OrderEvent<E> event) {
        for (OrderListener<E> listener2 : this.listeners) {
            listener2.orderChanged(event);
        }
    }

    protected final void notifyOrderVisibility(@NotNull OrderEvent<E> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        for (OrderListener<E> listener2 : this.listeners) {
            listener2.orderVisibility(event);
        }
    }

    protected final void notifyOrderAdded(@NotNull OrderEvent<E> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        for (OrderListener<E> listener2 : this.listeners) {
            listener2.orderAdded(event);
        }
    }

    protected final void notifyOrderRemoved(@NotNull OrderEvent<E> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        for (OrderListener<E> listener2 : this.listeners) {
            listener2.orderRemoved(event);
        }
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\nH\u0016J\u0016\u0010\u000b\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016J\u0016\u0010\f\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016J\u0016\u0010\r\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/macrofocus/order/AbstractOrder$WeakOrderListener;", "Lcom/macrofocus/order/OrderListener;", "listener", "<init>", "(Lcom/macrofocus/order/AbstractOrder;Lcom/macrofocus/order/OrderListener;)V", "l_ref", "Lcom/macrofocus/common/collection/WeakReference;", "orderChanged", "", "event", "Lcom/macrofocus/order/OrderEvent;", "orderVisibility", "orderAdded", "orderRemoved", "reference", "getReference", "()Lcom/macrofocus/order/OrderListener;", "macrofocus-common"})
    private final class WeakOrderListener
    implements OrderListener<E> {
        @NotNull
        private final WeakReference<OrderListener<E>> l_ref;

        public WeakOrderListener(OrderListener<E> listener2) {
            Intrinsics.checkNotNullParameter(listener2, (String)"listener");
            this.l_ref = new WeakReference(listener2);
        }

        @Override
        public void orderChanged(@Nullable OrderEvent<E> event) {
            OrderListener l = this.getReference();
            if (l != null) {
                l.orderChanged(event);
            } else {
                Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type com.macrofocus.order.OrderListener<E of com.macrofocus.order.AbstractOrder>");
                AbstractOrder.this.removeOrderListener(this);
            }
        }

        @Override
        public void orderVisibility(@NotNull OrderEvent<E> event) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            OrderListener l = this.getReference();
            if (l != null) {
                l.orderVisibility(event);
            } else {
                Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type com.macrofocus.order.OrderListener<E of com.macrofocus.order.AbstractOrder>");
                AbstractOrder.this.removeOrderListener(this);
            }
        }

        @Override
        public void orderAdded(@NotNull OrderEvent<E> event) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            OrderListener l = this.getReference();
            if (l != null) {
                l.orderAdded(event);
            } else {
                Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type com.macrofocus.order.OrderListener<E of com.macrofocus.order.AbstractOrder>");
                AbstractOrder.this.removeOrderListener(this);
            }
        }

        @Override
        public void orderRemoved(@NotNull OrderEvent<E> event) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            OrderListener l = this.getReference();
            if (l != null) {
                l.orderRemoved(event);
            } else {
                Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type com.macrofocus.order.OrderListener<E of com.macrofocus.order.AbstractOrder>");
                AbstractOrder.this.removeOrderListener(this);
            }
        }

        @Nullable
        public final OrderListener<E> getReference() {
            return this.l_ref.get();
        }
    }
}

