/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.order;

import com.macrofocus.common.collection.CollectionFactory;
import com.macrofocus.order.AbstractOrder;
import com.macrofocus.order.MutableVisibleOrder;
import com.macrofocus.order.Order;
import com.macrofocus.order.OrderEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0005\"\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH\u0096\u0002\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\rH\u0016J\u0015\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0017\u0010\u0013\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0017\u0010\u0015\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\rH\u0016J\u0015\u0010\u0019\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0016J\u0015\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001d\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010 \u001a\u00020!H\u0016\u00a2\u0006\u0002\u0010\"J\u001d\u0010#\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010 \u001a\u00020!H\u0016\u00a2\u0006\u0002\u0010\"J\u0016\u0010$\u001a\u00020\u001d2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000%H\u0016J$\u0010&\u001a\u00020\u001d2\u001a\u0010'\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0018\u00010(j\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`)H\u0016J%\u0010*\u001a\u00020\u001d2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0086\u0002J\u0015\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010-\u001a\u00020\u001d2\u0006\u0010,\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001d\u0010.\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020!H\u0016\u00a2\u0006\u0002\u0010\"J\u0016\u0010/\u001a\u00020\u001d2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0016J\u0016\u00100\u001a\u00020\u001d2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0016J!\u0010/\u001a\u00020\u001d2\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0005\"\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0007J!\u00100\u001a\u00020\u001d2\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0005\"\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0007J\u0015\u00101\u001a\u00020!2\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00102J\u0017\u00103\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0014J&\u00104\u001a\u00020\u001d2\f\u00105\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u00106\u001a\u00020\r2\u0006\u00107\u001a\u00020\rH\u0002J\b\u00108\u001a\u000209H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/macrofocus/order/DefaultVisibleOrder;", "E", "Lcom/macrofocus/order/AbstractOrder;", "Lcom/macrofocus/order/MutableVisibleOrder;", "elements", "", "<init>", "([Ljava/lang/Object;)V", "all", "", "visible", "get", "index", "", "(I)Ljava/lang/Object;", "size", "indexOf", "element", "(Ljava/lang/Object;)I", "previous", "(Ljava/lang/Object;)Ljava/lang/Object;", "next", "iterator", "", "sizeAll", "getAll", "iterableAll", "", "moveToFirst", "", "(Ljava/lang/Object;)V", "moveToPrevious", "skipHidden", "", "(Ljava/lang/Object;Z)V", "moveToNext", "setOrder", "", "sort", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "set", "add", "axisModel", "remove", "setVisible", "show", "hide", "isVisible", "(Ljava/lang/Object;)Z", "findPreviousVisible", "swap", "list", "a", "b", "toString", "", "macrofocus-common"})
public final class DefaultVisibleOrder<E>
extends AbstractOrder<E>
implements MutableVisibleOrder<E> {
    @NotNull
    private final List<E> all;
    @NotNull
    private final List<E> visible;

    public DefaultVisibleOrder(E ... elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.all = CollectionFactory.INSTANCE.copyOnWriteArrayList();
        this.visible = CollectionFactory.INSTANCE.copyOnWriteArrayList();
        for (E element : elements) {
            this.all.add(element);
            this.visible.add(element);
        }
    }

    @Override
    public E get(int index) {
        return this.visible.get(index);
    }

    @Override
    public int size() {
        return this.visible.size();
    }

    @Override
    public int indexOf(E element) {
        return this.visible.indexOf(element);
    }

    @Override
    @Nullable
    public E previous(E element) {
        int index = this.visible.indexOf(element);
        return index > 0 ? (E)this.visible.get(index - 1) : null;
    }

    @Override
    @Nullable
    public E next(E element) {
        int index = this.visible.indexOf(element);
        return index < this.visible.size() - 1 ? (E)this.visible.get(index + 1) : null;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.visible.iterator();
    }

    @Override
    public int sizeAll() {
        return this.all.size();
    }

    @Override
    public E getAll(int index) {
        return this.all.get(index);
    }

    @Override
    @NotNull
    public Iterable<E> iterableAll() {
        return this.all;
    }

    @Override
    public void moveToFirst(E element) {
        while (this.indexOf(element) > 0) {
            this.moveToPrevious(element, false);
        }
    }

    @Override
    public void moveToPrevious(E element, boolean skipHidden) {
        int index;
        if (this.visible.contains(element) && (index = this.indexOf(element)) > 0) {
            if (skipHidden) {
                throw new UnsupportedOperationException();
            }
            int i = this.all.indexOf(element);
            this.swap(this.all, i - 1, i);
            this.swap(this.visible, index - 1, index);
            this.notifyOrderChanged(null);
        }
    }

    @Override
    public void moveToNext(E element, boolean skipHidden) {
        int index;
        if (this.visible.contains(element) && (index = this.indexOf(element)) < this.visible.size() - 1) {
            if (skipHidden) {
                throw new UnsupportedOperationException();
            }
            int i = this.all.indexOf(element);
            this.swap(this.all, i + 1, i);
            this.swap(this.visible, index + 1, index);
            this.notifyOrderChanged(null);
        }
    }

    @Override
    public void setOrder(@NotNull List<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int n = ((Collection)elements).size();
        for (int i = 0; i < n; ++i) {
            E e = elements.get(i);
            this.visible.set(i, e);
        }
        int j = 0;
        int n2 = ((Collection)this.all).size();
        for (int i = 0; i < n2; ++i) {
            E e = this.all.get(i);
            if (!this.isVisible(e)) continue;
            this.all.set(i, elements.get(j));
            ++j;
        }
        this.notifyOrderChanged(null);
    }

    @Override
    public void sort(@Nullable Comparator<E> comparator) {
    }

    public final void set(@NotNull Iterable<? extends E> all, @NotNull Iterable<? extends E> visible) {
        Intrinsics.checkNotNullParameter(all, (String)"all");
        Intrinsics.checkNotNullParameter(visible, (String)"visible");
        List a = new ArrayList();
        List v = new ArrayList();
        for (E element : all) {
            a.add(element);
        }
        for (E element : visible) {
            v.add(element);
        }
        this.all.clear();
        this.all.addAll(a);
        this.visible.clear();
        this.visible.addAll(v);
        this.notifyOrderChanged(new OrderEvent<E>((Order)this, visible));
    }

    @Override
    public void add(E axisModel) {
        this.visible.add(axisModel);
        this.all.add(axisModel);
        this.notifyOrderAdded(new OrderEvent<E>((Order)this, axisModel));
    }

    @Override
    public void remove(E axisModel) {
        this.visible.remove(axisModel);
        this.all.remove(axisModel);
        this.notifyOrderRemoved(new OrderEvent<E>((Order)this, axisModel));
    }

    @Override
    public void setVisible(E element, boolean visible) {
        if (visible) {
            if (!this.visible.contains(element)) {
                E previous = this.findPreviousVisible(element);
                if (previous != null) {
                    this.visible.add(this.visible.indexOf(previous) + 1, element);
                } else {
                    this.visible.add(0, element);
                }
                this.notifyOrderVisibility(new OrderEvent<E>((Order)this, element));
            }
        } else if (this.visible.contains(element)) {
            this.visible.remove(element);
            this.notifyOrderVisibility(new OrderEvent<E>((Order)this, element));
        }
    }

    @Override
    public void show(@NotNull Iterable<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        List affected = new ArrayList();
        for (E element : elements) {
            if (this.visible.contains(element)) continue;
            E previous = this.findPreviousVisible(element);
            if (previous != null) {
                this.visible.add(this.visible.indexOf(previous) + 1, element);
            } else {
                this.visible.add(0, element);
            }
            affected.add(element);
        }
        if (affected.size() > 0) {
            this.notifyOrderVisibility(new OrderEvent((Order)this, affected));
        }
    }

    @Override
    public void hide(@NotNull Iterable<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        List affected = new ArrayList();
        for (E element : elements) {
            if (!this.visible.contains(element)) continue;
            this.visible.remove(element);
            affected.add(element);
        }
        if (affected.size() > 0) {
            this.notifyOrderVisibility(new OrderEvent((Order)this, affected));
        }
    }

    @Override
    public void show(E ... elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        List affected = new ArrayList();
        for (E element : elements) {
            if (this.visible.contains(element)) continue;
            E previous = this.findPreviousVisible(element);
            if (previous != null) {
                this.visible.add(this.visible.indexOf(previous) + 1, element);
            } else {
                this.visible.add(0, element);
            }
            affected.add(element);
        }
        if (affected.size() > 0) {
            this.notifyOrderVisibility(new OrderEvent((Order)this, affected));
        }
    }

    @Override
    public void hide(E ... elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        List affected = new ArrayList();
        for (E element : elements) {
            if (!this.visible.contains(element)) continue;
            this.visible.remove(element);
            affected.add(element);
        }
        if (affected.size() > 0) {
            this.notifyOrderVisibility(new OrderEvent((Order)this, affected));
        }
    }

    @Override
    public boolean isVisible(E element) {
        return this.visible.contains(element);
    }

    private final E findPreviousVisible(E element) {
        for (int i = this.all.indexOf(element) - 1; -1 < i; --i) {
            E e = this.all.get(i);
            if (!this.isVisible(e)) continue;
            return e;
        }
        return null;
    }

    private final void swap(List<E> list, int a, int b) {
        E t = list.get(a);
        list.set(a, list.get(b));
        list.set(b, t);
    }

    @NotNull
    public String toString() {
        Object visible = null;
        visible = "";
        DefaultVisibleOrder $this$toString_u24lambda_u240 = this;
        boolean bl = false;
        boolean first = true;
        for (E s : $this$toString_u24lambda_u240.visible) {
            if (!first) {
                visible = visible + ",";
            } else {
                first = false;
            }
            visible = "" + visible + s;
        }
        Object all = null;
        all = "";
        DefaultVisibleOrder $this$toString_u24lambda_u241 = this;
        boolean bl2 = false;
        boolean first2 = true;
        for (E s : $this$toString_u24lambda_u241.all) {
            if (!first2) {
                all = all + ",";
            } else {
                first2 = false;
            }
            all = "" + all + s;
        }
        return "DefaultVisibleOrder{visible=" + visible + ",all=" + all + "}";
    }
}

