/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.selection

import com.macrofocus.common.collection.Iterables
import com.macrofocus.common.collection.Iterables.conditional

/**
 * Created by luc on 20/04/16.
 */
abstract class AbstractSelectionEvent<E> : SelectionEvent<E> {
    override val selected: Iterable<E>
        get() = conditional(
            affected,
            object : Iterables.Condition<E> {
                override fun apply(element: E): Boolean {
                    return model.isSelected(element)
                }
            })

    override val unselected: Iterable<E>
        get() = conditional(
            affected,
            object : Iterables.Condition<E> {
                override fun apply(element: E): Boolean {
                    return !model.isSelected(element)
                }
            })
}