package com.macrofocus.common.helper

import java.awt.event.ActionEvent
import java.awt.event.ActionListener
import java.lang.ref.WeakReference

class WeakActionListener(listener: ActionListener, var src: Any) : ActionListener {
    var listenerRef: WeakReference<ActionListener> = WeakReference(listener)

    override fun actionPerformed(evt: ActionEvent) {
        val listener = listenerRef.get()
        if (listener == null) {
            removeListener()
        } else listener.actionPerformed(evt)
    }

    private fun removeListener() {
        try {
            val method = src.javaClass.getMethod(
                "removeActionListener",
                ActionListener::class.java
            )
            method.invoke(src, this)
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }
}